<nav aria-label="Page navigation" class="pagination-wrap">
	<?php
        function egns_tour_pagination() {
            global $wp_query;
            $links = paginate_links( array(
                'base' => "#%#%", //will make hrefs like "#3"
                'current'  => max( 1, get_query_var( 'paged' ) ),
                'total'    => $wp_query->max_num_pages,
                'type'     => 'list',
                'mid_size' => apply_filters( "egns_pagination_mid_size", 3 ),
                'prev_text'    => '<i class="bi bi-arrow-left"></i> PREV',
                'next_text'    => 'NEXT <i class="bi bi-arrow-right"></i> ',
            ) );
            $links = str_replace( "<ul class='page-numbers'>", "<ul class='pagination d-flex justify-content-center gap-md-3 gap-2'>", $links );
            $links = str_replace( "<li>", "<li>", $links );
            $links = str_replace( "page-numbers", "", $links );
            $links = str_replace( "&laquo; Previous</a>", '&laquo;</a>', $links );
            $links = str_replace( "Next &raquo;</a>", "&raquo;</a>", $links );
            $links = str_replace( "next aria-label='Next'", "page-link", $links );
            $links = str_replace( "prev aria-hidden='true'", "sr-only page-link", $links );
            $links = str_replace( "<li><span", " <li class='active'><a class='tour_pagination_link'", $links );
            $links = str_replace( 'span', 'a', $links );
            $links = preg_replace('/>([0-9])</', '>0$1<', $links);
            
            echo wp_kses_post( $links );
        }
        egns_tour_pagination();
	?>
</nav>