<?php
$args = array(
    'post_type' => 'astrip-destination',
);
$wp_query_destination = new WP_Query($args);
$all_destination = Egns_Helpers::egns_get_tour_destination();
$all_tour_type      = get_terms(
    array(
        'taxonomy'   => 'astrip-tour-type',
        'hide_empty' => false
    )
);

// Get minimum and Maximum price from woocommerce
$args = array(
    'post_type' => 'product',
    'post_status' => 'publish',
    'posts_per_page' => -1,
    'fields' => 'ids',
);
$product_ids = get_posts($args);
$min_price = PHP_INT_MAX;
$max_price = 0;
if( class_exists('Woocommerce') ) {
    foreach ($product_ids as $product_id) {
        $product = wc_get_product($product_id);
        $price = $product->get_price();
        if ($price < $min_price) {
            $min_price = $price;
        }
        if ($price > $max_price) {
            $max_price = $price;
        }
    }
}

?>

<div class="tour-package-sidebar pe-lg-4">
    <div class="package-sidebar-close">
        <i class="bi bi-x-circle"></i>
    </div>
    <div class="sidebar-search mb-35">
        <form id="tourSearch" method="GET">
            <div class="form-inner">
                <input type="text" id="tourSearchKeyword" placeholder="Search">
                <button type="submit"><i class='bx bx-search'></i></button>
            </div>
        </form>
    </div>
    <div class="tour-package-widget">
        <h4 class="package-widget-title"><?php echo esc_html__('Choose Destination', 'astrip') ?></h4>
        <div class="select-widget">
            <select class="defult-select-drowpown" data-placeholder="" id="tourDestinationDropdown">
                <option value=""><?php echo esc_html__('Select Destination','astrip') ?></option>

                    <?php foreach ( (array) $all_destination as $key => $destination) : ?>
                        <option value="<?php echo esc_html($key) ?>"><?php echo esc_html($destination) ?></option>
                    <?php endforeach ?>
            </select>
            <div class="clearfix"></div>
        </div>
    </div>
    <?php if( class_exists('Woocommerce') ) : ?>
    <div class="tour-package-widget">
        <h4 class="package-widget-title"><?php echo  sprintf( esc_html__('Price Range (%s)','astrip'), get_woocommerce_currency_symbol() ) ?></h4>
        <div class="range-widget">
            <div id="slider-range" class="price-filter-range"></div>
            <div class="mt-5 d-flex justify-content-between gap-4">
                <input type="number" min=<?php echo esc_html($min_price) ?> max="<?php echo esc_html($max_price) ?>" oninput="validity.valid||(value='<?php echo esc_html($min_price) ?>');" id="min_price" class="price-range-field" />
                <input type="number" min=<?php echo esc_html($min_price) ?> max="<?php echo esc_html($max_price) ?>" oninput="validity.valid||(value='<?php echo esc_html($max_price) ?>');" id="max_price" class="price-range-field" />
            </div>
        </div>
    </div>
    <?php endif ?>
    <div class="tour-package-widget">
        <div class="check-box-item">
            <h5><?php echo esc_html__('Tour Type', 'astrip') ?></h5>
            <div class="checkbox-container">
                <?php foreach ($all_tour_type as $tour_type) : ?>
                    <label class="check-container"><?php echo esc_html($tour_type->name) ?? '' ?>
                        <input class="tourType" value="<?php echo esc_html($tour_type->term_id) ?? '' ?>" type="checkbox">
                        <span class="checkmark"></span>
                    </label>
                <?php endforeach ?>
            </div>
        </div>
    </div>
</div>
<div class="row d-lg-none d-flex">
    <div class="col-12">
        <div class="package-filter-area text-end">
            <h4><?php echo esc_html__('Filter Package','astrip') ?></h4>
            <div class="filter-button">
                <img src="<?php echo esc_url( get_template_directory_uri().'/assets/images/icons/filter-icon.svg' ) ?>" alt="<?php echo esc_attr('filter-icons') ?>">
            </div>
        </div>
    </div>
</div>