<?php

$tour_breadcrumb_image = Egns_Helpers::egns_post_meta_box_value(EGNS_TOUR_META_ID, 'tour_breadcrumb_image');

?>
<div class="inner-banner-section <?php echo (!empty(Egns_Helpers::egns_post_meta_box_value(EGNS_TOUR_META_ID, 'tour_video_and_gallery_options')) && Egns_Helpers::egns_post_meta_box_value(EGNS_TOUR_META_ID, 'tour_video_and_gallery_options') == 'breadcrumb_video') ? 'sibling-2 content-none' : 'sibling-2' ?>" style="background-image: url(<?php echo esc_url($tour_breadcrumb_image['url']) ? esc_url( $tour_breadcrumb_image['url'] ) : ''  ?>)">
    <?php if (!empty(Egns_Helpers::egns_post_meta_box_value(EGNS_TOUR_META_ID, 'tour_video_and_gallery_options')) && Egns_Helpers::egns_post_meta_box_value(EGNS_TOUR_META_ID, 'tour_video_and_gallery_options') == 'breadcrumb_img' ) : ?>
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-xl-8 col-md-10 col-sm-12">
                    <div class="breadcrumb-area">
                        <?php
                        $tour_type = wp_get_post_terms(get_the_ID(), 'astrip-tour-type',  array("fields" => "names"));
                        if (!empty($tour_type)) {
                            echo '<span>' . implode(", ", $tour_type) . '</span>';
                        }
                        ?>

                        <h2><?php the_title(); ?></h2>
                        <div class="review-area">
                        <?php if( Egns_Helpers::egns_get_avg_rating_by_tour_id( get_the_ID() ) > 0 ) : ?>
                            <ul class="star-list">
                                <?php 
                                    for ($x = 1; $x <= 5; $x++) {
                                        if( Egns_Helpers::egns_get_avg_rating_by_tour_id( get_the_ID() ) >= $x ) {
                                            echo wp_kses_post( '<li><i class="bi bi-star-fill"></i></li>' );
                                        }else{
                                            echo wp_kses_post( '<li><i class="bi bi-star"></i></li>' );
                                        }
                                    }
                                ?>
                            </ul>
                            <span>(<?php echo Egns_Helpers::egns_get_all_rating_count_by_tour_id( get_the_ID() ); ?> <?php echo Egns_Helpers::egns_get_all_rating_count_by_tour_id( get_the_ID() ) == 1 ? esc_html__('Review','astrip') : esc_html__('Reviews','astrip') ?>)</span>
                        <?php endif ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    <?php endif ?>
    <!-- Breadcrumb video  -->
    <?php if (!empty(Egns_Helpers::egns_post_meta_box_value(EGNS_TOUR_META_ID, 'tour_video_and_gallery_options')) && Egns_Helpers::egns_post_meta_box_value(EGNS_TOUR_META_ID, 'tour_video_and_gallery_options') == 'breadcrumb_video') : ?>
        <div class="video-breadcrumb">
            <video autoplay="true" height="100" loop="loop" muted="" preload="auto">
                <source src="<?php echo esc_url(Egns_Helpers::egns_post_meta_box_value(EGNS_TOUR_META_ID, 'tour_breadcrumb_video')['url']) ?>" type="video/mp4">
            </video>
            <div class="container video-content">
                <div class="row justify-content-center">
                    <div class="col-xl-8 col-md-10 col-sm-12">
                        <div class="breadcrumb-area">
                            <?php
                            $tour_type = wp_get_post_terms(get_the_ID(), 'astrip-tour-type',  array("fields" => "names"));
                            if (!empty($tour_type)) {
                                echo '<span>' . implode(", ", $tour_type) . '</span>';
                            }
                            ?>

                            <h2><?php the_title(); ?></h2>
                            <div class="review-area">
                                <?php if( Egns_Helpers::egns_get_avg_rating_by_tour_id( get_the_ID() ) > 0 ) : ?>
                                    <ul class="star-list">
                                        <?php 
                                            for ($x = 1; $x <= 5; $x++) {
                                                if( Egns_Helpers::egns_get_avg_rating_by_tour_id( get_the_ID() ) >= $x ) {
                                                    echo wp_kses_post( '<li><i class="bi bi-star-fill"></i></li>' );
                                                }else{
                                                    echo wp_kses_post( '<li><i class="bi bi-star"></i></li>' );
                                                }
                                            }
                                        ?>
                                    </ul>
                                    <span>(<?php echo Egns_Helpers::egns_get_all_rating_count_by_tour_id( get_the_ID() ); ?> <?php echo Egns_Helpers::egns_get_all_rating_count_by_tour_id( get_the_ID() ) == 1 ? esc_html__('Review','astrip') : esc_html__('Reviews','astrip') ?>)</span>
                                <?php endif ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    <?php endif ?>

    <!-- Breadcrumb slider  -->
    <?php if (!empty(Egns_Helpers::egns_post_meta_box_value(EGNS_TOUR_META_ID, 'tour_video_and_gallery_options')) && Egns_Helpers::egns_post_meta_box_value(EGNS_TOUR_META_ID, 'tour_video_and_gallery_options') == 'breadcrumb_gallery') : ?>

        <div class="swiper breadcrumb-slider">
            <div class="swiper-wrapper">
                <?php
                if (!empty(Egns_Helpers::egns_post_meta_box_value(EGNS_TOUR_META_ID, 'tour_video_and_gallery')) && !empty(Egns_Helpers::egns_post_meta_box_value(EGNS_TOUR_META_ID, 'tour_breadcrumb_image'))) :

                    $gallery_imgs = Egns_Helpers::egns_post_meta_box_value(EGNS_TOUR_META_ID, 'tour_breadcrumb_gallery');
                    $gallery_img = explode(',', $gallery_imgs);

                    foreach ($gallery_img as $img) :
                ?>
                        <div class="swiper-slide" style="background-image: url(<?php echo wp_get_attachment_url($img) ?>">
                            <div class="container">
                                <div class="row justify-content-center">
                                    <div class="col-xl-8 col-md-10 col-sm-12">
                                        <div class="breadcrumb-area">
                                            <?php
                                            $tour_type = wp_get_post_terms(get_the_ID(), 'astrip-tour-type',  array("fields" => "names"));
                                            if (!empty($tour_type)) {
                                                echo '<span>' . implode(", ", $tour_type) . '</span>';
                                            }
                                            ?>

                                            <h2><?php the_title(); ?></h2>
                                            <div class="review-area">
                                                <?php if( Egns_Helpers::egns_get_avg_rating_by_tour_id( get_the_ID() ) > 0 ) : ?>
                                                    <ul class="star-list">
                                                        <?php 
                                                            for ($x = 1; $x <= 5; $x++) {
                                                                if( Egns_Helpers::egns_get_avg_rating_by_tour_id( get_the_ID() ) >= $x ) {
                                                                    echo wp_kses_post( '<li><i class="bi bi-star-fill"></i></li>' );
                                                                }else{
                                                                    echo wp_kses_post( '<li><i class="bi bi-star"></i></li>' );
                                                                }
                                                            }
                                                        ?>
                                                    </ul>
                                                    <?php if( Egns_Helpers::egns_get_all_rating_count_by_tour_id( get_the_ID() ) > 0 ) : ?>
                                                        <span>(<?php echo Egns_Helpers::egns_get_all_rating_count_by_tour_id( get_the_ID() ); ?> <?php echo Egns_Helpers::egns_get_all_rating_count_by_tour_id( get_the_ID() ) == 1 ? esc_html__('Review','astrip') : esc_html__('Reviews','astrip') ?>)</span>
                                                    <?php endif ?>
                                                <?php endif ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                <?php

                    endforeach;
                endif;

                ?>

            </div>
        </div>
    <?php endif ?>

</div>