<?php

$enable_breadcrumb_by_theme = Egns_Helpers::egns_get_theme_option('breadcrumb_enable');
$breadcrumb_enable_by_page = Egns_Helpers::egns_page_option_value('enable_breadcrumb');

$page_breadcrumb_image = Egns_Helpers::egns_page_option_value('breadcrumb_page_bg_image');

if (Egns_Helpers::is_enabled($enable_breadcrumb_by_theme, $breadcrumb_enable_by_page)) { ?>

    <?php if (isset($page_breadcrumb_image['url'])) : ?>
        <div class="inner-banner-section" style="background-image: url(<?php echo esc_url($page_breadcrumb_image['url']) ?>)">
        <?php else : ?>
            <div class="inner-banner-section">
            <?php endif ?>
            <div class="container">
                <div class="row justify-content-center">
                    <div class="col-xl-8 col-md-10 col-sm-12">
                        <div class="breadcrumb-area">
                            <?php
                            $destination = get_the_title(get_query_var('tour_destination', FALSE));
                            $tour_type  = get_term(get_query_var('tour_type'), 'astrip-tour-type');
                            ?>
                            <?php if (!empty(Egns_Helpers::egns_page_option_value('breadcrumb_subtitle'))) : ?>
                                <span><?php echo esc_html(Egns_Helpers::egns_page_option_value('breadcrumb_subtitle')) ?></span>
                            <?php endif; ?>
                            <?php if (!empty(get_query_var('tour_destination')) || !empty(get_query_var('tour_type')) || !empty(get_query_var('tour_month'))) : ?>
                                <h2> <?php echo esc_html__('Package Search Result', 'astrip') ?></h2>
                            <?php else : ?>
                                <?php if (is_post_type_archive('astrip-tour')) : ?>
                                    <h2><?php echo esc_html__('Tour', 'astrip') ?></h2>
                                <?php else : ?>
                                    <h2><?php echo get_the_title() ?></h2>
                                <?php endif ?>
                            <?php endif ?>
                            <div class="query-data">
                                <?php if (!empty(get_query_var('tour_destination', FALSE))) : ?>
                                    <h5><b><?php echo esc_html__('Destination: ', 'astrip') ?></b><?php echo esc_html($destination); ?></h5>
                                <?php endif ?>
                                <?php if (!empty(get_query_var('tour_type'))) : ?>
                                    <h5><b><?php echo esc_html__('Tour Type: ', 'astrip') ?></b><?php echo esc_html($tour_type->name); ?></h5>
                                <?php endif ?>
                                <?php if (!empty(get_query_var('tour_month'))) : ?>
                                    <h5><b><?php echo esc_html__('Month: ', 'astrip') ?></b><?php echo esc_html(date("F", mktime(0, 0, 0, get_query_var('tour_month'), 1))); ?></h5>
                                <?php endif ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            </div>
        <?php
    };
