<?php

$enable_breadcrumb_by_theme = Egns_Helpers::egns_get_theme_option('breadcrumb_enable');
$breadcrumb_enable_by_page = Egns_Helpers::egns_page_option_value('enable_breadcrumb');

$page_breadcrumb_image = Egns_Helpers::egns_page_option_value('breadcrumb_page_bg_image');


if (Egns_Helpers::is_enabled($enable_breadcrumb_by_theme, $breadcrumb_enable_by_page)) { ?>

    <?php if (isset($page_breadcrumb_image['url'])) : ?>
        <div class="inner-banner-section" style="background-image: url(<?php echo esc_url($page_breadcrumb_image['url']) ?>)">
        <?php else : ?>
            <div class="inner-banner-section">
            <?php endif ?>
            <div class="container">
                <div class="row justify-content-center">
                    <div class="col-xl-8 col-md-10 col-sm-12">
                        <div class="breadcrumb-area">
                            <?php if (!is_singular('astrip-destination')) : ?>
                                <h2><?php echo esc_html__('Destination', 'astrip') ?></h2>
                            <?php else : ?>
                                <h2><?php echo the_title() ?></h2>
                            <?php endif ?>
                            <?php if (!empty(Egns_Helpers::egns_page_option_value('breadcrumb_subtitle'))) : ?>
                                <span><?php echo esc_html(Egns_Helpers::egns_page_option_value('breadcrumb_subtitle')) ?></span>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
            </div>
        <?php
    };
