<?php
$tour_id    = get_the_ID();
$tour_permalink = get_the_permalink();
// Rating Form Submit 
$post_id = '';
$tour_title = get_the_title();
$review_rating_criteria =  Egns_Helpers::egns_get_theme_option('tour_criteria');
$tour_book_form_title =  Egns_Helpers::egns_get_theme_option('tour_book_form_title');
// Handle Review & Rating
if ((isset($_POST['custom_rating_nonce']))) {
    // Get Post Data
    $customer_name          = sanitize_text_field($_POST['customer_name']);
    $customer_email         = sanitize_text_field($_POST['customer_email']);
    $review_title           = sanitize_text_field($_POST['review_title']);
    $review_message         = wp_kses_post($_POST['review_message']);
    $customer_id            = wp_kses_post($_POST['customer_id']);

    $post = array(
        'post_type'     => 'review-rating',
        'post_title'    => $review_title,
        'post_status'   => 'publish',
    );
    $post_id = wp_insert_post($post);

    $review_rating_array = [];

    if (count($review_rating_criteria) > 0) {
        foreach ($review_rating_criteria as $rating) {
            $input_name = strtolower(trim(preg_replace('/[^A-Za-z0-9-]+/', '_',  $rating['criteria_item'])) . 'rating');
            if (isset($_POST[$input_name])) {
                $reivew_rating = sanitize_text_field($_POST[$input_name]);
            } else {
                $reivew_rating = 0;
            }
            $rating_criteria_array = [];
            $rating_criteria_array['reivew_criteria'] = $rating['criteria_item'];
            $rating_criteria_array['reivew_criteria_rating'] = $reivew_rating;
            $review_rating_array[] = $rating_criteria_array;
        }
    }
    $tour_package_with_links = esc_url($tour_permalink);
    $post_meta_array = array(
        'customer_id'           => $customer_id,
        'tour_package_id'       => $tour_package_with_links,
        'tour_package_title'    => $tour_title,
        'customer_email'        => $customer_email,
        'customer_name'         => $customer_name,
        'review_title'          => $review_title,
        'review_message'        => $review_message,
        'review_rating'         => $review_rating_array,
        'review_status'         => esc_html('pending'),

    );

    add_post_meta($post_id, 'tour_astrip_review_rating', $post_meta_array);

    if (isset($post_id)) {
        wp_reset_postdata();
        wp_reset_query();
        wp_redirect(get_the_permalink());
    }
}

// Theme Options value 
$theme_options = get_option('egns_theme_options'); // prefix of theme

$tour_date =    is_array(Egns_Helpers::egns_post_meta_box_value(EGNS_TOUR_META_ID, 'tour_date')) ? Egns_Helpers::egns_post_meta_box_value(EGNS_TOUR_META_ID, 'tour_product') : '';
$tour_product = Egns_Helpers::egns_post_meta_box_value(EGNS_TOUR_META_ID, 'tour_product') ? Egns_Helpers::egns_post_meta_box_value(EGNS_TOUR_META_ID, 'tour_product') : '';
// Get Product Information

$children_price = get_post_meta($tour_product, 'astrip_children_price', true);

get_header();

if (!is_front_page()) {
    get_template_part('template-parts/breadcrumbs/breadcrumb-tour');
}


?>

<div class="destination-details-section pt-120 pb-120">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-8 destination-tab">
                <?php
                get_template_part('loop-templates/content', 'tour-single');
                ?>
            </div>
            <div class="col-lg-4 ps-lg-4">
                <?php
                $product = '';
                if (class_exists('Woocommerce')) {
                    $product = wc_get_product($tour_product);
                }
                ?>
                <div class="booking-form-box">
                    <?php if (!empty($tour_book_form_title)) : ?>
                        <h3><?php echo sprintf(__('%s', 'astrip'), $tour_book_form_title) ?></h3>
                    <?php endif; ?>
                    <?php if (empty(Egns_Helpers::egns_post_meta_box_value(EGNS_TOUR_META_ID, 'tour_booking_options')) || (!empty(Egns_Helpers::egns_post_meta_box_value(EGNS_TOUR_META_ID, 'tour_booking_options')) && Egns_Helpers::egns_post_meta_box_value(EGNS_TOUR_META_ID, 'tour_booking_options') == 'both')) : ?>
                        <hr class="separate-line">
                        <div class="nav flex-row justify-content-center gap-5 nav-pills mb-40" role="tablist">
                            <?php if (!empty($product)) : ?>
                                <button class="nav-link <?php echo esc_attr(Egns_Helpers::egns_post_meta_box_value(EGNS_TOUR_META_ID, 'tour_booking_options') != 'enquiry_form') ? 'show active' : '' ?> eg-btn btn--primary-outline btn--sm" id="v-pills-booking-tab" data-bs-toggle="pill" data-bs-target="#v-pills-booking" type="button" role="tab" aria-controls="v-pills-booking" aria-selected="true"><?php echo esc_html__(' Booking Form', 'astrip') ?></button>
                            <?php endif ?>
                            <button class="nav-link eg-btn <?php echo (Egns_Helpers::egns_post_meta_box_value(EGNS_TOUR_META_ID, 'tour_booking_options') == 'enquiry_form' || empty($product)) ? 'active' : '' ?> btn--primary-outline btn--sm" id="v-pills-contact-tab" data-bs-toggle="pill" data-bs-target="#v-pills-contact" type="button" role="tab" aria-controls="v-pills-contact" aria-selected="true"><?php echo esc_html__('Enquery Form', 'astrip') ?></button>
                        </div>
                    <?php endif ?>
                    <div class="tab-content" id="v-pills-tabContent2">
                        <?php if (class_exists('Woocommerce') && (Egns_Helpers::egns_post_meta_box_value(EGNS_TOUR_META_ID, 'tour_booking_options') != 'enquiry_form') && !empty($tour_product)) : ?>
                            <div class="tab-pane fade <?php echo esc_attr(Egns_Helpers::egns_post_meta_box_value(EGNS_TOUR_META_ID, 'tour_booking_options') != 'enquiry_form') ? 'show active' : '' ?>" id="v-pills-booking" role="tabpanel" aria-labelledby="v-pills-booking-tab">
                                <div class="sidebar-booking-form">
                                    <input id="productId" type="hidden" value="<?php echo esc_attr($tour_product) ?>">
                                    <hr class="separate-line2">

                                    <form class="cart" action="<?php echo esc_url(apply_filters('woocommerce_add_to_cart_form_action', $product->get_permalink())); ?>" name="review-rating-from" method="post" enctype='multipart/form-data'>
                                        <?php do_action('egns_tour_booking_form'); ?>

                                        <?php do_action('woocommerce_before_add_to_cart_button'); ?>
                                        <?php
                                        do_action('woocommerce_before_add_to_cart_quantity');

                                        do_action('woocommerce_after_add_to_cart_quantity');
                                        ?>
                                        <button type="submit" class="eg-btn btn--primary btn--lg w-100 mt-3" name="add-to-cart" value="<?php echo esc_attr($product->get_id()); ?>" class="single_add_to_cart_button button alt"><?php echo esc_html('Book Now'); ?></button>

                                        <?php do_action('woocommerce_after_add_to_cart_button'); ?>
                                    </form>
                                    <?php if (is_admin()) : ?>
                                        <h4><?php echo esc_html__('Please select a woocommerce product first', 'astrip') ?></h4>
                                    <?php endif ?>
                                </div>
                            </div>
                        <?php endif ?>
                        <?php if ((Egns_Helpers::egns_post_meta_box_value(EGNS_TOUR_META_ID, 'tour_booking_options') != 'booking_form') || ((Egns_Helpers::egns_post_meta_box_value(EGNS_TOUR_META_ID, 'tour_booking_options') == 'booking_form') && empty($tour_product))) : ?>
                            <div class="tab-pane fade <?php echo (Egns_Helpers::egns_post_meta_box_value(EGNS_TOUR_META_ID, 'tour_booking_options') == 'enquiry_form' || empty($product) || !class_exists('Woocommerce')) ? 'show active' : '' ?>" id="v-pills-contact" role="tabpanel" aria-labelledby="v-pills-contact-tab">
                                <?php get_template_part('template-parts/tour/enquiries') ?>
                            </div>
                        <?php endif ?>
                    </div>
                </div>

                <?php dynamic_sidebar('tour_sidebar'); ?>
            </div>
        </div>
    </div>
</div>

<?php if (isset($theme_options['astrip_insta_feed_switcher']) && $theme_options['astrip_insta_feed_switcher'] == true) :

    // Instagram Feed 
    get_template_part('template-parts/common/instagram');

endif; ?>
<?php
get_footer();
