<?php

/**
 * The main template file
 *
 * Template Name: Blog Left Sidebar
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package astrip
 * @since 1.3.0
 * 
 */
get_header();
if (!is_front_page()) :
    get_template_part('template-parts/breadcrumbs/breadcrumb-page');
endif;

// Theme Options value 
$theme_options = get_option('egns_theme_options'); // prefix of theme

$args = array(
    'post_type' => 'post', //it is a Page right?
    'post_status' => 'publish',
    'paged' => (get_query_var('paged')) ? get_query_var('paged') : 1
);
$wp_query = new WP_Query($args);

?>
<div class="blog-news sec-mar">
    <div class="container">
        <div class="blog-wrapper">
            <div class="row <?php echo !is_active_sidebar('blog_sidebar') ? 'justify-content-center' : '' ?>">
                <?php
                if (is_active_sidebar('blog_sidebar')) { ?>
                    <div class="col-md-12 col-lg-5 col-xl-4 or2">
                        <div class="widget-area pe-lg-4">
                            <?php
                            dynamic_sidebar('blog_sidebar');
                            ?>
                        </div>
                    </div>
                <?php
                }
                ?>
                <div class="col-md-12 col-lg-7 col-xl-8 or1">
                    <div class="row g-4 justify-content-center">
                        <?php
                        $num = 0;
                        if ($wp_query->have_posts()) :
                            /* Start the Loop */
                            while ($wp_query->have_posts()) :
                                $num++;
                                echo '<div class="col-md-6 col-sm-10">';
                                $wp_query->the_post();
                                $format = get_post_format() ?: 'grid';
                                /*
                                * Include the Post-Type-specific template for the content.
                                * If you want to override this in a child theme, then include a file
                                * called content-___.php (where ___ is the Post Type name) and that will be used instead.
                                */
                                get_template_part('loop-templates/content', $format);
                                echo '</div>';

                            endwhile;
                        else :
                            get_template_part('loop-templates/content', 'none');

                        endif;
                        ?>
                    </div>
                    <div class="row justify-content-center">
                        <div class="col-md-8">
                            <nav class="pagination-wrap">
                                <?php get_template_part('template-parts/blog/pagination'); ?>
                            </nav>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php

if ($theme_options['astrip_insta_feed_switcher'] == true) :
    // Instagram Feed 
    get_template_part( 'template-parts/common/instagram' );
endif;
get_footer();
