<?php

/**
 * Empty content partial template.
 *
 * @package astrip
 */
?>


<div class="blog-single2">
    <div class="image">
        <?php if (has_post_thumbnail()) : ?>
            <?php the_post_thumbnail('', ['class' => 'img-fluid']); ?>
        <?php endif ?>
        <?php
        $getCategoryName = get_the_category(get_the_ID());
        ?>
        <span class="blog-category">
            <a href="<?php echo get_category_link($getCategoryName[0]->cat_ID) ?>">
                <?php echo esc_html($getCategoryName[0]->name) ?>
            </a>
        </span>
    </div>
    <div class="content">
        <h5><a href="<?php esc_url(the_permalink()) ?>"><?php echo wp_kses(get_the_title(), wp_kses_allowed_html('post')) ?></a></h5>
        <div class="blog-date">
            <i class="bi bi-calendar-check"></i><span><a href="<?php echo esc_url(home_url(get_the_date('Y/m/d'))) ?>"><?php echo get_the_date('F j, Y'); ?></a></span>
        </div>
    </div>
</div>