<?php
/**
 * Empty content partial template.
 *
 * @package astrip
 */

the_content();

$args = array(
    'post_type' => 'post',
    'orderby'=> 'post_date', 
    'order' => 'DESC'
); 
$query = new WP_Query($args);
?>

<?php if( $query->have_posts() ) :  ?>
<?php 
while ($query->have_posts()) {
    $query->the_post();
?>
<div class="thumbnail-grid__section thumbnail-grid__section--alt">
    <a class="thumbnail-grid__thumbnail" href="<?php echo the_permalink() ?>">
        <?php echo get_the_post_thumbnail( get_the_ID(), 'rectangle-thumb' ); ?>
        <h3 class="thumbnail-grid__title"><?php echo get_the_title(); ?></h3>
    </a>
    <div class="thumbnail-grid__content">
        <?php echo get_the_excerpt() ?>
    </div>
</div>
<?php } wp_reset_postdata(); ?>
<?php endif ?>

<section class="more-about-us">
    <div class="wrapper thumbnail-grid">
        <div class="title-wrapper">
            <h2><?php esc_html_e( 'More about us', 'astrip' ); ?></h2>
        </div>

        <?php
            $args = array(
                'post_type'             => 'post',
                'orderby'               => 'post_date', 
                'order'                 => 'DESC',
                'ignore_sticky_posts'   => 1
            ); 
            $query = new WP_Query($args);
            ?>

            <?php if( $query->have_posts() ) :  ?>
            <?php 
            while ($query->have_posts()) {
                $query->the_post();
            ?>
            <div class="thumbnail-grid__section thumbnail-grid__section--alt">
                <a class="thumbnail-grid__thumbnail" href="<?php echo the_permalink() ?>">
                    <?php echo get_the_post_thumbnail( get_the_ID(), 'rectangle-thumb' ); ?>
                    <h3 class="thumbnail-grid__title"><?php echo get_the_title(); ?></h3>
                </a>
                <div class="thumbnail-grid__content">
                    <?php echo get_the_excerpt() ?>
                </div>
            </div>
            <?php } wp_reset_postdata(); ?>
            <?php endif ?>
    </div>
</section>