<?php 
/*-----------------------------------
GALLERY SECTION
------------------------------------*/
CSF::createSection( EGNS_TOUR_META_ID,
    array(
        'title'  => esc_html__( 'Gallery', 'astrip' ),
        'parent' => 'astrip_tour_meta_option',
        'fields' => array(
            array(
                'type'    => 'subheading',
                'content' => esc_html__( 'Image Gallery', 'astrip' ),
            ),
            array(
				'id'      => 'image_gallery_enable_disable_option',
				'title'   => esc_html__( 'Enable Image Gallery', 'astrip' ),
				'type'    => 'switcher',
				'desc'    => wp_kses( __( 'you can set <mark>Yes / No</mark> to enable/disable button area', 'astrip' ), wp_kses_allowed_html('post') ),
				'default' => true,
			),
            array(
                'id'      => 'image_gallery_section_title',
                'type'    => 'text',
                'title'   => esc_html__( 'Section Title', 'astrip' ),
                'default' => esc_html__( 'Astrip Tour Image Gallery', 'astrip' ),
                'dependency' => array( 'image_gallery_enable_disable_option', '==', 'true' ),
            ),
            array(
                'id'          => 'image_gallery',
                'type'        => 'gallery',
                'title'       => esc_html__( 'Image Gallery', 'astrip' ),
                'add_title'   => esc_html__( 'Add Images', 'astrip' ),
                'edit_title'  => esc_html__( 'Edit Images', 'astrip' ),
                'clear_title' => esc_html__( 'Remove Images', 'astrip' ),
                'dependency' => array( 'image_gallery_enable_disable_option', '==', 'true' ),
            ),
            array(
				'id'      => 'video_gallery_enable_disable_option',
				'title'   => esc_html__( 'Enable Video Gallery', 'astrip' ),
				'type'    => 'switcher',
				'desc'    => wp_kses( __( 'you can set <mark>Yes / No</mark> to enable/disable button area', 'astrip' ), wp_kses_allowed_html('post') ),
				'default' => false,
			),
            array(
                'id'      => 'video_gallery_title',
                'type'    => 'text',
                'title'   => esc_html__( 'Section Title', 'astrip' ),
                'default' => 'Astrip Tour Video Gallery',
                'dependency' => array( 'video_gallery_enable_disable_option', '==', 'true' ),
            ),
            array(
                'id'     => 'video_gallery',
                'type'   => 'repeater',
                'title'  => esc_html__( 'Video Gallery', 'astrip' ),
                'fields' => array(
              
                  array(
                    'id'    => 'video_gallery_url',
                    'type'  => 'text',
                    'title' => esc_html__( 'YouTube or Vimeo URL', 'astrip' ),
                  ),
              
                ),
                'dependency' => array( 'video_gallery_enable_disable_option', '==', 'true' ),
            ),
            
        ),
    )
);