<?php
/*-----------------------------------
		Header Options
	------------------------------------*/

CSF::createSection($prefix . '_theme_options', array(
	'parent' => 'header_options',
	'title'  => esc_html__('Header Options', 'astrip'),
	'id'     => 'theme_header_options',
	'icon'   => 'fa fa-id-card-o',
	'fields' => array(
		array(
			'type'    => 'subheading',
			'content' => '<h3>' . esc_html__('Header Options', 'astrip') . '</h3>'
		),
		array(
			'id'      => 'header_menu_style',
			'title'   => esc_html__('Select Style', 'astrip'),
			'type'    => 'select',
			'options'     		=> array(
				'header_one'  	=> 'Header One',
				'header_two' 	=> 'Header Two',
				'header_three'  => 'Header Three',
			),
			'desc'    => wp_kses(__('you can select <mark>Header Style </mark> for header section', 'astrip'), $allowed_html),
			'default' => 'header_one',
		),
		// Header One Style Start
		array(
			'id'    		=> 'header_one_right_side_content',
			'type'  		=> 'switcher',
			'title'   		=> esc_html__('Right Side Content', 'astrip'),
			'desc'    		=> wp_kses(__('you can enable/disable <mark>Header One Right Side Content </mark> for header section', 'astrip'), $allowed_html),
			'dependency'	=> array('header_menu_style', '==', 'header_one'),
			'default' 		=> 1
		),
		array(
			'type'    		=> 'subheading',
			'content' 		=> '<h4>' . esc_html__('Right Side Content', 'astrip') . '</h4>',
			'dependency'	=> array('header_menu_style|header_one_right_side_content', '==', 'header_one|1'),
		),
		array(
			'id'         	=> 'header_right_side_content_type_one',
			'type'       	=> 'radio',
			'title'      	=> esc_html__('Content Type', 'astrip'),
			'options'    	=> array(
				'contact'  	=> esc_html('Contact'),
				'email' 		=> esc_html('Email'),
				'others' 		=> esc_html('Others'),
			),
			'default'    	=> 'contact',
			'dependency'	=> array('header_menu_style|header_one_right_side_content', '==', 'header_one|1'),
		),
		array(
			'id'    	=> 'header_one_right_side_contact_icon',
			'type'  	=> 'media',
			'title' 	=> esc_html__('Contact Icon', 'astrip'),
			'dependency' => array('header_menu_style|header_one_right_side_content|header_right_side_content_type_one', '==|==|==', 'header_one|1|contact'),
			'default'	=> array(
				'url'         => esc_url(EGNS_THEME_SETTINGS_IMAGES . '/topbar/cell-icon.svg'),
				'id'          => 'content_icon',
				'thumbnail'   => esc_url(EGNS_THEME_SETTINGS_IMAGES . '/topbar/cell-icon.svg'),
				'alt'         => esc_attr('content-icons'),
				'title'       => esc_html('Icon'),
			),
		),
		array(
			'id'    		=> 'header_one_right_side_contact_text',
			'type'  		=> 'text',
			'title'   		=> esc_html__('Contact Text', 'astrip'),
			'default' 		=> esc_html__('Call Now', 'astrip'),
			'dependency'	=> array('header_menu_style|header_one_right_side_content|header_right_side_content_type_one', '==|==|==', 'header_one|1|contact'),
		),
		array(
			'id'    		=> 'header_one_right_side_contact_number',
			'type'  		=> 'text',
			'title'   		=> esc_html__('Contact Number', 'astrip'),
			'default' 		=> esc_html__('+880 170 1111 000', 'astrip'),
			'dependency'	=> array('header_menu_style|header_one_right_side_content|header_right_side_content_type_one', '==|==|==', 'header_one|1|contact'),
		),

		array(
			'id'    	=> 'header_one_right_side_email_icon',
			'type'  	=> 'media',
			'title' 	=> esc_html__('Email Icon', 'astrip'),
			'dependency' => array('header_menu_style|header_one_right_side_content|header_right_side_content_type_one', '==|==|==', 'header_one|1|email'),
			'default'	=> array(
				'url'         => esc_url(EGNS_THEME_SETTINGS_IMAGES . '/topbar/cell-icon.svg'),
				'id'          => 'content_icon',
				'thumbnail'   => esc_url(EGNS_THEME_SETTINGS_IMAGES . '/topbar/cell-icon.svg'),
				'alt'         => esc_attr('content-icons'),
				'title'       => esc_html('Icon'),
			),
		),
		array(
			'id'    		=> 'header_one_right_side_email_text',
			'type'  		=> 'text',
			'title'   		=> esc_html__('Email Text', 'astrip'),
			'default' 		=> esc_html__('Mail Us', 'astrip'),
			'dependency'	=> array('header_menu_style|header_one_right_side_content|header_right_side_content_type_one', '==|==|==', 'header_one|1|email'),
		),
		array(
			'id'    		=> 'header_one_right_side_email_address',
			'type'  		=> 'text',
			'title'   		=> esc_html__('Email Address', 'astrip'),
			'default' 		=> esc_html__('info@example.com', 'astrip'),
			'dependency'	=> array('header_menu_style|header_one_right_side_content|header_right_side_content_type_one', '==|==|==', 'header_one|1|email'),
		),

		array(
			'id'    	=> 'header_one_right_side_others_icon',
			'type'  	=> 'media',
			'title' 	=> esc_html__('Icon', 'astrip'),
			'dependency' => array('header_menu_style|header_one_right_side_content|header_right_side_content_type_one', '==|==|==', 'header_one|1|others'),
			'default'	=> array(
				'url'         => esc_url(EGNS_THEME_SETTINGS_IMAGES . '/topbar/cell-icon.svg'),
				'id'          => 'content_icon',
				'thumbnail'   => esc_url(EGNS_THEME_SETTINGS_IMAGES . '/topbar/cell-icon.svg'),
				'alt'         => esc_attr('content-icons'),
				'title'       => esc_html('Icon'),
			),
		),
		array(
			'id'    		=> 'header_one_right_side_others_text',
			'type'  		=> 'text',
			'title'   		=> esc_html__('Text', 'astrip'),
			'default' 		=> esc_html__('Add Text', 'astrip'),
			'dependency'	=> array('header_menu_style|header_one_right_side_content|header_right_side_content_type_one', '==|==|==', 'header_one|1|others'),
		),
		array(
			'id'    		=> 'header_one_right_side_heading_address',
			'type'  		=> 'text',
			'title'   		=> esc_html__('Heading', 'astrip'),
			'default' 		=> esc_html__('Please add a heading', 'astrip'),
			'dependency'	=> array('header_menu_style|header_one_right_side_content|header_right_side_content_type_one', '==|==|==', 'header_one|1|others'),
		),
		array(
			'id'    		=> 'header_one_right_side_heading_address_link',
			'type'  		=> 'text',
			'title'   		=> esc_html__('Heading Link', 'astrip'),
			'default' 		=> esc_html__('Please add a heading', 'astrip'),
			'dependency'	=> array('header_menu_style|header_one_right_side_content|header_right_side_content_type_one', '==|==|==', 'header_one|1|others'),
		),
		array(
			'type'    		=> 'subheading',
			'content' 		=> '<h4>' . esc_html__('Button(Mobile Device)', 'astrip') . '</h4>',
			'dependency'	=> array('header_menu_style', '==', 'header_one'),
		),
		array(
			'id'    		=> 'header_one_button_text_mobile',
			'type'  		=> 'text',
			'title'   		=> esc_html__('Button Text', 'astrip'),
			'default' 		=> esc_html__('Please add Button Text', 'astrip'),
			'dependency'	=> array('header_menu_style', '==', 'header_one'),
		),
		array(
			'id'    		=> 'header_one_button_link_mobile',
			'type'  		=> 'text',
			'title'   		=> esc_html__('Button Link', 'astrip'),
			'default' 		=> esc_html__('https://www.example.com', 'astrip'),
			'dependency'	=> array('header_menu_style', '==', 'header_one'),
		),
		array(
			'type'    		=> 'subheading',
			'content' 		=> '<h4>' . esc_html__('Color Options', 'astrip') . '</h4>',
			'dependency'	=> array('header_menu_style', '==', 'header_one'),
		),
		array(
			'id'            => 'header_one_formate_color',
			'type'          => 'tabbed',
			'title'         => esc_html(' Colors '),
			'dependency'	=> array('header_menu_style', '==', 'header_one'),
			'tabs'          => array(
				array(
					'title'     => esc_html('Normal Header'),
					'fields'    => array(
						array(
							'id'    	=> 'header_one_background_color',
							'type'  	=> 'color',
							'title'   	=> esc_html__('Background Color', 'astrip'),
							'desc'    	=> wp_kses(__('you can select <mark>Header Background Color </mark> for header section', 'astrip'), $allowed_html),
						),
						array(
							'id'    	=> 'header_one_menu_text_color',
							'type'  	=> 'color',
							'title'   	=> esc_html__('Menu Text Color', 'astrip'),
							'desc'    	=> wp_kses(__('you can select <mark>Header Menu Color </mark> for header section', 'astrip'), $allowed_html),
						),
						array(
							'id'    	=> 'header_one_menu_hover_text_color',
							'type'  	=> 'color',
							'title'   	=> esc_html__('Menu Hover Text Color', 'astrip'),
							'desc'    	=> wp_kses(__('you can select <mark>Header Menu Color </mark> for header section', 'astrip'), $allowed_html),
						),
						array(
							'id'    	=> 'header_one_sub_menu_background_color',
							'type'  	=> 'color',
							'title'   	=> esc_html__('Sub Menu Background Color', 'astrip'),
							'desc'    	=> wp_kses(__('you can select <mark>Header Menu Color </mark> for header section', 'astrip'), $allowed_html),
						),
						array(
							'id'    	=> 'header_one_sub_menu_text_color',
							'type'  	=> 'color',
							'title'   	=> esc_html__('Sub Menu Text Color', 'astrip'),
							'desc'    	=> wp_kses(__('you can select <mark>Header Menu Color </mark> for header section', 'astrip'), $allowed_html),
						),
						array(
							'id'    	=> 'header_one_sub_menu_hover_text_color',
							'type'  	=> 'color',
							'title'   	=> esc_html__('Sub Menu Hover Text Color', 'astrip'),
							'desc'    	=> wp_kses(__('you can select <mark>Header Menu Color </mark> for header section', 'astrip'), $allowed_html),
						),
						array(
							'id'    => 'header_one_right_side_content_color',
							'type'  => 'color',
							'title' => esc_html('Contact Content Color'),
						),
					)
				),
				array(
					'title'     => esc_html('Sticky Header'),
					'fields'    => array(
						array(
							'id'    	=> 'sticky_header_one_background_color',
							'type'  	=> 'color',
							'title'   	=> esc_html__('Sticky Background Color', 'astrip'),
							'desc'    	=> wp_kses(__('you can select <mark>Header Background Color </mark> for header section', 'astrip'), $allowed_html),
						),
						array(
							'id'    	=> 'sticky_header_one_menu_text_color',
							'type'  	=> 'color',
							'title'   	=> esc_html__('Sticky Menu Text Color', 'astrip'),
							'desc'    	=> wp_kses(__('you can select <mark>Header Menu Color </mark> for header section', 'astrip'), $allowed_html),
						),
						array(
							'id'    	=> 'sticky_header_one_menu_hover_text_color',
							'type'  	=> 'color',
							'title'   	=> esc_html__('Sticky Menu Hover Text Color', 'astrip'),
							'desc'    	=> wp_kses(__('you can select <mark>Header Menu Color </mark> for header section', 'astrip'), $allowed_html),
						),
						array(
							'id'    	=> 'sticky_header_one_sub_menu_background_color',
							'type'  	=> 'color',
							'title'   	=> esc_html__('Sticky Sub Menu Background Color', 'astrip'),
							'desc'    	=> wp_kses(__('you can select <mark>Header Menu Color </mark> for header section', 'astrip'), $allowed_html),
						),
						array(
							'id'    	=> 'sticky_header_one_sub_menu_text_color',
							'type'  	=> 'color',
							'title'   	=> esc_html__('Sticky Sub Menu Text Color', 'astrip'),
							'desc'    	=> wp_kses(__('you can select <mark>Header Menu Color </mark> for header section', 'astrip'), $allowed_html),
						),
						array(
							'id'    	=> 'sticky_header_one_sub_menu_hover_text_color',
							'type'  	=> 'color',
							'title'   	=> esc_html__('Sticky Sub Menu Hover Text Color', 'astrip'),
							'desc'    	=> wp_kses(__('you can select <mark>Header Menu Color </mark> for header section', 'astrip'), $allowed_html),
						),
						array(
							'id'    => 'sticky_header_one_right_side_content_color',
							'type'  => 'color',
							'title' => esc_html('Contact Content Color'),
						),
					)
				),
			)
		),
		// Header One Style End 

		// Header Two Style Start
		array(
			'id'    		=> 'header_two_right_side_content',
			'type'  		=> 'switcher',
			'title'   		=> esc_html__('Right Side Content', 'astrip'),
			'desc'    		=> wp_kses(__('you can enable/disable <mark>Header Two Right Side Content </mark> for header section', 'astrip'), $allowed_html),
			'dependency'	=> array('header_menu_style', '==', 'header_two'),
			'default' 		=> 1
		),
		array(
			'id'    		=> 'header_two_right_side_button',
			'type'  		=> 'switcher',
			'title'   		=> esc_html__('Right Side Button', 'astrip'),
			'desc'    		=> wp_kses(__('you can enable/disable <mark>Header Two Right Side Button </mark> for header section', 'astrip'), $allowed_html),
			'dependency'	=> array('header_menu_style', '==', 'header_two'),
			'default' 		=> 1
		),
		array(
			'type'    		=> 'subheading',
			'content' 		=> '<h4>' . esc_html__('Right Side Content', 'astrip') . '</h4>',
			'dependency'	=> array('header_menu_style|header_two_right_side_content', '==', 'header_two|1'),
		),
		array(
			'id'         	=> 'header_right_side_content_type_two',
			'type'       	=> 'radio',
			'title'      	=> esc_html__('Content Type', 'astrip'),
			'options'    	=> array(
				'contact'  	=> esc_html('Contact'),
				'email' 		=> esc_html('Email'),
				'others' 		=> esc_html('Others'),
			),
			'default'    	=> 'contact',
			'dependency'	=> array('header_menu_style|header_two_right_side_content', '==', 'header_two|1'),
		),
		array(
			'id'    	=> 'header_two_right_side_contact_icon',
			'type'  	=> 'media',
			'title' 	=> esc_html__('Contact Icon', 'astrip'),
			'dependency' => array('header_menu_style|header_two_right_side_content|header_right_side_content_type_two', '==|==|==', 'header_two|1|contact'),
			'default'	=> array(
				'url'         => esc_url(EGNS_THEME_SETTINGS_IMAGES . '/topbar/cell-icon.svg'),
				'id'          => 'content_icon',
				'thumbnail'   => esc_url(EGNS_THEME_SETTINGS_IMAGES . '/topbar/cell-icon.svg'),
				'alt'         => esc_attr('content-icons'),
				'title'       => esc_html('Icon'),
			),
		),
		array(
			'id'    		=> 'header_two_right_side_contact_text',
			'type'  		=> 'text',
			'title'   		=> esc_html__('Contact Text', 'astrip'),
			'default' 		=> esc_html__('Call Now', 'astrip'),
			'dependency'	=> array('header_menu_style|header_two_right_side_content|header_right_side_content_type_two', '==|==|==', 'header_two|1|contact'),
		),
		array(
			'id'    		=> 'header_two_right_side_contact_number',
			'type'  		=> 'text',
			'title'   		=> esc_html__('Contact Number', 'astrip'),
			'default' 		=> esc_html__('+880 170 1111 000', 'astrip'),
			'dependency'	=> array('header_menu_style|header_two_right_side_content|header_right_side_content_type_two', '==|==|==', 'header_two|1|contact'),
		),

		array(
			'id'    	=> 'header_two_right_side_email_icon',
			'type'  	=> 'media',
			'title' 	=> esc_html__('Email Icon', 'astrip'),
			'dependency' => array('header_menu_style|header_two_right_side_content|header_right_side_content_type_two', '==|==|==', 'header_two|1|email'),
			'default'	=> array(
				'url'         => esc_url(EGNS_THEME_SETTINGS_IMAGES . '/topbar/cell-icon.svg'),
				'id'          => 'content_icon',
				'thumbnail'   => esc_url(EGNS_THEME_SETTINGS_IMAGES . '/topbar/cell-icon.svg'),
				'alt'         => esc_attr('content-icons'),
				'title'       => esc_html('Icon'),
			),
		),
		array(
			'id'    		=> 'header_two_right_side_email_text',
			'type'  		=> 'text',
			'title'   		=> esc_html__('Email Text', 'astrip'),
			'default' 		=> esc_html__('Mail Us', 'astrip'),
			'dependency'	=> array('header_menu_style|header_two_right_side_content|header_right_side_content_type_two', '==|==|==', 'header_two|1|email'),
		),
		array(
			'id'    		=> 'header_two_right_side_email_address',
			'type'  		=> 'text',
			'title'   		=> esc_html__('Email Address', 'astrip'),
			'default' 		=> esc_html__('info@example.com', 'astrip'),
			'dependency'	=> array('header_menu_style|header_two_right_side_content|header_right_side_content_type_two', '==|==|==', 'header_two|1|email'),
		),

		array(
			'id'    	=> 'header_two_right_side_others_icon',
			'type'  	=> 'media',
			'title' 	=> esc_html__('Icon', 'astrip'),
			'dependency' => array('header_menu_style|header_two_right_side_content|header_right_side_content_type_two', '==|==|==', 'header_two|1|others'),
			'default'	=> array(
				'url'         => esc_url(EGNS_THEME_SETTINGS_IMAGES . '/topbar/cell-icon.svg'),
				'id'          => 'content_icon',
				'thumbnail'   => esc_url(EGNS_THEME_SETTINGS_IMAGES . '/topbar/cell-icon.svg'),
				'alt'         => esc_attr('content-icons'),
				'title'       => esc_html('Icon'),
			),
		),
		array(
			'id'    		=> 'header_two_right_side_others_text',
			'type'  		=> 'text',
			'title'   		=> esc_html__('Text', 'astrip'),
			'default' 		=> esc_html__('Add Text', 'astrip'),
			'dependency'	=> array('header_menu_style|header_two_right_side_content|header_right_side_content_type_two', '==|==|==', 'header_two|1|others'),
		),
		array(
			'id'    		=> 'header_two_right_side_heading_address',
			'type'  		=> 'text',
			'title'   		=> esc_html__('Heading', 'astrip'),
			'default' 		=> esc_html__('Please add a heading', 'astrip'),
			'dependency'	=> array('header_menu_style|header_two_right_side_content|header_right_side_content_type_two', '==|==|==', 'header_two|1|others'),
		),
		array(
			'id'    		=> 'header_two_right_side_heading_address_link',
			'type'  		=> 'text',
			'title'   		=> esc_html__('Heading Link', 'astrip'),
			'default' 		=> esc_html__('Please add a heading link', 'astrip'),
			'dependency'	=> array('header_menu_style|header_two_right_side_content|header_right_side_content_type_two', '==|==|==', 'header_two|1|others'),
		),
		array(
			'type'    		=> 'subheading',
			'content' 		=> '<h4>' . esc_html__('Right Side Button', 'astrip') . '</h4>',
			'dependency'	=> array('header_menu_style|header_two_right_side_button', '==|==', 'header_two|1'),
		),
		array(
			'id'    		=> 'header_two_right_side_button_text',
			'type'  		=> 'text',
			'title'   		=> esc_html__('Button Text', 'astrip'),
			'desc'    		=> wp_kses(__('you can set <mark>Header Two Button Text </mark> for header section', 'astrip'), $allowed_html),
			'default' 		=> esc_html__("Book A Trip", 'astrip'),
			'dependency'	=> array('header_menu_style|header_two_right_side_button', '==|==', 'header_two|1'),
		),
		array(
			'id'    		=> 'header_two_right_side_button_url',
			'type'  		=> 'text',
			'title'   		=> esc_html__('Button URL', 'astrip'),
			'desc'    		=> wp_kses(__('you can set <mark>Header Two Button URL </mark> for header section', 'astrip'), $allowed_html),
			'default' 		=> '#',
			'dependency'	=> array('header_menu_style|header_two_right_side_button', '==|==', 'header_two|1'),
		),
		array(
			'type'    		=> 'subheading',
			'content' 		=> '<h4>' . esc_html__('Color Options', 'astrip') . '</h4>',
			'dependency'	=> array('header_menu_style', '==', 'header_two'),
		),
		array(
			'id'            => 'header_two_formate_color',
			'type'          => 'tabbed',
			'title'         => esc_html(' Colors '),
			'dependency'	=> array('header_menu_style', '==', 'header_two'),
			'tabs'          => array(
				array(
					'title'     => esc_html('Normal Header'),
					'fields'    => array(
						array(
							'id'    	=> 'header_two_background_color',
							'type'  	=> 'color',
							'title'   	=> esc_html__('Background Color', 'astrip'),
							'desc'    	=> wp_kses(__('you can select <mark>Header Background Color </mark> for header section', 'astrip'), $allowed_html),
						),
						array(
							'id'    	=> 'header_two_menu_text_color',
							'type'  	=> 'color',
							'title'   	=> esc_html__('Menu Text Color', 'astrip'),
							'desc'    	=> wp_kses(__('you can select <mark>Header Menu Color </mark> for header section', 'astrip'), $allowed_html),
						),
						array(
							'id'    	=> 'header_two_menu_hover_text_color',
							'type'  	=> 'color',
							'title'   	=> esc_html__('Menu Hover Text Color', 'astrip'),
							'desc'    	=> wp_kses(__('you can select <mark>Header Menu Color </mark> for header section', 'astrip'), $allowed_html),
						),
						array(
							'id'    	=> 'header_two_sub_menu_background_color',
							'type'  	=> 'color',
							'title'   	=> esc_html__('Sub Menu Background Color', 'astrip'),
							'desc'    	=> wp_kses(__('you can select <mark>Header Menu Color </mark> for header section', 'astrip'), $allowed_html),
						),
						array(
							'id'    	=> 'header_two_sub_menu_text_color',
							'type'  	=> 'color',
							'title'   	=> esc_html__('Sub Menu Text Color', 'astrip'),
							'desc'    	=> wp_kses(__('you can select <mark>Header Menu Color </mark> for header section', 'astrip'), $allowed_html),
						),
						array(
							'id'    	=> 'header_two_sub_menu_hover_text_color',
							'type'  	=> 'color',
							'title'   	=> esc_html__('Sub Menu Hover Text Color', 'astrip'),
							'desc'    	=> wp_kses(__('you can select <mark>Header Menu Color </mark> for header section', 'astrip'), $allowed_html),
						),
						array(
							'id'    => 'header_two_right_side_content_color',
							'type'  => 'color',
							'title' => esc_html('Contact Content Color'),
						),
						array(
							'id'    => 'header_two_right_side_btn_color',
							'type'  => 'color',
							'title' => esc_html('Button Color'),
						),
						array(
							'id'    => 'header_two_right_side_btnbac_color',
							'type'  => 'color',
							'title' => esc_html('Button Background Color'),
						),
						array(
							'id'    => 'header_two_right_side_btnbor_color',
							'type'  => 'color',
							'title' => esc_html('Button Border Color'),
						),
						array(
							'id'    => 'header_two_right_side_btn_color_hover',
							'type'  => 'color',
							'title' => esc_html('Button Hover Color'),
						),
						array(
							'id'    => 'header_two_right_side_btnbac_color_hover',
							'type'  => 'color',
							'title' => esc_html('Button Hover Background Color'),
						),
						array(
							'id'    => 'header_two_right_side_btnbor_color_hover',
							'type'  => 'color',
							'title' => esc_html('Button Hover Border Color'),
						),
					)
				),
				array(
					'title'     => esc_html('Sticky Header'),
					'fields'    => array(
						array(
							'id'    	=> 'sticky_header_two_background_color',
							'type'  	=> 'color',
							'title'   	=> esc_html__('Sticky Background Color', 'astrip'),
							'desc'    	=> wp_kses(__('you can select <mark>Header Background Color </mark> for header section', 'astrip'), $allowed_html),
						),
						array(
							'id'    	=> 'sticky_header_two_menu_text_color',
							'type'  	=> 'color',
							'title'   	=> esc_html__('Sticky Menu Text Color', 'astrip'),
							'desc'    	=> wp_kses(__('you can select <mark>Header Menu Color </mark> for header section', 'astrip'), $allowed_html),
						),
						array(
							'id'    	=> 'sticky_header_two_menu_hover_text_color',
							'type'  	=> 'color',
							'title'   	=> esc_html__('Sticky Menu Hover Text Color', 'astrip'),
							'desc'    	=> wp_kses(__('you can select <mark>Header Menu Color </mark> for header section', 'astrip'), $allowed_html),
						),
						array(
							'id'    	=> 'sticky_header_two_sub_menu_background_color',
							'type'  	=> 'color',
							'title'   	=> esc_html__('Sticky Sub Menu Background Color', 'astrip'),
							'desc'    	=> wp_kses(__('you can select <mark>Header Menu Color </mark> for header section', 'astrip'), $allowed_html),
						),
						array(
							'id'    	=> 'sticky_header_two_sub_menu_text_color',
							'type'  	=> 'color',
							'title'   	=> esc_html__('Sticky Sub Menu Text Color', 'astrip'),
							'desc'    	=> wp_kses(__('you can select <mark>Header Menu Color </mark> for header section', 'astrip'), $allowed_html),
						),
						array(
							'id'    	=> 'sticky_header_two_sub_menu_hover_text_color',
							'type'  	=> 'color',
							'title'   	=> esc_html__('Sticky Sub Menu Hover Text Color', 'astrip'),
							'desc'    	=> wp_kses(__('you can select <mark>Header Menu Color </mark> for header section', 'astrip'), $allowed_html),
						),
						array(
							'id'    => 'sticky_header_two_right_side_content_color',
							'type'  => 'color',
							'title' => esc_html('Contact Content Color'),
						),
						array(
							'id'    => 'sticky_header_two_right_side_btn_color',
							'type'  => 'color',
							'title' => esc_html('Button Color'),
						),
						array(
							'id'    => 'sticky_header_two_right_side_btnbac_color',
							'type'  => 'color',
							'title' => esc_html('Button Background Color'),
						),
						array(
							'id'    => 'sticky_header_two_right_side_btnbor_color',
							'type'  => 'color',
							'title' => esc_html('Button Border Color'),
						),
						array(
							'id'    => 'sticky_header_two_right_side_btn_color_hover',
							'type'  => 'color',
							'title' => esc_html('Button Hover Color'),
						),
						array(
							'id'    => 'sticky_header_two_right_side_btnbac_color_hover',
							'type'  => 'color',
							'title' => esc_html('Button Hover Background Color'),
						),
						array(
							'id'    => 'sticky_header_two_right_side_btnbor_color_hover',
							'type'  => 'color',
							'title' => esc_html('Button Hover Border Color'),
						),
					)

				),

			)
		),
		// Header Two Style End 

		// Header Three Style Start
		array(
			'id'    		=> 'header_three_login_button',
			'type'  		=> 'switcher',
			'title'   		=> esc_html__('Login Button', 'astrip'),
			'desc'    		=> wp_kses(__('you can enable/disable <mark>Header Three Login Button </mark> for header section', 'astrip'), $allowed_html),
			'dependency'	=> array('header_menu_style', '==', 'header_three'),
			'default' 		=> 1
		),
		array(
			'type'    		=> 'subheading',
			'content' 		=> '<h4>' . esc_html__('Login Button', 'astrip') . '</h4>',
			'dependency'	=> array('header_menu_style|header_three_login_button', '==|==', 'header_three|1'),
		),
		array(
			'id'      => 'header_three_login_button_icon',
			'type'    => 'icon',
			'title'   => esc_html__('Login ICON', 'astrip'),
			'default' => 'fa fa-user-circle-o',
			'dependency'	=> array('header_menu_style|header_three_login_button', '==|==', 'header_three|1'),
		),
		array(
			'id'    		=> 'header_three_login_button_url',
			'type'  		=> 'text',
			'title'   		=> esc_html__('Button URL', 'astrip'),
			'desc'    		=> wp_kses(__('you can set <mark>Header Three Login Button URL </mark> for header section', 'astrip'), $allowed_html),
			'default' 		=> '#',
			'dependency'	=> array('header_menu_style|header_three_login_button', '==|==', 'header_three|1'),
		),

		array(
			'type'    		=> 'subheading',
			'content' 		=> '<h4>' . esc_html__('Right side Content', 'astrip') . '</h4>',
			'dependency'	=> array('header_menu_style', '==', 'header_three'),
		),
		array(
			'id'      => 'header_three_phone_number',
			'type'    => 'text',
			'title'   => esc_html__('TelePhone Number', 'astrip'),
			'default'   => esc_html('+8801701111000'),
			'dependency'	=> array('header_menu_style', '==', 'header_three'),
		),
		array(
			'id'      => 'header_three_email',
			'type'    => 'text',
			'title'   => esc_html__('Email Address', 'astrip'),
			'default'   => esc_html__('info@example.com', 'astrip'),
			'dependency'	=> array('header_menu_style', '==', 'header_three'),
		),



		array(
			'type'    		=> 'subheading',
			'content' 		=> '<h4>' . esc_html__('Social Icons', 'astrip') . '</h4>',
			'dependency'	=> array('header_menu_style', '==', 'header_three'),
		),
		array(
			'id'     => 'header_three_social',
			'type'   => 'repeater',
			'title'  => esc_html__('Social Media', 'astrip'),
			'dependency'	=> array('header_menu_style', '==', 'header_three'),
			'fields' => array(
				array(
					'id'    => 'header_three_social_icon',
					'type'  => 'icon',
					'title' => esc_html__('Socail Icon', 'astrip'),
					'default' => 'fab fa-facebook-f'
				),
				array(
					'id'    => 'header_three_social_icon_link',
					'type'  => 'text',
					'title' => esc_html__('Icon URL', 'astrip'),
					'default' => esc_url('https//www.facebook.com'),
				),
			),
		),


		array(
			'type'    		=> 'subheading',
			'content' 		=> '<h4>' . esc_html__('Color Options', 'astrip') . '</h4>',
			'dependency'	=> array('header_menu_style', '==', 'header_three'),
		),
		array(
			'id'            => 'header_three_formate_color',
			'type'          => 'tabbed',
			'title'         => esc_html(' Header Three Colors '),
			'dependency'	=> array('header_menu_style', '==', 'header_three'),
			'tabs'          => array(
				array(
					'title'     => esc_html('Left Sidebar'),
					'fields'    => array(
						array(
							'id'    	=> 'header_three_background_color',
							'type'  	=> 'color',
							'title'   	=> esc_html__('Background Color', 'astrip'),
							'desc'    	=> wp_kses(__('you can select <mark>Header Background Color </mark> for header section', 'astrip'), $allowed_html),
						),
						array(
							'id'    	=> 'header_three_menu_text_color',
							'type'  	=> 'color',
							'title'   	=> esc_html__('Menu Text Color', 'astrip'),
							'desc'    	=> wp_kses(__('you can select <mark>Header Menu Color </mark> for header section', 'astrip'), $allowed_html),
						),
						array(
							'id'    	=> 'header_three_menu_hover_text_color',
							'type'  	=> 'color',
							'title'   	=> esc_html__('Menu Hover Text Color', 'astrip'),
							'desc'    	=> wp_kses(__('you can select <mark>Header Menu Color </mark> for header section', 'astrip'), $allowed_html),
						),
						array(
							'id'    => 'header_three_icon_color',
							'type'  => 'color',
							'title' => esc_html('ICON Color'),
						),
						array(
							'id'    => 'header_three_user_BG_color',
							'type'  => 'color',
							'title' => esc_html('ICON BG Color'),
						),
					)
				),
			),
		),
		// Header Three Style End

	),

));
