<?php 

	/*-------------------------------------------------------
		  ** General Options
	--------------------------------------------------------*/

	CSF::createSection( $prefix . '_theme_options', array(
		'title'  => esc_html__( 'General', 'astrip' ),
		'id'     => 'general_options',
		'icon'   => 'fa fa-wrench',
		'fields' => array(
			array(
				'type'    => 'subheading',
				'content' => '<h3>' . esc_html__( 'Preloader Options', 'astrip' ) . '</h3>'
			),
			array(
				'id'      => 'preloader_enable',
				'title'   => esc_html__( 'Preloader', 'astrip' ),
				'type'    => 'switcher',
				'desc'    => wp_kses( __( 'you can set <mark>Yes / No</mark> to enable/disable preloader', 'astrip' ), $allowed_html ),
				'default' => true,
			),
			array(
				'id'      => 'preloader_image',
				'title'   => esc_html__('Preloader Image', 'astrip'),
				'type'    => 'media',
				'desc'    => wp_kses(__('Set preloader image', 'astrip'), $allowed_html),
				'dependency'  => array( 'preloader_enable', '==', 'true' ),
			),			  
			array(
				'id'      => 'scroll_top_enable',
				'title'   => esc_html__( 'Scroll Top', 'astrip' ),
				'type'    => 'switcher',
				'desc'    => wp_kses( __( 'you can set <mark>Yes / No</mark> to enable/disable scroll to top', 'astrip' ), $allowed_html ),
				'default' => true,
			),
		)
	) );


 ?>