<?php

// Control core classes for avoid errors
if (class_exists('CSF')) {

    //Set a unique slug-like ID
    $prefix = 'tour_astrip_enquiries';

    //Create a metabox
    CSF::createMetabox($prefix, array(
        'title'     => esc_html__('Enquiries Meta', 'astrip'),
        'post_type' => 'enquiries',
    ));

    //Create a section
    CSF::createSection($prefix, array(
        'title'  => esc_html__('Enquiries Data', 'astrip'),
        'fields' => array(
            array(
                'id'            => 'enquiries_package_id',
                'type'          => 'text',
                'title'         =>  esc_html__('Tour Package ID', 'astrip'),
                'attributes'    => array('readonly' => true)
            ),
            array(
                'id'            => 'enquiries_fullname',
                'type'          => 'text',
                'title'         =>  esc_html__('Full Name', 'astrip'),
                'attributes'    => array('readonly' => true)
            ),
            array(
                'id'            => 'enquiries_email_address',
                'type'          => 'text',
                'title'         =>  esc_html__('Email Address', 'astrip'),
                'attributes'    => array('readonly' => true)
            ),
            array(
                'id'            => 'enquiries_phone',
                'type'          => 'text',
                'title'         =>  esc_html__('Phone', 'astrip'),
                'attributes'    => array('readonly' => true)
            ),
            array(
                'id'            => 'enquiries_people',
                'type'          => 'text',
                'title'         =>  esc_html__('People', 'astrip'),
                'attributes'    => array('readonly' => true)
            ),
            array(
                'id'            => 'enquiries_number_of_tickets',
                'type'          => 'text',
                'title'         =>  esc_html__('Number of Tickets', 'astrip'),
                'attributes'    => array('readonly' => true)
            ),
            array(
                'id'            => 'enquiries_message',
                'type'          => 'textarea',
                'title'         =>  esc_html__('Enquiry', 'astrip'),
                'attributes'    => array('readonly' => true)
            ),
        )
    ));
}
