<?php
/*-------------------------
**** WooCommerce Hooks ****
--------------------------*/

/**
 * remove default woocommerce sidebar
 */
remove_action('woocommerce_sidebar', 'woocommerce_get_sidebar', 10);

/**
 * woocommerce product single review position change
 */
remove_action('woocommerce_single_product_summary', 'woocommerce_template_single_rating', 10);
add_action('woocommerce_single_product_summary', 'woocommerce_template_single_rating', 60);


/**
 * WooCommerce product archive page title link add
 */
function astripChangeProductsTitle()
{
?>
    <h2 class="woocommerce-loop-product__title"><a href="<?php echo esc_url(get_the_permalink()) ?>"><?php echo get_the_title(); ?></a></h2>
<?php
}
remove_action('woocommerce_shop_loop_item_title', 'woocommerce_template_loop_product_title', 10);
add_action('woocommerce_shop_loop_item_title', 'astripChangeProductsTitle', 10);

/**
 * Shop page product column
 */
if (class_exists('CSF')) {

    function wc_loop_shop_columns($number_columns)
    {
        return Egns_Helpers::egns_get_theme_option('shop_column');
    }
    add_filter('loop_shop_columns', 'wc_loop_shop_columns', 1, 10);
} else {
    function wc_loop_shop_columns($number_columns)
    {
        return 4;
    }
    add_filter('loop_shop_columns', 'wc_loop_shop_columns', 1, 10);
}


/**
 * WooCommerce breadcrumb defaults
 */
function astrip_woocommerce_breadcrumbs()
{
    return array(
        'delimiter'   => ' &#10170; ',
        'wrap_before' => '<nav class="woocommerce-breadcrumb" itemprop="breadcrumb">',
        'wrap_after'  => '</nav>',
        'before'      => '',
        'after'       => '',
        'home'        => _x('Home', 'breadcrumb', 'astrip'),
    );
}
add_filter('woocommerce_breadcrumb_defaults', 'astrip_woocommerce_breadcrumbs');

/**
 * WooCommerce rating position change
 */
remove_action('woocommerce_after_shop_loop_item_title', 'woocommerce_template_loop_rating', 5);
add_action('woocommerce_after_shop_loop_item_title', 'woocommerce_template_loop_rating', 11);


// 1. Show plus minus buttons
function astrip_display_quantity_plus()
{
    echo '<button type="button" class="plus"><i class="bi bi-plus-lg"></i></button>';
}
add_action('woocommerce_after_quantity_input_field', 'astrip_display_quantity_plus');

function astrip_display_quantity_minus()
{
    echo '<button type="button" class="minus"><i class="bi bi-dash-lg"></i></button>';
}
add_action('woocommerce_before_quantity_input_field', 'astrip_display_quantity_minus');

if (class_exists('WooCommerce', false)) {
    // 2. Trigger update quantity script
    function astrip_add_cart_quantity_plus_minus()
    {

        if (!is_product() && !is_cart()) return;
        wc_enqueue_js("
            $(document).on( 'click', 'button.plus, button.minus', function() {
                var qty = $( this ).parent( '.quantity' ).find( '.qty' );
                var val = parseFloat(qty.val());
                var max = parseFloat(qty.attr( 'max' ));
                var min = parseFloat(qty.attr( 'min' ));
                var step = parseFloat(qty.attr( 'step' ));

                if ( $( this ).is( '.plus' ) ) {
                if ( max && ( max <= val ) ) {
                qty.val( max ).change();
                } else {
                qty.val( val + step ).change();
                }
                } else {
                if ( min && ( min >= val ) ) {
                qty.val( min ).change();
                } else if ( val > 1 ) {
                qty.val( val - step ).change();
                }
                }
                });

        ");
    }

    add_action('wp_footer', 'astrip_add_cart_quantity_plus_minus');
}

// Review & Rating Table Column
function egns_add_custom_column_on_rating_table($columns)
{
    $columns['customer_name']           = esc_html('Author');
    $columns['review_rating']           = esc_html('Rating');
    $columns['review_message']          = esc_html('Review');
    $columns['tour_package_title']      = esc_html('Tour');
    $columns['tour_package_actions']    = esc_html('Actions');
    return $columns;
}
add_filter('manage_edit-review-rating_columns', 'egns_add_custom_column_on_rating_table');

function astrip_review_rating_custom_column($column, $post_id)
{
    $post_meta_by_post_id = get_post_meta($post_id, 'tour_astrip_review_rating', true);

    if (isset($post_meta_by_post_id['review_rating']) &&  $column === 'review_rating') {
        $review_rating_list = '';
        $rating_criteria_count = count($post_meta_by_post_id['review_rating']);
        $rating_criteria_rating = 0;
        foreach ($post_meta_by_post_id['review_rating'] as $rating) {
            $rating_icons = '';
            $rating_criteria_rating += $rating['reivew_criteria_rating'];
            for ($x = 0; $x <= 5; $x++) {
                if ($rating['reivew_criteria_rating'] >= $x) {
                    $rating_icons .= wp_kses_post('<span class="dashicons dashicons-star-filled"></span>');
                } else {
                    $rating_icons .= wp_kses_post('<span class="dashicons dashicons-star-empty"></span>');
                }
            }
            $review_rating_list .= '<li><span>' . $rating['reivew_criteria'] . ' : </span><div class="rating">' . $rating_icons . '</div></li>';
        }
        $rating_avg = round(($rating_criteria_rating / $rating_criteria_count));
        $review_rating_list .= esc_html('Average : ' . $rating_avg . '');
        echo wp_kses_post($review_rating_list);
    }

    if (isset($post_meta_by_post_id['review_message']) &&  $column === 'review_message') {
        echo wp_kses_post($post_meta_by_post_id['review_message']);
    }
    if (isset($post_meta_by_post_id['tour_package_title']) &&  $column === 'tour_package_title') {
        echo esc_html($post_meta_by_post_id['tour_package_title']);
    }
    if ($column === 'tour_package_actions') {
        $action_options_approve = '<button value="approve" class="tour_package_action" post-id=' . $post_id . '>Approve</>';
        $action_options_unapprove = '<button value="reject" class="tour_package_action" post-id=' . $post_id . '>Unapprove</>';
        if (isset($post_meta_by_post_id['review_status']) && $post_meta_by_post_id['review_status'] == 'approve') {
            echo wp_kses_post($action_options_unapprove);
        } else {
            echo wp_kses_post($action_options_approve);
        }
    }
}
add_action('manage_review-rating_posts_custom_column', 'astrip_review_rating_custom_column', 10, 2);

// Review Attribute for WP Kses Post 
function astrip_allowed_html_wp_kses($allowedposttags)
{
    $allowedposttags['button']['post-id'] = true;
    return $allowedposttags;
}
add_filter('wp_kses_allowed_html', 'astrip_allowed_html_wp_kses');




// Profile Image option 

// Add image field
function action_woocommerce_edit_account_form_start()
{
    $user = wp_get_current_user();
?>
    <p class="add-image woocommerce-form-row woocommerce-form-row--wide form-row form-row-wide">
        <label for="image"><?php esc_html_e('Profile Photo', 'astrip'); ?>
            <input type="file" accept="image/png, image/jpg, image/jpeg" class="woocommerce-Input woocommerce-Input--text input-text" name="image" id="image" value="<?php echo esc_attr($user->image); ?>" />
            <span id="imageName" class="file-custom"><?php echo esc_html__('Choose file...', 'astrip') ?></span>
        </label>
    </p>

<?php
}
add_action('woocommerce_edit_account_form_start', 'action_woocommerce_edit_account_form_start');

// Validate image
function action_woocommerce_save_account_details_errors($args)
{
    if (isset($_POST['image']) && empty($_POST['image'])) {
        $args->add('image_error', __('Please provide a valid image', 'astrip'));
    }
}
add_action('woocommerce_save_account_details_errors', 'action_woocommerce_save_account_details_errors', 10, 1);

// Save image
function action_woocommerce_save_account_details($user_id)
{
    if (isset($_FILES['image'])) {
        require_once(ABSPATH . 'wp-admin/includes/image.php');
        require_once(ABSPATH . 'wp-admin/includes/file.php');
        require_once(ABSPATH . 'wp-admin/includes/media.php');

        function wp_set_custom_upload_folder($uploads)
        {
            $uploads['path'] = $uploads['basedir'] . '/user-avatar';
            $uploads['url'] = $uploads['baseurl'] . '/user-avatar';
            if (!file_exists($uploads['path'])) {
                wp_mkdir_p($uploads['path'], 0755, true);
            }
            return $uploads;
        }
        add_filter('upload_dir', 'wp_set_custom_upload_folder');


        $attachment_id = media_handle_upload('image', 0);

        if (is_wp_error($attachment_id)) {
            update_user_meta($user_id, 'image', $_FILES['image'] . ": " . $attachment_id->get_error_message());
        } else {
            $old_attachment_id = get_user_meta($user_id, 'image', true);
            wp_delete_attachment($old_attachment_id);
            update_user_meta($user_id, 'image', $attachment_id);
        }
    }
}
add_action('woocommerce_save_account_details', 'action_woocommerce_save_account_details', 10, 1);

// Add enctype to form to allow image upload
function action_woocommerce_edit_account_form_tag()
{
    echo 'enctype="multipart/form-data"';
}
add_action('woocommerce_edit_account_form_tag', 'action_woocommerce_edit_account_form_tag');

// Remove Review and Rating Actions Button
add_filter('page_row_actions', 'astrip_remove_review_rating_actions', 10, 2);
function astrip_remove_review_rating_actions($actions, $post)
{
    if ('review-rating' == $post->post_type || 'enquiries' == $post->post_type) {
        return array();
    }
    return $actions;
}

if (class_exists('CSF')) {
    // Return to Shop Text and URL Change
    add_filter('woocommerce_return_to_shop_text', 'custom_return_to_tour_text');
    add_filter('woocommerce_return_to_shop_redirect', 'custom_return_to_tour_redirect');

    function custom_return_to_tour_text($text)
    {
        return __('Return to Tour', 'astrip');
    }

    function custom_return_to_tour_redirect($url)
    {
        return esc_url(get_post_type_archive_link('astrip-tour'));
    }
}

// Tour & Destination Permalink

function egens_load_permalinks()
{
    if (isset($_POST['egens_cpt_base'])) {
        update_option('egens_cpt_base', sanitize_title_with_dashes($_POST['egens_cpt_base']));
    }
    if (isset($_POST['egens_cpt_base2'])) {
        update_option('egens_cpt_base2', sanitize_title_with_dashes($_POST['egens_cpt_base2']));
    }
    // Add a settings field to the permalink page
    add_settings_field('egens_cpt_base', __('Tour Permalink', 'astrip'), 'egns_field_callback', 'permalink', 'optional');
    add_settings_field('egens_cpt_base2', __('Destination Permalink', 'astrip'), 'egns_field_callback2', 'permalink', 'optional');
}
add_action('load-options-permalink.php', 'egens_load_permalinks');
function egns_field_callback()
{
    $value = get_option('egens_cpt_base');
    echo '<input type="text" value="' . esc_attr($value) . '" name="egens_cpt_base" id="egens_cpt_base" class="regular-text" />';
}
function egns_field_callback2()
{
    $value = get_option('egens_cpt_base2');
    echo '<input type="text" value="' . esc_attr($value) . '" name="egens_cpt_base2" id="egens_cpt_base2" class="regular-text" />';
}
