<?php

/**
 * The main template file
 *
 * Template Name: Package Sidebar
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package astrip 
 * @since 1.3.0
 * 
 */

get_header();

if (!is_front_page()) {
    get_template_part('template-parts/breadcrumbs/breadcrumb-tour-archive');
}
?>
<div class="destination-details-section pt-120 pb-120">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-4">
                <?php get_template_part('template-parts/tour/package-sidebar'); ?>
                <?php dynamic_sidebar('tour_package_sidebar'); ?>
            </div>
            <div class="col-lg-8">
                <div class="circle-loader"></div>
                <div class="row g-4" id="tourFilterData">
                    <?php
                        global $wp_query;
                        $args = array(
                            'post_type' => 'astrip-tour',
                            'paged' => (get_query_var('paged')) ? get_query_var('paged') : 1
                        );
                        $wp_query = new WP_Query($args);
                    ?>
                    <?php if ($wp_query->have_posts()) :  ?>
                        <?php
                        while ($wp_query->have_posts()) {
                            $wp_query->the_post();
                            get_template_part('loop-templates/content-archive-tour-3');
                        }
                        wp_reset_postdata();
                        ?>
                    <?php else : ?>
                        <div class="package-not-found">
                            <img src="<?php echo esc_url(EGNS_ASSETS . '/images/icons/package-not-found.svg')  ?>" alt="<?php echo esc_attr__('Package not found', 'astrip') ?>">
                            <h3 class="text-center "><?php echo esc_html__('Tour Package not Found', 'astrip') ?></h3>
                            <p><?php echo esc_html__('It seems we can’t find what you’re looking for.', 'astrip') ?></p>
                            <a href="<?php echo esc_url(get_post_type_archive_link('astrip-tour')) ?>" class="eg-btn btn--primary btn--lg mt-5"><?php echo esc_html__('Back to Tour', 'astrip') ?></a>
                        </div>
                    <?php endif ?>
                    <div class="row justify-content-center">
                        <div class="col-md-12" id="tourPackagePagination">
                            <?php get_template_part('template-parts/tour/pagination'); ?>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>
</div>

<?php
// Theme Options value 
$theme_options = get_option('egns_theme_options'); // prefix of theme
if ($theme_options['astrip_insta_feed_switcher'] == true) :
    // Instagram Feed 
    get_template_part( 'template-parts/common/instagram' );
endif;

get_footer();
