<?php

/**
 * The template for displaying archive pages
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package astrip
 */
get_header();

if (!is_front_page()) :
	get_template_part('template-parts/breadcrumbs/breadcrumb-destination');
endif;

$args = array(
	'post_type' 		=> 'astrip-destination',
	'post_status' 		=> 'publish',
	'orderby'    		=> 'DSC',
	'posts_per_page'		=> 8,
);
$my_query = new \WP_Query($args);

?>

<div class="destination-section sec-mar">
	<div class="container">
		<div class="destination-wrap">
			<?php
			$i = 0;
			if ($my_query->have_posts()) {
				while ($my_query->have_posts()) {
					$my_query->the_post();
					$i++;

					$tourCount = egens_core()->get_tour_count_by_destination_id(get_the_ID());
			?>
					<div class="destination-single1">
						<?php if (has_post_thumbnail()) : ?>
							<?php the_post_thumbnail('', ['class' => 'destination-img img-fluid']); ?>
						<?php endif ?>
						<div class="content">
							<div class="text-wrap">
								<h4><a href="<?php esc_url(the_permalink()) ?>"><?php echo wp_kses(get_the_title(), wp_kses_allowed_html('post')) ?></a></h4>
								<?php if (!empty($tourCount)) : ?>
									<p><?php echo esc_html($tourCount);  ?><?php echo esc_html__(' Tours Place', 'astrip') ?></p>
								<?php endif; ?>
							</div>
						</div>
					</div>
			<?php
				}
			}
			?>
		</div>
		<div class="row justify-content-center">
			<div class="col-md-8">
				<?php get_template_part('template-parts/blog/pagination'); ?>
			</div>
		</div>
		<?php wp_reset_query(); ?>
	</div>
</div>

<?php
// Theme Options value 
$theme_options = get_option('egns_theme_options'); // prefix of theme
if ($theme_options['astrip_insta_feed_switcher'] == true) :
	// Instagram Feed 
	get_template_part('template-parts/common/instagram');
endif;
get_footer();
