<?php

//Post tags custom widget
class Egens_Tour extends WP_Widget
{

    function __construct()
    {
        parent::__construct(

            //Base ID of our widget
            'egens_tour',

            //Widget name
            __('Egns Tour Type', 'egens-core'),

            //Widget description
            array('description' => __('Egns Tour Type', 'egens-core'),)
        );
    }

    public function widget($args, $instance)
    {
        $title = apply_filters('widget_title', $instance['title']);
?>
        <div class="desti-sidebar-widget tour-category">
            <?php
            if (!empty($title)) {
            ?>
                <h4 class="widget-title"><?php echo  esc_attr(__($title, 'astrip-core')); ?></h4>
            <?php
            }
            ?>
            <ul class="tour-category-list">
                <?php

                $all_tour_type      = get_terms(
                    array(
                        'taxonomy'   => 'astrip-tour-type',
                        'hide_empty' => false,
                        'number' => 5,
                        'count' => true,
                    )
                );
                foreach ($all_tour_type as $type) :
                ?>
                    <li><a href="<?php echo $type->slug ?>"><?php echo $type->name ?> (<?php echo $type->count ?>)</a></li>
                <?php endforeach; ?>

            </ul>
        </div>
    <?php
    }
    // Widget Backend
    public function form($instance)
    {
        $title = '';
        if (isset($instance['title'])) {
            $title = $instance['title'];
        }
    ?>
        <!--Tour Package-->
        <p>
            <label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('Title:', 'egens-core'); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo esc_attr($title); ?>" />
        </p>
<?php
    }

    // Updating widget replacing old instances with
    public function update($new_instance, $old_instance)
    {
        $instance = array();
        $instance['title'] = (!empty($new_instance['title'])) ? strip_tags($new_instance['title']) : '';
        $instance['tour_package'] = (!empty($new_instance['tour_package'])) ? strip_tags($new_instance['tour_package']) : '';
        return $instance;
    }
}
if (!function_exists('Egens_Tour')) {
    function Egens_Tour()
    {
        register_widget('Egens_Tour');
    }
    add_action('widgets_init', 'Egens_Tour');
}
