<?php

//Post tags custom widget
class Egens_Footer_Logo extends WP_Widget {

    function __construct() {
        parent::__construct(

            //Base ID of our widget
            'egens_footer_logo',

            //Widget name
            __( 'Egns Footer Logo', 'egens-core' ),

            //Widget description
            array( 'description' => __( 'Egns Footer Logo', 'egens-core' ), )
        );
    }

    public function widget($args, $instance)
	{
?>

    
        <div class="footer-item">
            <div id="block-7" class="destination-widget-item widget_block"><div class="footer-item">
                <div id="block-7" class="destination-widget-item widget_block"><div class="footer-about">
                    <?php if( isset( $instance['bg_image'] ) ) : ?>
                        <img src="<?php echo esc_url( $instance['bg_image'] ) ?>" class="footer-plane" alt="<?php echo esc_attr('bg-image') ?>">
                    <?php else : ?>
                        <img src="https://demo.egenslab.com/html/astrip/preview/assets/images/icons/footer-plane.svg" class="footer-plane" alt="image">
                    <?php endif ?>
                    <div class="footer1-logo">
                        <?php if( isset( $instance['logo_url'] ) ) : ?>
                            <img src="<?php echo esc_url( $instance['logo_url'] ) ?>" alt="image">
                        <?php else : ?>
                            <img src="https://demo.egenslab.com/html/astrip/preview/assets/images/icons/footer1-logo.svg" alt="image">
                        <?php endif ?>
                        <p><?php echo  esc_html( __( $instance['year_text'], 'egens-core' ) ); ?></p>
                    </div>
                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" viewBox="0 0 400 400">
                        <defs>
                        <!-- The text path: see links above regarding coordinate system -->
                        <path d="M0, 200a200, 200 0 1, 0 400, 0a200, 200 0 1, 0 -400, 0" id="txt-path" fill="white"></path>
                        </defs>
                    
                        <text fill="#DDDDDD" font-size="35.5" font-family="Helvetica Neue" font-weight="600">
                        <!-- This is the magic -->
                        <textPath startOffset="0" xlink:href="#txt-path"><?php echo  esc_html( __( $instance['text_path'], 'egens-core' ) ); ?></textPath>
                        </text>
                    </svg>
                </div>
            </div>                            
        </div>
        </div>                            
    </div>

	<?php
	}
    // Widget Backend
    public function form($instance)
    {
        $year_text = '';
        if (isset($instance['year_text'])) {
            $year_text = $instance['year_text'];
        }
        $text_path = '';
        if (isset($instance['text_path'])) {
            $text_path = $instance['text_path'];
        }
        $logo_url = '';
        if (isset($instance['logo_url'])) {
            $logo_url = $instance['logo_url'];
        }
        $bg_image = '';
        if (isset($instance['bg_image'])) {
            $bg_image = $instance['bg_image'];
        }
    ?>
        <!--Footer Logo-->
        <p>
            <label for="<?php echo $this->get_field_id('year_text'); ?>"><?php _e('Year Text:', 'egens-core'); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id('year_text'); ?>"
                   name="<?php echo $this->get_field_name('year_text'); ?>" type="text"
                   value="<?php echo esc_attr($year_text); ?>"/>
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('text_path'); ?>"><?php _e('Text Path:', 'egens-core'); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id('text_path'); ?>"
                   name="<?php echo $this->get_field_name('text_path'); ?>" type="text"
                   value="<?php echo esc_attr($text_path); ?>"/>
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('logo_url'); ?>"><?php _e('Logo URL:', 'egens-core'); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id('logo_url'); ?>"
                   name="<?php echo $this->get_field_name('logo_url'); ?>" type="text"
                   value="<?php echo esc_attr($logo_url); ?>"/>
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('bg_image'); ?>"><?php _e('Background URL:', 'egens-core'); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id('bg_image'); ?>"
                   name="<?php echo $this->get_field_name('bg_image'); ?>" type="text"
                   value="<?php echo esc_attr($bg_image); ?>"/>
        </p>
<?php
    }

    // Updating widget replacing old instances with
    public function update($new_instance, $old_instance)
    {
        $instance = array();
        $instance['year_text'] = (!empty($new_instance['year_text'])) ? strip_tags($new_instance['year_text']) : '';
        $instance['text_path'] = (!empty($new_instance['text_path'])) ? strip_tags($new_instance['text_path']) : '';
        $instance['logo_url'] = (!empty($new_instance['logo_url'])) ? strip_tags($new_instance['logo_url']) : '';
        $instance['bg_image'] = (!empty($new_instance['bg_image'])) ? strip_tags($new_instance['bg_image']) : '';
        return $instance;
    }
}
if (!function_exists('Egens_Footer_Logo')) {
    function Egens_Footer_Logo()
    {
        register_widget('Egens_Footer_Logo');
    }
    add_action('widgets_init', 'Egens_Footer_Logo');
}
