<?php

namespace Elementor;

if (!defined('ABSPATH')) exit; // Exit if accessed directly

use Elementor\core\Schemes;

class Astrip_tour_package_Widget extends Widget_Base
{

    public function get_name()
    {
        return 'astrip_tour_package';
    }

    public function get_title()
    {
        return esc_html__('EG Tour Package', 'astrip-core');
    }

    public function get_icon()
    {
        return ' eicon-price-table';
    }

    public function get_categories()
    {
        return ['astrip_widgets'];
    }

    protected function register_controls()
    {

        //grneral section
        $this->start_controls_section(
            'astrip_tour_package_general_section',
            [
                'label' => esc_html__('General', 'astrip-core')
            ]
        );



        $this->add_control(
            'astrip_tour_package_style_selection',
            [
                'label'     => esc_html__('Select Style', 'astrip-core'),
                'type'      => \Elementor\Controls_Manager::SELECT,
                'default'   => 'style_one',
                'options'   => [
                    'style_one'        => esc_html__('Style One', 'astrip-core'),
                    'style_two'        => esc_html__('Style Two', 'astrip-core'),

                ],
            ]
        );

        $this->add_control(
            'turio_packages',
            [
                'label'             => __('Select Tour', 'turio-core'),
                'type'                 => \Elementor\Controls_Manager::SELECT2,
                'label_block'         => true,
                'multiple'            => true,
                'options'             => egens_core()->get_post_list_by_post_type('astrip-tour'),
                'default'             => egens_core()->get_all_post_key('astrip-tour'),
            ]
        );



        $this->add_control(
            'astrip_tour_package_content_column_selection',
            [
                'label'   => esc_html__('Column (Large Device)', 'astrip-core'),
                'type'    => Controls_Manager::SELECT,
                'options' => [
                    'column_two'  => esc_html__('2', 'astrip-core'),
                    'column_three' => esc_html__('3', 'astrip-core'),
                    'column_four' => esc_html__('4', 'astrip-core'),
                ],
                'default' => 'column_four',
                'condition' => [
                    'astrip_tour_package_style_selection' => 'style_one'
                ]

            ]
        );



        $this->add_control(
            'astrip_tour_package_posts_per_page',
            [
                'label'       => esc_html__('Posts Per Page', 'astrip-core'),
                'type'        => Controls_Manager::NUMBER,
                'default'     => 5,
                'label_block' => false,
            ]
        );
        $this->add_control(
            'astrip_tour_package_template_order_by',
            [
                'label'   => esc_html__('Order By', 'astrip-core'),
                'type'    => Controls_Manager::SELECT,
                'default' => 'ID',
                'options' => [
                    'ID'         => esc_html__('Post Id', 'astrip-core'),
                    'author'     => esc_html__('Post Author', 'astrip-core'),
                    'title'      => esc_html__('Title', 'astrip-core'),
                    'post_date'  => esc_html__('Date', 'astrip-core'),
                    'rand'       => esc_html__('Random', 'astrip-core'),
                    'menu_order' => esc_html__('Menu Order', 'astrip-core'),
                ],
            ]
        );
        $this->add_control(
            'astrip_tour_package_template_order',
            [
                'label'   => esc_html__('Order', 'astrip-core'),
                'type'    => Controls_Manager::SELECT,
                'options' => [
                    'asc'  => esc_html__('Ascending', 'astrip-core'),
                    'desc' => esc_html__('Descending', 'astrip-core')
                ],
                'default' => 'desc',
            ]
        );



        $this->add_control(
            'astrip_tour_package_content_pagination_icon',
            [
                'label' => esc_html__('Pagination Icon', 'astrip-core'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'astrip-core'),
                'label_off' => esc_html__('Hide', 'astrip-core'),
                'return_value' => 'yes',
                'default' => 'yes',
                'condition' => [
                    'astrip_tour_package_style_selection' => ['style_two'],
                ]
            ]
        );



        $this->end_controls_section();

        //Content two heading

        $this->start_controls_section(
            'astrip_heading_content_main_title_section',
            [
                'label' => esc_html__('Heading', 'astrip-core'),
                'condition' => [
                    'astrip_tour_package_style_selection' => ['style_two']
                ],
            ]
        );
        $this->add_control(
            'astrip_heading_content_sub_title',
            [
                'label' => esc_html__('Sub Title', 'astrip-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('Choose Your’s', 'astrip-core'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'astrip_heading_content_main_title',
            [
                'label' => esc_html__('Main Title', 'astrip-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('Get The Best Astrip Tour’s', 'astrip-core'),
                'label_block' => true,
            ]
        );
        $this->end_controls_section();

        //Style Section Start


        $this->start_controls_section(
            'astripi_tour_one_style',
            [
                'label' => esc_html__('Image', 'astrip-core'),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'astrip_tour_package_style_selection' => ['style_one']
                ],
            ]
        );

        $this->add_responsive_control(
            'astripi_tour_one_style_height',
            [
                'label'       => esc_html__('Height', 'astrip-core'),
                'type'        => Controls_Manager::TEXT,
                'description' => 'Unit in px',
                'selectors'   => [
                    '{{WRAPPER}} .deal-single1 .deal-image img ' => 'height: {{VALUE}}px;',
                ],
            ]
        );
        $this->add_responsive_control(
            'astripi_tour_one_style_width',
            [
                'label'       => esc_html__('Width', 'astrip-core'),
                'type'        => Controls_Manager::TEXT,
                'description' => 'Unit in %',
                'selectors'   => [
                    '{{WRAPPER}} .deal-single1 .deal-image img ' => 'width: {{VALUE}}%;',
                ],
            ]
        );
        $this->add_responsive_control(
            'astripi_tour_one_style_border_radius',
            [
                'label'      => __('Border Radius', 'astrip-core'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .deal-single1 .deal-image img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]
        );





        $this->end_controls_section();


        $this->start_controls_section(
            'astripi_tour_two_style',
            [
                'label' => esc_html__('Image', 'astrip-core'),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'astrip_tour_package_style_selection' => ['style_two']
                ],
            ]
        );



        $this->add_responsive_control(
            'astripi_tour_two_style_height',
            [
                'label'       => esc_html__('Height', 'astrip-core'),
                'type'        => Controls_Manager::TEXT,
                'description' => 'Unit in px',
                'selectors'   => [
                    '{{WRAPPER}} .tour-package-single2 .image img ' => 'height: {{VALUE}}px;',
                ],
            ]
        );
        $this->add_responsive_control(
            'astripi_tour_two_style_width',
            [
                'label'       => esc_html__('Width', 'astrip-core'),
                'type'        => Controls_Manager::TEXT,
                'description' => 'Unit in %',
                'selectors'   => [
                    '{{WRAPPER}} .tour-package-single2 .image img ' => 'width: {{VALUE}}%;',
                ],
            ]
        );
        $this->add_responsive_control(
            'astripi_tour_two_style_border_radius',
            [
                'label'      => __('Border Radius', 'astrip-core'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .tour-package-single2 .image img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]
        );





        $this->end_controls_section();

        //Heading Sub Title Style Section Start
        $this->start_controls_section(
            'astrip_heading_style_sub_title_section',
            [
                'label' => esc_html__('Heading Sub Title', 'astrip-core'),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'astrip_tour_package_style_selection' => 'style_two'
                ],
            ]
        );
        $this->add_control(
            'astrip_heading_style_sub_title_color',
            [
                'label'     => esc_html__('Color', 'astrip-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title3 span' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'astrip-core'),
                'name'     => 'astrip_heading_style_sub_title_typography',
                'selector' => '{{WRAPPER}}  .section-title3 span',

            ]
        );
        $this->add_responsive_control(
            'astrip_heading_style_sub_title_padding',
            [
                'label'      => __('Padding', 'astrip-core'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .section-title3 span' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',

                ],
            ]
        );
        $this->add_responsive_control(
            'astrip_heading_style_sub_title_margin',
            [
                'label' => esc_html__('Margin', 'astrip-core'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .section-title3 span' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();
        //Heading Title Style Section Start
        $this->start_controls_section(
            'astrip_heading_style_main_title_section',
            [
                'label' => esc_html__('Heading Title', 'astrip-core'),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'astrip_tour_package_style_selection' => 'style_two'
                ],
            ]
        );
        $this->add_control(
            'astrip_heading_style_main_title_color',
            [
                'label'     => esc_html__('Color', 'astrip-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title3 h2' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'astrip-core'),
                'name'     => 'astrip_heading_style_main_title_typography',
                'selector' => '{{WRAPPER}} .section-title3 h2',

            ]
        );
        $this->add_responsive_control(
            'astrip_heading_style_main_title_padding',
            [
                'label'      => __('Padding', 'astrip-core'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .section-title3 h2' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',

                ],
            ]
        );
        $this->add_responsive_control(
            'astrip_heading_style_main_title_margin',
            [
                'label' => esc_html__('Margin', 'astrip-core'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .section-title3 h2' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();
        //Discount Style Start
        $this->start_controls_section(
            'astrip_tour_package_style_discount_section',
            [
                'label' => esc_html__('Discount', 'astrip-core'),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'astrip_tour_package_style_selection' => 'style_one'
                ],
            ]
        );
        $this->add_control(
            'astrip_tour_package_style_discount_color',
            [
                'label'     => esc_html__('Color', 'astrip-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .deal-single1 .deal-image span.discount-bagde' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .deal-single1 .deal-image span.discount-bagde::after' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'astrip_tour_package_style_discuuuount_hover_color',
            [
                'label'     => esc_html__('Hover Percentage Color', 'astrip-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [

                    '{{WRAPPER}} .deal-single1:hover .deal-image span.discount-bagde::after' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'astrip_tour_package_style_discuuount_hover_color',
            [
                'label'     => esc_html__('Hover Text Color', 'astrip-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .deal-single1:hover .deal-image span.discount-bagde' => 'color: {{VALUE}};',

                ],
            ]
        );


        $this->add_control(
            'astrip_tour_package_style_discount_text_background',
            [
                'label'     => esc_html__('Percentage Background Color', 'astrip-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .deal-single1 .deal-image span.discount-bagde' => 'background: {{VALUE}};',

                ],
            ]
        );
        $this->add_control(
            'astrip_tour_packagvfe_style_discount_text_background',
            [
                'label'     => esc_html__('Text Background Color', 'astrip-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [

                    '{{WRAPPER}} .deal-single1 .deal-image span.discount-bagde::after' => 'background: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'astrip_package_with_discount_style_discount_text_hover_background',
            [
                'label'     => esc_html__('Hover Percentage Background Color', 'astrip-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .deal-single1:hover .deal-image span.discount-bagde' => 'background: {{VALUE}};',
                    '{{WRAPPER}} .deal-single1:hover .deal-image span.discount-bagde::after' => 'background: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'astrip_package_with_discfdfddfount_style_discount_text_hover_background',
            [
                'label'     => esc_html__('Hover Text Background Color', 'astrip-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [

                    '{{WRAPPER}} .deal-single1:hover .deal-image span.discount-bagde::after' => 'background: {{VALUE}};',
                ],
            ]
        );


        $this->end_controls_section();


        //Review star style
        $this->start_controls_section(
            'astrip_tour_package_style_review_star_section',
            [
                'label' => esc_html__('Star Icon', 'astrip-core'),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'astrip_tour_package_style_selection' => 'style_one'
                ],

            ]
        );

        $this->add_control(
            'astrip_tour_package_style_review_star_color',
            [
                'label'     => esc_html__('Color', 'astrip-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .review-area .star-list li .bi' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();
        //Review Style Start
        $this->start_controls_section(
            'astrip_tour_package_style_review_section',
            [
                'label' => esc_html__('Review', 'astrip-core'),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'astrip_tour_package_style_selection' => 'style_one'
                ],

            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'astrip-core'),
                'name'     => 'astrip_tour_package_style_review_typography',
                'selector' =>
                '{{WRAPPER}} .review-area > span',


            ]
        );
        $this->add_control(
            'astrip_tour_package_style_review_color',
            [
                'label'     => esc_html__('Color', 'astrip-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .review-area > span' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'astrip_tour_package_style_review_padding',
            [
                'label'      => __('Padding', 'astrip-core'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .review-area > span' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',

                ],
            ]
        );

        $this->end_controls_section();

        //Title Style Start
        $this->start_controls_section(
            'astrip_tour_package_style_one_title_section_one_twos',
            [
                'label' => esc_html__('Title', 'astrip-core'),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'astrip_tour_package_style_selection' => 'style_one'
                ],

            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'astrip-core'),
                'name'     => 'astrip_tour_package_style_one_title_typography_twos',
                'selector' =>
                '{{WRAPPER}} .deal-single1 .deal-content h4 a,.offer-single .content a',


            ]
        );
        $this->add_control(
            'astrip_tour_package_style_one_title_color_twoss',
            [
                'label'     => esc_html__('Color', 'astrip-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .deal-single1 .deal-content h4 a' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .offer-single .content a' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'astrip_tour_package_style_one_title_padding_twos',
            [
                'label'      => __('Padding', 'astrip-core'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .deal-single1 .deal-content h4 a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .offer-single .content a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',

                ],
            ]
        );


        $this->end_controls_section();

        // Start Package previous Price Style
        $this->start_controls_section(
            'astrip_package_previous_price',
            [
                'label' => esc_html__('Previous Price', 'astrip-core'),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'astrip_tour_package_style_selection' => 'style_one'
                ],
            ]
        );
        $this->add_control(
            'astrip_package_previous_price_style_color',
            [
                'label'  => esc_html__('Color', 'astrip-core'),
                'type'   => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .deal-single1 .deal-content .price del' => 'color : {{VALUE}};',
                ]
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label' => esc_html__('Typography', 'astrip-core'),
                'name' => 'astrip_package_previous_price_style_typography',
                'selector' =>
                '{{WRAPPER}} .deal-single1 .deal-content .price del',


            ]
        );
        $this->end_controls_section();

        // Package Current Price Style
        $this->start_controls_section(
            'astrip_package_price_twos',
            [
                'label' => esc_html__('Current Price', 'astrip-core'),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'astrip_tour_package_style_selection' => 'style_one'
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label' => esc_html__('Typography', 'astrip-core'),
                'name' => 'astrip_package_current_price_style_typography_twos',
                'selector' =>
                '{{WRAPPER}} .deal-single1 .deal-content .price span;',

            ]
        );
        $this->add_control(
            'astrip_package_price_style_color_twos',
            [
                'label'  => esc_html__('Color', 'astrip-core'),
                'type'   => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .deal-single1 .deal-content .price span' => 'color : {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'astrip_package_price_style_padding_twos',
            [
                'label'      => __('Padding', 'astrip-core'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .deal-single1 .deal-content .price span' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',

                ],
            ]
        );
        $this->end_controls_section();

        //Title Style Start
        $this->start_controls_section(
            'astrip_tour_package_style_one_title_section_two_threes',
            [
                'label' => esc_html__('Title', 'astrip-core'),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'astrip_tour_package_style_selection' => 'style_two'
                ],

            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'astrip-core'),
                'name'     => 'astrip_tour_package_style_one_title_typography_threes',
                'selector' =>
                '{{WRAPPER}} .tour-package-single2 .content h4 a',


            ]
        );
        $this->add_control(
            'astrip_tour_package_style_one_title_color_three',
            [
                'label'     => esc_html__('Color', 'astrip-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tour-package-single2 .content h4 a' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'astrip_tour_package_style_ones_title_padding_threes',
            [
                'label'      => __('Padding', 'astrip-core'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .tour-package-single2 .content h4 a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',

                ],
            ]
        );


        $this->end_controls_section();
        //description Style Start
        $this->start_controls_section(
            'astrip_tour_package_style_one_description_section',
            [
                'label' => esc_html__('Description', 'astrip-core'),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'astrip_tour_package_style_selection' => 'style_two'
                ],

            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'astrip-core'),
                'name'     => 'astrip_tour_package_style_one_description_typography',
                'selector' =>
                '{{WRAPPER}} .tour-package-single2 .content p',


            ]
        );
        $this->add_control(
            'astrip_tour_package_style_one_description_color',
            [
                'label'     => esc_html__('Color', 'astrip-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tour-package-single2 .content p' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'astrip_tour_package_style_one_description_padding',
            [
                'label'      => __('Padding', 'astrip-core'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .tour-package-single2 .content p' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',

                ],
            ]
        );


        $this->end_controls_section();


        // Package  Price Style
        $this->start_controls_section(
            'astrip_package_price_threes',
            [
                'label' => esc_html__('Price', 'astrip-core'),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'astrip_tour_package_style_selection' => 'style_two'
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label' => esc_html__('Typography', 'astrip-core'),
                'name' => 'astrip_package_current_price_style_typography_threes',
                'selector' =>
                '{{WRAPPER}} .tour-package-single .package-content span.price',

            ]
        );
        $this->add_control(
            'astrip_package_price_style_color_threes',
            [
                'label'  => esc_html__('Color', 'astrip-core'),
                'type'   => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tour-package-single .package-content span.price' => 'color : {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'astrip_tour_package_style_price_bg_color',
            [
                'label'     => esc_html__('Background Hover Color', 'astrip-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tour-package-single2 .image span.blog-date' => 'background: {{VALUE}};',
                ],

            ]
        );

        $this->add_responsive_control(
            'astrip_package_price_style_padding_threes',
            [
                'label'      => __('Padding', 'astrip-core'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .tour-package-single .package-content span.price' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',

                ],
            ]
        );
        $this->end_controls_section();



        //Reading Button Style Start
        $this->start_controls_section(
            'astrip_tour_package_style_one_reading_btn_section',
            [
                'label' => esc_html__('Button', 'astrip-core'),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'astrip_tour_package_style_selection' => 'style_one'
                ],

            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'astrip-core'),
                'name'     => 'astrip_tour_package_style_one_reading_btn_typography',
                'selector' => '{{WRAPPER}} .btn--md',

            ]
        );
        $this->add_control(
            'astrip_tour_package_style_one_reading_btn_color',
            [
                'label'     => esc_html__('Color', 'astrip-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .btn--primary-outline' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'astrip_tour_package_style_one_reading_btn_hover_color',
            [
                'label'     => esc_html__('Hover Color', 'astrip-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .btn--primary-outline:hover' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'astrip_tour_package_style_one_reading_btn_background_color',
            [
                'label'     => esc_html__('Background Color', 'astrip-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .btn--primary-outline' => 'background: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'astrip_tour_package_style_one_reading_btn_background_hover_color',
            [
                'label'     => esc_html__('Hover Background Color', 'astrip-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .btn--primary-outline:hover::after' => 'background: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'astrip_tour_package_style_one_reading_btn_border_color',
            [
                'label'     => esc_html__('Border Color', 'astrip-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .btn--primary-outline' => 'border:2px solid {{VALUE}}',
                ],
            ]
        );


        $this->add_responsive_control(
            'astrip_tour_package_style_one_reading_btn_padding',
            [
                'label'      => __('Padding', 'astrip-core'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .btn--md' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',

                ],
            ]
        );
        $this->add_responsive_control(
            'astrip_tour_package_style_one_reading_btn_margin',
            [
                'label' => esc_html__('Margin', 'astrip-core'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .btn--md' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        //Explore Button Style Start
        $this->start_controls_section(
            'astrip_tour_package_style_two_reading_btn_section',
            [
                'label' => esc_html__('Explore Button', 'astrip-core'),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'astrip_tour_package_style_selection' => 'style_two'
                ],

            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'astrip-core'),
                'name'     => 'astrip_tour_package_style_two_reading_btn_typography',
                'selector' => '{{WRAPPER}} .read-more-btn.sibling-2',

            ]
        );
        $this->add_control(
            'astrip_tour_package_style_two_reading_btn_color',
            [
                'label'     => esc_html__('Color', 'astrip-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .read-more-btn.sibling-2' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'astrip_tour_package_style_two_reading_btn_hover_color',
            [
                'label'     => esc_html__('Hover Color', 'astrip-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .read-more-btn.sibling-2:hover' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'astrip_tour_package_style_two_reading_btn_background_color',
            [
                'label'     => esc_html__('Background Color', 'astrip-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .read-more-btn.sibling-2' => 'background: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'astrip_tour_package_style_two_reading_btn_border_color',
            [
                'label'     => esc_html__('Border Color', 'astrip-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .read-more-btn.sibling-2' => 'border:1px solid {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'astrip_tour_package_style_two_reading_btn_background_hover_color',
            [
                'label'     => esc_html__('Hover Background Color', 'astrip-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .read-more-btn.sibling-2:hover' => 'background: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'astrip_tour_package_style_two_reading_btn_margin',
            [
                'label' => esc_html__('Margin', 'astrip-core'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .read-more-btn.sibling-2' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );


        $this->add_responsive_control(
            'astrip_tour_package_style_two_reading_btn_padding',
            [
                'label'      => __('Padding', 'astrip-core'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .read-more-btn.sibling-2' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',

                ],
            ]
        );


        $this->end_controls_section();
    }
    protected function render()
    {

        $settings = $this->get_settings_for_display();
        $query = new \WP_Query(
            array(
                'post_type'      => 'astrip-tour',
                'posts_per_page' => $settings['astrip_tour_package_posts_per_page'],
                'orderby'        => $settings['astrip_tour_package_template_order_by'],
                'order'          => $settings['astrip_tour_package_template_order'],
                'post__in'       => $settings['turio_packages'],
                'offset'         => 0,
                'post_status'    => 'publish'
            )
        );
?>
        <?php if (is_admin()) : ?>
            <script>
                // package slidder-2
                var swiper = new Swiper(".package-slider2", {
                    slidesPerView: 1,
                    speed: 800,
                    loop: true,
                    freeMode: true,
                    spaceBetween: 25,
                    grabCursor: true,
                    slidesPerView: 7,
                    loop: true,
                    // autoplay: {
                    //     delay: 10,
                    //     disableOnInteraction: true
                    // },
                    freeMode: true,
                    freeModeMomentum: false,
                    navigation: {
                        nextEl: '.package2-prev',
                        prevEl: '.package2-next',
                    },
                    pagination: {
                        el: ".swiper-pagination",
                        clickable: 'true',
                    },
                    breakpoints: {
                        280: {
                            slidesPerView: 1,
                            navigation: false,
                        },
                        420: {
                            slidesPerView: 1,
                            navigation: false,
                        },
                        576: {
                            slidesPerView: 2,
                            navigation: false,
                        },
                        768: {
                            slidesPerView: 2,
                            navigation: false,
                        },
                        992: {
                            slidesPerView: 3
                        },
                        1200: {
                            slidesPerView: 3
                        },
                        1400: {
                            slidesPerView: 3
                        },
                        1500: {
                            slidesPerView: 4
                        },
                    }
                });
            </script>
        <?php endif ?>


        <?php if (!empty($settings['astrip_tour_package_style_selection']) && ($settings['astrip_tour_package_style_selection'] == 'style_one')) : ?>
            <div class="deal-section">
                <div class="container-fluid">
                    <div class="row justify-content-center g-4">

                        <?php
                        if ($query->have_posts()) {
                            while ($query->have_posts()) {
                                $query->the_post();
                                $product_id = egens_core()->egns_post_meta_box_value(get_the_ID(), EGNS_TOUR_META_ID, 'tour_product');
                                $show_offer = false;
                                $get_booking_form_type = egens_core()->egns_post_meta_box_value(get_the_ID(),EGNS_TOUR_META_ID, 'tour_booking_options');
                                $price_html = '';
                                if( $get_booking_form_type != 'enquiry_form' ) {
                                    if( class_exists('Woocommerce') && !empty( $product_id ) ) {
                                        $product = wc_get_product( $product_id );
                                        if ( egens_core()->egns_check_sale_price_schedule( $product->get_id() ) ) {
                                            $price_html = '<span>'.'From '.get_woocommerce_currency_symbol().egens_core()->egns_calculate_product_price($product->get_id()).'</span>/' . ' <del>' . get_woocommerce_currency_symbol() . $product->get_regular_price() .  '</del>';
                                        } else {
                                            $price_html = '<span>'.'From '. get_woocommerce_currency_symbol() .egens_core()->egns_calculate_product_price($product->get_id()).'</span>';
                                        }
                                    }
                                }else{
                                    if( !empty( egens_core()->egns_post_meta_box_value( get_the_ID(),EGNS_TOUR_META_ID, 'sale_price' ) ) ) {
                                        $price_html = '<span>'.'From '.egens_core()->egns_calculate_product_price().'</span>/' . ' <del>' . egens_core()->egns_post_meta_box_value(get_the_ID(), EGNS_TOUR_META_ID, 'regular_price' ) .  '</del>';
                            
                                    }else{
                                        $price_html =  egens_core()->egns_calculate_product_price();
                                    }
                                }
                                if (!empty($product_id)) :
                        ?>

                                    <!-- Content  -->
                                    <?php if ($settings['astrip_tour_package_content_column_selection'] == 'column_two') : ?>
                                        <div class="col-xl-6 col-lg-4 col-md-6 col-sm-8">
                                        <?php elseif ($settings['astrip_tour_package_content_column_selection'] == 'column_three') : ?>
                                            <div class="col-xl-4 col-lg-4 col-md-6 col-sm-8">
                                            <?php elseif ($settings['astrip_tour_package_content_column_selection'] == 'column_four') : ?>
                                                <div class="col-xl-3 col-lg-4 col-md-6 col-sm-8">
                                                <?php endif ?>

                                                <div class="deal-single1">
                                                    <div class="deal-image">
                                                        <?php if ($show_offer) : ?>
                                                            <span class="discount-bagde"><?php echo egens_core()->egns_calculate_offer_percent($product_id) ?><?php echo esc_html('%') ?></span>
                                                        <?php endif; ?>
                                                        <?php the_post_thumbnail('egns-img-one', array('class' => 'img-fluid')); ?>
                                                    </div>
                                                    <div class="deal-content">
                                                        <div class="review-area">
                                                            <?php if( egens_core()->egns_core_get_avg_rating_by_tour_id( get_the_ID() ) > 0 ) : ?>
                                                                <ul class="star-list">
                                                                    <?php 
                                                                        for ($x = 1; $x <= 5; $x++) {
                                                                            if( egens_core()->egns_core_get_avg_rating_by_tour_id( get_the_ID() ) >= $x ) {
                                                                                echo wp_kses_post( '<li><i class="bi bi-star-fill"></i></li>' );
                                                                            }else{
                                                                                echo wp_kses_post( '<li><i class="bi bi-star"></i></li>' );
                                                                            }
                                                                        }
                                                                    ?>
                                                                </ul>
                                                                <?php if( egens_core()->egns_core_get_all_rating_count_by_tour_id( get_the_ID() ) > 0 ) : ?>
                                                                    <span>(<?php echo egens_core()->egns_core_get_avg_rating_by_tour_id( get_the_ID() ); ?> <?php echo egens_core()->egns_core_get_all_rating_count_by_tour_id( get_the_ID() ) == 1 ? esc_html__('Review','astrip') : esc_html__('Reviews','astrip') ?>)</span>
                                                                <?php endif ?> 
                                                            <?php endif ?>
                                                        </div>
                                                        <h4><a href="<?php the_permalink() ?>"><?php the_title() ?></a></h4>
                                                        <?php if( isset( $price_html ) ) : ?>
                                                            <div class="price">
                                                                <?php echo $price_html ?>
                                                            </div>
                                                        <?php endif ?>
                                                        <a href="<?php the_permalink() ?>" class="eg-btn btn--primary-outline btn--md"><?php echo esc_html__('Explorer Now', 'astrip-core') ?></a>
                                                    </div>
                                                </div>
                                                </div>
                                                <!-- Content End -->
                                    <?php endif;
                            }
                        }
                        wp_reset_postdata();
                                    ?>

                                            </div>
                                        </div>
                    </div>
                <?php endif ?>




                <?php if (!empty($settings['astrip_tour_package_style_selection']) && ($settings['astrip_tour_package_style_selection'] == 'style_two')) : ?>
                    <div class="tour-package-section2">
                        <div class="row justify-content-start align-items-center mb-60">
                            <div class="col-lg-6 col-md-12 text-md-start text-center">
                                <div class="section-title3 d-flex flex-column justify-content-center mb-0">
                                    <?php if (!empty($settings['astrip_heading_content_sub_title'])) : ?>
                                        <span><?php echo esc_html($settings['astrip_heading_content_sub_title']) ?></span>
                                    <?php endif ?>
                                    <?php if (!empty($settings['astrip_heading_content_main_title'])) : ?>
                                        <h2><?php echo wp_kses($settings['astrip_heading_content_main_title'], wp_kses_allowed_html('post')) ?></h2>
                                    <?php endif ?>
                                </div>
                            </div>
                            <?php if ('yes' === $settings['astrip_tour_package_content_pagination_icon']) : ?>
                                <div class="col-lg-6 col-md-4">
                                    <div class="slider-arrows arrows-style-4 text-center d-md-flex d-none flex-row gap-5 justify-content-end align-items-center pt-1">
                                        <div class="package2-prev swiper-prev-arrow" tabindex="0" role="button" aria-label="Next slide" aria-controls="swiper-wrapper-8da655008828eaea">
                                            <i class="bi bi-arrow-left"></i>
                                        </div>
                                        <div class="package2-next swiper-next-arrow" tabindex="0" role="button" aria-label="Previous slide" aria-controls="swiper-wrapper-8da655008828eaea">
                                            <i class="bi bi-arrow-right"></i>
                                        </div>
                                    </div>
                                </div>
                            <?php endif ?>
                        </div>
                        <div class="row">
                            <div class="col-12">
                                <div class="swiper package-slider2">
                                    <div class="swiper-wrapper">


                                        <?php
                                        if ($query->have_posts()) {
                                            while ($query->have_posts()) {
                                                $query->the_post();
                                                $product_id = egens_core()->egns_post_meta_box_value(get_the_ID(), EGNS_TOUR_META_ID, 'tour_product');
                                                $show_offer = false;
                                                $get_booking_form_type = egens_core()->egns_post_meta_box_value(get_the_ID(),EGNS_TOUR_META_ID, 'tour_booking_options');
                                                $price_html = '';
                                                if( $get_booking_form_type != 'enquiry_form' ) {
                                                    if( !empty( $product_id ) ) {
                                                        $product = wc_get_product( $product_id );
                                                        if ( egens_core()->egns_check_sale_price_schedule($product->get_id() ) ) {
                                                            $price_html = '<span>'.'From '.get_woocommerce_currency_symbol().egens_core()->egns_calculate_product_price($product->get_id()).'</span>/' . ' <del>' . get_woocommerce_currency_symbol() . $product->get_regular_price() .  '</del>';
                                                        } else {
                                                            $price_html = '<span>'.'From '. get_woocommerce_currency_symbol() .egens_core()->egns_calculate_product_price($product->get_id()).'</span>';
                                                        }
                                                    }
                                                }else{
                                                    if( !empty( egens_core()->egns_post_meta_box_value( get_the_ID(),EGNS_TOUR_META_ID, 'sale_price' ) ) ) {
                                                        $price_html = '<span>'.'From '.egens_core()->egns_calculate_product_price().'</span>/' . ' <del>' . egens_core()->egns_post_meta_box_value(get_the_ID(), EGNS_TOUR_META_ID, 'regular_price' ) .  '</del>';
                                            
                                                    }else{
                                                        $price_html =  egens_core()->egns_calculate_product_price();
                                                    }
                                                }
                                            ?>


                                                <div class="swiper-slide">
                                                    <div class="tour-package-single2">
                                                        <div class="image">
                                                            <?php the_post_thumbnail('egns-img-one', array('class' => 'img-fluid')); ?>
                                                            <?php if( !empty( $price_html ) ) : ?>
                                                                <span class="blog-date"><i class="bi bi-calendar-check"></i><?php echo $price_html ?></span>
                                                            <?php endif ?>
                                                        </div>
                                                        <div class="content">
                                                            <h4><a href="<?php the_permalink() ?>"><?php the_title() ?></a></h4>
                                                            <p><?php echo wp_trim_words(get_the_content(), 10, '...'); ?></p>
                                                            <a href="<?php the_permalink() ?>" class="read-more-btn sibling-2"><?php echo esc_html__('Explorer Now', 'astrip-core') ?><i class="bi bi-arrow-right"></i></a>
                                                        </div>
                                                    </div>
                                                </div>


                                        <?php
                                            }
                                        }
                                        wp_reset_postdata();
                                        ?>



                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endif ?>

        <?php

    }
}

Plugin::instance()->widgets_manager->register(new Astrip_tour_package_Widget());
