<?php

namespace Elementor;

if (!defined('ABSPATH')) exit; // Exit if accessed directly

use Elementor\core\Schemes;

class Astrip_Tour_Package_With_Facilities_Widget extends Widget_Base
{

    public function get_name()
    {
        return 'astrip_package_with_facilities';
    }

    public function get_title()
    {
        return esc_html__('EG Tour Package With Facilities', 'astrip-core');
    }

    public function get_icon()
    {
        return ' eicon-price-table';
    }

    public function get_categories()
    {
        return ['astrip_widgets'];
    }

    protected function register_controls()
    {

        //general section
        $this->start_controls_section(
            'astrip_package_with_facilities_general_section',
            [
                'label' => esc_html__('General', 'astrip-core')
            ]
        );


        $this->add_control(
            'turio_packages',
            [
                'label'             => __('Select Tour', 'turio-core'),
                'type'                 => \Elementor\Controls_Manager::SELECT2,
                'label_block'         => true,
                'multiple'            => true,
                'options'             => egens_core()->get_post_list_by_post_type('astrip-tour'),
                'default'             => egens_core()->get_all_post_key('astrip-tour'),
            ]
        );





        $this->add_control(
            'astrip_package_with_facilities_posts_per_page',
            [
                'label'       => esc_html__('Posts Per Page', 'astrip-core'),
                'type'        => Controls_Manager::NUMBER,
                'default'     => 3,
                'label_block' => false,
            ]
        );
        $this->add_control(
            'astrip_package_with_facilities_template_order_by',
            [
                'label'   => esc_html__('Order By', 'astrip-core'),
                'type'    => Controls_Manager::SELECT,
                'default' => 'ID',
                'options' => [
                    'ID'         => esc_html__('Post Id', 'astrip-core'),
                    'author'     => esc_html__('Post Author', 'astrip-core'),
                    'title'      => esc_html__('Title', 'astrip-core'),
                    'post_date'  => esc_html__('Date', 'astrip-core'),
                    'rand'       => esc_html__('Random', 'astrip-core'),
                    'menu_order' => esc_html__('Menu Order', 'astrip-core'),
                ],
            ]
        );
        $this->add_control(
            'astrip_package_with_facilities_template_order',
            [
                'label'   => esc_html__('Order', 'astrip-core'),
                'type'    => Controls_Manager::SELECT,
                'options' => [
                    'asc'  => esc_html__('Ascending', 'astrip-core'),
                    'desc' => esc_html__('Descending', 'astrip-core')
                ],
                'default' => 'desc',
            ]
        );



        $this->add_control(
            'astrip_package_with_facilities_content_pagination_icon',
            [
                'label' => esc_html__('Pagination Icon', 'astrip-core'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'astrip-core'),
                'label_off' => esc_html__('Hide', 'astrip-core'),
                'return_value' => 'yes',
                'default' => 'yes',

            ]
        );



        $this->end_controls_section();
        //Style Section Start


        $this->start_controls_section(
            'astripi_tour_package_one_style',
            [
                'label' => esc_html__('Image', 'astrip-core'),
                'tab'   => Controls_Manager::TAB_STYLE,

            ]
        );

        $this->add_responsive_control(
            'astripi_tour_package_one_style_height',
            [
                'label'       => esc_html__('Height', 'astrip-core'),
                'type'        => Controls_Manager::TEXT,
                'description' => 'Unit in px',
                'selectors'   => [
                    '{{WRAPPER}} .best-plan-single1 .image img ' => 'height: {{VALUE}}px;',
                ],
            ]
        );
        $this->add_responsive_control(
            'astripi_tour_package_one_style_width',
            [
                'label'       => esc_html__('Width', 'astrip-core'),
                'type'        => Controls_Manager::TEXT,
                'description' => 'Unit in %',
                'selectors'   => [
                    '{{WRAPPER}} .best-plan-single1 .image img ' => 'width: {{VALUE}}%;',
                ],
            ]
        );
        $this->add_responsive_control(
            'astripi_tour_package_one_style_border_radius',
            [
                'label'      => __('Border Radius', 'astrip-core'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .best-plan-single1 .image img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]
        );





        $this->end_controls_section();

        //Price Style Start
        $this->start_controls_section(
            'astrip_package_with_facilities_style_price_section',
            [
                'label' => esc_html__('Price', 'astrip-core'),
                'tab'   => Controls_Manager::TAB_STYLE,


            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'astrip-core'),
                'name'     => 'astrip_package_with_facilities_style_price_typography',
                'selector' =>
                '{{WRAPPER}} .best-plan-single1 .content p',

            ]
        );
        $this->add_control(
            'astrip_package_with_facilities_style_price_color',
            [
                'label'     => esc_html__('Color', 'astrip-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .best-plan-single1 .content p' => 'color: {{VALUE}};',

                ],
            ]
        );



        $this->add_responsive_control(
            'astrip_package_with_facilities_style_price_padding',
            [
                'label'      => __('Padding', 'astrip-core'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .best-plan-single1 .content p' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',

                ],
            ]
        );


        $this->end_controls_section();


        //Title Style Start
        $this->start_controls_section(
            'astrip_package_with_facilities_style_one_title_section',
            [
                'label' => esc_html__('Title', 'astrip-core'),
                'tab'   => Controls_Manager::TAB_STYLE,

            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'astrip-core'),
                'name'     => 'astrip_package_with_facilities_style_one_title_typography',
                'selector' =>
                '{{WRAPPER}} .best-plan-single1 .content h4 a',


            ]
        );
        $this->add_control(
            'astrip_package_with_facilities_style_one_title_color',
            [
                'label'     => esc_html__('Color', 'astrip-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .best-plan-single1 .content h4 a' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'astrip_package_with_facilities_style_one_title_hover_color',
            [
                'label'     => esc_html__('Hover Color', 'astrip-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .best-plan-single1 .content h4:hover a' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'astrip_package_with_facilities_style_one_title_padding',
            [
                'label'      => __('Padding', 'astrip-core'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .deal-single1 .deal-content h4 a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',

                ],
            ]
        );


        $this->end_controls_section();
        //Duration Style Start
        $this->start_controls_section(
            'astrip_package_without_discount_style_duration_section',
            [
                'label' => esc_html__('Duration', 'astrip-core'),
                'tab'   => Controls_Manager::TAB_STYLE,


            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'astrip-core'),
                'name'     => 'astrip_package_without_discount_style_duration_typography',
                'selector' =>
                '{{WRAPPER}} .best-plan-single1 .content .best-plan-meta span.duration',


            ]
        );
        $this->add_control(
            'astrip_package_without_discount_style_duration_color',
            [
                'label'     => esc_html__('Color', 'astrip-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .best-plan-single1 .content .best-plan-meta span.duration' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'astrip_package_without_discount_style_duration_icon_color',
            [
                'label'     => esc_html__('Icon Color', 'astrip-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .best-plan-single1 .content .best-plan-meta span.duration .bi' => 'color: {{VALUE}};',
                ],
            ]
        );


        $this->add_responsive_control(
            'astrip_package_without_discount_style_duration_padding',
            [
                'label'      => __('Padding', 'astrip-core'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .best-plan-single1 .content .best-plan-meta span.duration' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',

                ],
            ]
        );

        $this->end_controls_section();
        //rating Style Start
        $this->start_controls_section(
            'astrip_package_without_discount_style_rating_section',
            [
                'label' => esc_html__('Rating', 'astrip-core'),
                'tab'   => Controls_Manager::TAB_STYLE,


            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'astrip-core'),
                'name'     => 'astrip_package_without_discount_style_rating_typography',
                'selector' =>
                '{{WRAPPER}} .best-plan-single1 .content .best-plan-meta span.rating',


            ]
        );
        $this->add_control(
            'astrip_package_without_discount_style_rating_color',
            [
                'label'     => esc_html__('Color', 'astrip-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .best-plan-single1 .content .best-plan-meta span.rating' => 'color: {{VALUE}};',
                ],
            ]
        );


        $this->add_responsive_control(
            'astrip_package_without_discount_style_rating_padding',
            [
                'label'      => __('Padding', 'astrip-core'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .best-plan-single1 .content .best-plan-meta span.rating' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',

                ],
            ]
        );

        $this->end_controls_section();
        //Review star style
        $this->start_controls_section(
            'astrip_package_with_facilities_style_review_star_section',
            [
                'label' => esc_html__('Star Icon', 'astrip-core'),
                'tab'   => Controls_Manager::TAB_STYLE,


            ]
        );

        $this->add_control(
            'astrip_package_with_facilities_style_review_star_color',
            [
                'label'     => esc_html__('Color', 'astrip-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .best-plan-single1 .content .best-plan-meta span.rating .bi' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();

        //facilities title Style Start
        $this->start_controls_section(
            'astrip_package_without_discount_style_facilities_title_section',
            [
                'label' => esc_html__('Facilities Title', 'astrip-core'),
                'tab'   => Controls_Manager::TAB_STYLE,


            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'astrip-core'),
                'name'     => 'astrip_package_without_discount_style_facilities_title_typography',
                'selector' =>
                '{{WRAPPER}} .list-area h5',


            ]
        );
        $this->add_control(
            'astrip_package_without_discount_style_facilities_title_color',
            [
                'label'     => esc_html__('Color', 'astrip-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .list-area h5' => 'color: {{VALUE}};',
                ],
            ]
        );


        $this->add_responsive_control(
            'astrip_package_without_discount_style_facilities_title_padding',
            [
                'label'      => __('Padding', 'astrip-core'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .list-area h5' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',

                ],
            ]
        );

        $this->end_controls_section();
        //facilities Style Start
        $this->start_controls_section(
            'astrip_package_without_discount_style_facilities_section',
            [
                'label' => esc_html__('Facilities Items', 'astrip-core'),
                'tab'   => Controls_Manager::TAB_STYLE,


            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'astrip-core'),
                'name'     => 'astrip_package_without_discount_style_facilities_typography',
                'selector' =>
                '{{WRAPPER}} .list-area ul.plan-list1 li',


            ]
        );
        $this->add_control(
            'astrip_package_without_discount_style_facilities_color',
            [
                'label'     => esc_html__('Color', 'astrip-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .list-area ul.plan-list1 li' => 'color: {{VALUE}};',
                ],
            ]
        );


        $this->add_responsive_control(
            'astrip_package_without_discount_style_facilities_padding',
            [
                'label'      => __('Padding', 'astrip-core'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .list-area ul.plan-list1 li' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',

                ],
            ]
        );

        $this->end_controls_section();

        //Explore Button Style Start
        $this->start_controls_section(
            'astrip_package_with_facilities_style_one_reading_btn_section',
            [
                'label' => esc_html__('Button', 'astrip-core'),
                'tab'   => Controls_Manager::TAB_STYLE,

            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'astrip-core'),
                'name'     => 'astrip_package_with_facilities_style_one_reading_btn_typography',
                'selector' => '{{WRAPPER}} .btn--md',

            ]
        );
        $this->add_control(
            'astrip_package_with_facilities_style_one_reading_btn_color',
            [
                'label'     => esc_html__('Color', 'astrip-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .btn--primary-outline' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'astrip_package_with_facilities_style_one_reading_btn_hover_color',
            [
                'label'     => esc_html__('Hover Color', 'astrip-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .btn--primary-outline:hover' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'astrip_package_with_facilities_style_one_reading_btn_background_color',
            [
                'label'     => esc_html__('Background Color', 'astrip-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .btn--primary-outline' => 'background: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'astrip_package_with_facilities_style_one_reading_btn_background_hover_color',
            [
                'label'     => esc_html__('Hover Background Color', 'astrip-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .btn--primary-outline:hover::after' => 'background: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'astrip_package_with_facilities_style_one_reading_btn_border_color',
            [
                'label'     => esc_html__('Border Color', 'astrip-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .btn--primary-outline' => 'border:2px solid {{VALUE}}',
                ],
            ]
        );




        $this->add_responsive_control(
            'astrip_package_with_facilities_style_one_reading_btn_padding',
            [
                'label'      => __('Padding', 'astrip-core'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .btn--md' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',

                ],
            ]
        );
        $this->add_responsive_control(
            'astrip_package_with_facilities_style_one_reading_btn_margin',
            [
                'label' => esc_html__('Margin', 'astrip-core'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .btn--md' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();


        $this->start_controls_section(
            'astrip_package_with_facilities_style_one_navigation_style',
            [
                'label' => esc_html__('Navigation', 'astrip-core'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'astrip_package_with_facilities_style_one_navigation_style_hover_color',
            [
                'label' => esc_html__('Hover Color', 'astrip-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .arrows-style-1 .swiper-prev-arrow:hover svg' => 'fill: {{VALUE}}',
                    '{{WRAPPER}} .arrows-style-1 .swiper-next-arrow:hover svg' => 'fill: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'astrip_package_with_facilities_style_one_navigation_style_hover_background',
            [
                'label' => esc_html__('Hover Background Color', 'astrip-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .arrows-style-1 .swiper-prev-arrow:hover' => 'background-color: {{VALUE}};border:1px solid {{VALUE}}',
                    '{{WRAPPER}} .arrows-style-1 .swiper-next-arrow:hover' => 'background-color: {{VALUE}};border:1px solid {{VALUE}}',
                ],
            ]
        );





        $this->end_controls_section();
    }
    protected function render()
    {

        $settings = $this->get_settings_for_display();
        $query = new \WP_Query(
            array(
                'post_type'      => 'astrip-tour',
                'posts_per_page' => $settings['astrip_package_with_facilities_posts_per_page'],
                'orderby'        => $settings['astrip_package_with_facilities_template_order_by'],
                'order'          => $settings['astrip_package_with_facilities_template_order'],
                'post__in'       => $settings['turio_packages'],
                'offset'         => 0,
                'post_status'    => 'publish'
            )
        );
?>
        <?php if (is_admin()) : ?>
            <script>
                // best-plan-slider
                var swiper = new Swiper(".best-plan-slider", {
                    slidesPerView: 1,
                    speed: 1200,
                    spaceBetween: 25,
                    // autoplay: true,
                    loop: true,
                    roundLengths: true,
                    pagination: {
                        el: ".swiper-pagination",
                        clickable: "true",
                    },
                    navigation: {
                        nextEl: ".plan1-prev",
                        prevEl: ".plan1-next",
                    },
                    breakpoints: {
                        280: {
                            slidesPerView: 1,
                            navigation: false,
                        },
                        576: {
                            slidesPerView: 2,
                            navigation: false,
                        },
                        768: {
                            slidesPerView: 2,
                            navigation: false,
                        },
                        992: {
                            slidesPerView: 3,
                        },
                        1200: {
                            slidesPerView: 3,
                        },
                    },
                });
            </script>
        <?php endif ?>

        <div class="best-plan-section overflow-hidden">
            <div class="container">
                <div class="row">
                    <div class="col-12 position-relative">
                        <div class="swiper best-plan-slider position-relative">
                            <div class="swiper-wrapper">


                                <?php
                                if ($query->have_posts()) {
                                    while ($query->have_posts()) {
                                        $query->the_post();
                                        $product_id = egens_core()->egns_post_meta_box_value(get_the_ID(), EGNS_TOUR_META_ID, 'tour_product');
                                        $get_booking_form_type = egens_core()->egns_post_meta_box_value(get_the_ID(),EGNS_TOUR_META_ID, 'tour_booking_options');
                                        $price_html = '';
                                        if( $get_booking_form_type != 'enquiry_form' ) {
                                            if( class_exists('Woocommerce') && !empty( $product_id ) ) {
                                                $product = wc_get_product( $product_id );
                                                if ( egens_core()->egns_check_sale_price_schedule($product->get_id() ) ) {
                                                    $price_html = '<span>'.'From '.get_woocommerce_currency_symbol().egens_core()->egns_calculate_product_price($product->get_id()).'</span>/' . ' <del>' . get_woocommerce_currency_symbol() . $product->get_regular_price() .  '</del>';
                                                } else {
                                                    $price_html = '<span>'.'From '. get_woocommerce_currency_symbol() .egens_core()->egns_calculate_product_price($product->get_id()).'</span>';
                                                }
                                            }
                                        }else{
                                            if( !empty( egens_core()->egns_post_meta_box_value( get_the_ID(),EGNS_TOUR_META_ID, 'sale_price' ) ) ) {
                                                $price_html = '<span>'.'From '.egens_core()->egns_calculate_product_price().'</span>/' . ' <del>' . egens_core()->egns_post_meta_box_value(get_the_ID(), EGNS_TOUR_META_ID, 'regular_price' ) .  '</del>';
                                    
                                            }else{
                                                $price_html =  egens_core()->egns_calculate_product_price();
                                            }
                                        }
                                        
                                        $duration = egens_core()->egns_post_meta_box_value(get_the_ID(), EGNS_TOUR_META_ID, 'tour_duration');
                                        $fac_title = egens_core()->egns_post_meta_box_value(get_the_ID(), EGNS_TOUR_META_ID, 'included_title');
                                        $fac_content = egens_core()->egns_post_meta_box_value(get_the_ID(), EGNS_TOUR_META_ID, 'included_content');

                                ?>



                                        <div class="swiper-slide">
                                            <div class="best-plan-single1">
                                                <div class="image">
                                                    <?php the_post_thumbnail('egns-img-one', array('class' => 'img-fluid')); ?>
                                                </div>
                                                <div class="content">
                                                    <?php if (!empty($product_id)) : ?>
                                                        <p> <?php echo wp_kses($price_html, wp_kses_allowed_html('post'))  ?></p>
                                                    <?php endif ?>
                                                    <h4><a href="<?php esc_url(the_permalink()) ?>"><?php the_title() ?></a></h4>
                                                    <div class="best-plan-meta">
                                                        <?php if (!empty($duration)) : ?>
                                                            <span class="duration"><i class="bi bi-clock"></i><?php echo esc_html($duration) ?></span>
                                                        <?php endif ?>
                                                        <?php if (!empty($product_id)) : ?>
                                                            <span class="rating">
                                                                <?php if (egens_core()->egns_core_get_avg_rating_by_tour_id(get_the_ID()) > 0) : ?>
                                                                    <ul class="star-list">
                                                                        <?php
                                                                        for ($x = 1; $x <= 5; $x++) {
                                                                            if (egens_core()->egns_core_get_avg_rating_by_tour_id(get_the_ID()) >= $x) {
                                                                                echo wp_kses_post('<li><i class="bi bi-star-fill"></i></li>');
                                                                            } else {
                                                                                echo wp_kses_post('<li><i class="bi bi-star"></i></li>');
                                                                            }
                                                                        }
                                                                        ?>
                                                                    </ul>
                                                                <?php endif ?>
                                                                <?php if (egens_core()->egns_core_get_all_rating_count_by_tour_id(get_the_ID()) > 0) : ?>
                                                                    <?php echo esc_html(egens_core()->egns_core_get_avg_rating_by_tour_id(get_the_ID())); ?> (<?php echo esc_html(egens_core()->egns_core_get_all_rating_count_by_tour_id(get_the_ID())) ?>)
                                                                <?php endif ?>
                                                            </span>
                                                        <?php endif ?>
                                                    </div>
                                                    <div class="list-area">
                                                        <?php if( !empty( $fac_title ) ) : ?>
                                                            <h5><?php echo esc_html($fac_title) ?><?php echo esc_html(':') ?></h5>
                                                        <?php endif ?>
                                                        <ul class="plan-list1">
                                                            <?php if (is_array($fac_content)) : ?>
                                                                <?php foreach ($fac_content as $item) : ?>
                                                                    <li><?php echo esc_html($item['included_content_name']) ?></li>
                                                                <?php endforeach; ?>
                                                            <?php endif ?>
                                                        </ul>
                                                    </div>
                                                    <a href="<?php esc_url(the_permalink()) ?>" class="eg-btn btn--primary-outline btn--md"><?php echo esc_html__('Explore Now', 'astrip-core') ?></a>
                                                </div>
                                            </div>
                                        </div>

                                <?php
                                    }
                                }
                                wp_reset_postdata();
                                ?>




                            </div>
                        </div>
                        <?php if ($settings['astrip_package_with_facilities_content_pagination_icon'] == 'yes') : ?>
                            <div class="slider-arrows arrows-style-1 text-center d-xl-flex d-none flex-row justify-content-between align-items-center w-100">
                                <div class="plan1-prev swiper-prev-arrow" tabindex="0" role="button" aria-label="Previous slide">
                                    <svg width="20" height="12" viewBox="0 0 20 12" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M7.00001 10.573V6L7.00001 1.42701C7.00001 1.25744 6.80224 1.16481 6.67197 1.27336L1 6L6.67197 10.7266C6.80224 10.8352 7.00001 10.7426 7.00001 10.573Z" />
                                        <path d="M19 6.5C19.2761 6.5 19.5 6.27614 19.5 6C19.5 5.72386 19.2761 5.5 19 5.5V6.5ZM6.67197 10.7266L6.99206 10.3425V10.3425L6.67197 10.7266ZM1 6L0.679909 5.61589L0.218975 6L0.679909 6.38411L1 6ZM6.67197 1.27336L6.35188 0.889252L6.35188 0.889253L6.67197 1.27336ZM19 5.5L7.00001 5.5V6.5L19 6.5V5.5ZM6.50001 6V10.573H7.50001V6H6.50001ZM6.99206 10.3425L1.32009 5.61589L0.679909 6.38411L6.35188 11.1107L6.99206 10.3425ZM1.32009 6.38411L6.99206 1.65747L6.35188 0.889253L0.679909 5.61589L1.32009 6.38411ZM6.50001 1.42701L6.50001 6H7.50001L7.50001 1.42701H6.50001ZM6.99206 1.65747C6.79667 1.82031 6.50001 1.68136 6.50001 1.42701H7.50001C7.50001 0.833523 6.80781 0.509313 6.35188 0.889252L6.99206 1.65747ZM6.50001 10.573C6.50001 10.3186 6.79667 10.1797 6.99206 10.3425L6.35188 11.1107C6.80781 11.4907 7.50001 11.1665 7.50001 10.573H6.50001Z" />
                                    </svg>
                                </div>
                                <div class="plan1-next swiper-next-arrow" tabindex="0" role="button" aria-label="Next slide">
                                    <svg width="20" height="12" viewBox="0 0 20 12" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M13 1.42701V6V10.573C13 10.7426 13.1978 10.8352 13.328 10.7266L19 6L13.328 1.27336C13.1978 1.16481 13 1.25744 13 1.42701Z" />
                                        <path d="M1 5.5C0.723858 5.5 0.5 5.72386 0.5 6C0.5 6.27614 0.723858 6.5 1 6.5V5.5ZM13.328 1.27336L13.0079 1.65747V1.65747L13.328 1.27336ZM19 6L19.3201 6.38411L19.781 6L19.3201 5.61589L19 6ZM13.328 10.7266L13.6481 11.1107L13.6481 11.1107L13.328 10.7266ZM1 6.5H13V5.5H1V6.5ZM13.5 6V1.42701H12.5V6H13.5ZM13.0079 1.65747L18.6799 6.38411L19.3201 5.61589L13.6481 0.889253L13.0079 1.65747ZM18.6799 5.61589L13.0079 10.3425L13.6481 11.1107L19.3201 6.38411L18.6799 5.61589ZM13.5 10.573V6H12.5V10.573H13.5ZM13.0079 10.3425C13.2033 10.1797 13.5 10.3186 13.5 10.573H12.5C12.5 11.1665 13.1922 11.4907 13.6481 11.1107L13.0079 10.3425ZM13.5 1.42701C13.5 1.68136 13.2033 1.82031 13.0079 1.65747L13.6481 0.889253C13.1922 0.509312 12.5 0.833522 12.5 1.42701H13.5Z" />
                                    </svg>
                                </div>
                            </div>
                        <?php endif ?>
                    </div>
                </div>
            </div>
        </div>

<?php

    }
}

Plugin::instance()->widgets_manager->register(new Astrip_Tour_Package_With_Facilities_Widget());
