<?php

namespace Elementor;

if (!defined('ABSPATH')) {
    exit;
} //Exit if accessed directly

use Elementor\Core\Schemes;

class astrip_newsletter_Widget extends Widget_Base
{

    public function get_name()
    {
        return 'egens_newsletter';
    }

    public function get_title()
    {
        return esc_html__('EG Newsletter', 'astrip-core');
    }

    public function get_icon()
    {
        return 'eicon-menu-toggle';
    }

    public function get_categories()
    {
        return ['astrip_widgets'];
    }

    protected function register_controls()
    {

        //-------------Content-------------------//
        //stats Section

        $this->start_controls_section(
            'astrip_section_content_general',
            [
                'label' => esc_html__('General', 'astrip-core')
                
            ]
        );


        $this->add_control(
            'astrip_newsletter_title',
            [
                'label' => esc_html__( 'Title', 'astrip-core' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__( 'Join Newsletter', 'astrip-core' ),
                'label_block' => true,
            ]
        );

        $this->add_control(
			'astrip_newsletter_description',
			[
				'label' => esc_html__( 'Description', 'astrip-core' ),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'rows' => 10,
				'default' => esc_html__( 'Etiam rhoncus. Maecenas temp us, tellus eget condimentum rho', 'astrip-core' ),
				'placeholder' => esc_html__( 'Type your description here', 'astrip-core' ),
			]
		);

        $this->add_control(
            'astrip_newsletter_short_code',
            [
                'label' => esc_html__( 'Form Short Code', 'astrip-core' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__( '[mc4wp_form id="43"]', 'astrip-core' ),
                'label_block' => true,
            ]
        );

       

        
        
        $this->end_controls_section();
     
        //---------------Style----------------------//


        //newsletter Title Style
        $this->start_controls_section(
            'astrip_newsletter_title_style_section',
            [
                'label' => esc_html__('Title', 'astrip-core'),
                'tab'   => Controls_Manager::TAB_STYLE,
                
                
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'astrip-core'),
                'name'     => 'astrip_newsletter_title_style_typography',
                'selector' => 
                    '{{WRAPPER}} .banner-form-box h3',
                
                

            ]
        );

        $this->add_control(
            'astrip_newsletter_title_style_color',
            [
                'label'     => esc_html__('Color', 'astrip-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .banner-form-box h3' => 'color: {{VALUE}};',

                ],
            ]
        );
       
        
        $this->add_responsive_control(
            'astrip_newsletter_title_style_margin',
            [
                'label' => esc_html__( 'Margin', 'astrip-core' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .banner-form-box h3' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        //newsletter description Style
        $this->start_controls_section(
            'astrip_newsletter_description_style_section',
            [
                'label' => esc_html__('Description', 'astrip-core'),
                'tab'   => Controls_Manager::TAB_STYLE,
                
                
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'astrip-core'),
                'name'     => 'astrip_newsletter_description_style_typography',
                'selector' => 
                    '{{WRAPPER}} .banner-form-box p',
                
                

            ]
        );

        $this->add_control(
            'astrip_newsletter_description_style_color',
            [
                'label'     => esc_html__('Color', 'astrip-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .banner-form-box p' => 'color: {{VALUE}};',

                ],
            ]
        );
       
        
        $this->add_responsive_control(
            'astrip_newsletter_description_style_margin',
            [
                'label' => esc_html__( 'Margin', 'astrip-core' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .banner-form-box p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();
        //newsletter box style
        $this->start_controls_section(
            'astrip_newsletter_box_style_section',
            [
                'label' => esc_html__('Newsletter Box', 'astrip-core'),
                'tab'   => Controls_Manager::TAB_STYLE,
                
                
            ]
        );
        $this->add_responsive_control(
            'astrip_newsletter_box_style_padding',
            [
                'label'      => __('Padding', 'astrip-core'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .newsletter-area' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',   
                    
                ],
            ]
        );
        $this->add_responsive_control(
            'astrip_newsletter_box_style_margin',
            [
                'label' => esc_html__( 'Margin', 'astrip-core' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .newsletter-area' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();
        
       
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
    ?> 
    

        <div class="newsletter-area">
            <div class="banner-form-box" >
                <?php if( !empty( $settings['astrip_newsletter_title'] ) ) : ?>
                    <h3><?php echo esc_html($settings['astrip_newsletter_title']) ?></h3>
                <?php endif ?>
                <?php if( !empty( $settings['astrip_newsletter_description'] ) ) : ?>
                    <p><?php echo wp_kses($settings['astrip_newsletter_description'],wp_kses_allowed_html('post')) ?></p>
                <?php endif ?>
                <?php if( !empty( $settings['astrip_newsletter_short_code'] ) ) : ?>
                    <form class="newsletter-form">
                        <?php echo do_shortcode($settings['astrip_newsletter_short_code']) ?>
                    </form>
                <?php endif ?>
            </div>
        </div>

    <?php
    }
}

Plugin::instance()->widgets_manager->register(new astrip_newsletter_Widget());


