<?php

namespace Elementor;

if (!defined('ABSPATH')) exit; // Exit if accessed directly

use Elementor\core\Schemes;

class Astrip_Info_Box_Widget extends Widget_Base
{

    public function get_name()
    {
        return 'astrip_info_box';
    }

    public function get_title()
    {
        return esc_html__('EG Info Box', 'astrip-core');
    }

    public function get_icon()
    {
        return 'eicon-info';
    }

    public function get_categories()
    {
        return ['astrip_widgets'];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'astrip_info_box_content_general_section',
            [
                'label' => esc_html__('General', 'astrip-core')

            ]
        );


        $this->add_control(
            'astrip_info_box_column_selection',
            [
                'label'   => esc_html__('Column', 'astrip-core'),
                'type'    => Controls_Manager::SELECT,
                'options' => [
                    'column_two'  => esc_html__('2', 'astrip-core'),
                    'column_three' => esc_html__('3', 'astrip-core'),
                    'column_four' => esc_html__('4', 'astrip-core'),
                    'column_six' => esc_html__('6', 'astrip-core'),
                ],
                'default' => 'column_six',
            ]
        );

        $this->end_controls_section();
        //Icon Style
        $this->start_controls_section(
            'astrip_info_box_style_icon_section',
            [
                'label' => esc_html__('Icon', 'astrip-core'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'astrip_info_box_style_svg_color',
            [
                'label' => esc_html__('SVG Color', 'astrip-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .category-single1 .icon svg path' => 'fill: {{VALUE}}',
                ],
            ]
        );

        $this->add_responsive_control(
            'astrip_info_box_style_svg_size',
            [
                'label' => esc_html__('SVG Size', 'astrip-core'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 10,
                        'max' => 100,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',

                ],
                'selectors' => [
                    '{{WRAPPER}} .category-single1 .icon svg' => 'width: {{SIZE}}{{UNIT}};height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );


        $this->add_control(
            'astrip_info_box_style_icon_color',
            [
                'label' => esc_html__('Icon Color', 'astrip-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .category-single1 .icon i' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_responsive_control(
            'astrip_info_box_style_icon_size',
            [
                'label' => esc_html__('Icon Size', 'astrip-core'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 10,
                        'max' => 100,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',

                ],
                'selectors' => [
                    '{{WRAPPER}} .category-single1 .icon i' => 'font-size: {{SIZE}}{{UNIT}}',
                ],
            ]
        );
        $this->add_control(
            'astrip_info_box_style_icon_background',
            [
                'label' => esc_html__('Icon Background', 'astrip-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .category-single1 .icon' => 'background: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'astrip_info_box_style_icon_hover',
            [
                'label' => esc_html__('Icon Hover (Background)', 'astrip-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .category-single1:hover .icon::before' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'astrip_info_box_style_icon_border',
                'label' => esc_html__('Icon Border', 'astrip-core'),
                'selector' => '{{WRAPPER}} .category-single1 .icon',
            ]
        );
        $this->add_responsive_control(
            'astrip_info_box_style_icon_margin',
            [
                'label' => esc_html__('Margin', 'astrip-core'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .category-single1 .icon' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();
        //Text Style Start
        $this->start_controls_section(
            'astrip_info_box_text_section',
            [
                'label' => esc_html__('Text', 'astrip-core'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'astrip_info_box_text_color',
            [
                'label'     => esc_html__('Color', 'astrip-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .category-single1 .content h4 a' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'astrip-core'),
                'name'     => 'astrip_info_box_text_typography',
                'selector' => '{{WRAPPER}} .category-single1 .content h4 a',

            ]
        );
        $this->add_control(
            'astrip_info_box_text_hover_color',
            [
                'label'     => esc_html__('Hover Color', 'astrip-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .category-single1 .content h4:hover a' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'astrip_info_box_text_padding',
            [
                'label'      => __('Padding', 'astrip-core'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .category-single1 .content h4 a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',

                ],
            ]
        );
        $this->add_responsive_control(
            'astrip_info_box_text_margin',
            [
                'label' => esc_html__('Margin', 'astrip-core'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .category-single1 .content h4 a' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();
        //Card Style
        $this->start_controls_section(
            'astrip_info_box_style_card_section',
            [
                'label' => esc_html__('Card', 'astrip-core'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'astrip_info_box_style_card_background_color',
            [
                'label'     => esc_html__('Background Color', 'astrip-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .category-single1' => 'background: {{VALUE}};',

                ],
            ]
        );

        $this->add_responsive_control(
            'astrip_info_box_style_card_border_radius',
            [
                'astrip_team_single_card_border_radius',
                'label'              => __('Border Radius', 'astrip-core'),
                'type'               => Controls_Manager::DIMENSIONS,
                'size_units'         => ['px', '%'],
                'selectors'          => [
                    '{{WRAPPER}} .category-single1' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'astrip_info_box_style_card_box_shadow',
                'label' => esc_html__('Box Shadow', 'astrip-core'),
                'selector' => '{{WRAPPER}} .category-single1',
            ]
        );
    }
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $getTourType = get_terms('astrip-tour-type');
    ?>
        <div class="category-section">
            <div class="row justify-content-center g-xxl-5 g-4">
                <?php foreach ($getTourType  as $tourType) : ?>
                    <?php
                    $tourImg = get_term_meta($tourType->term_id, 'astrip_tour_taxonomy', true);
                    $tour_type_slug = $tourType->slug;

                    ?>
                    <?php if ($settings['astrip_info_box_column_selection'] == 'column_two') : ?>
                        <div class="col-xl-6 col-lg-6 col-md-6 col-sm-10">
                    <?php elseif ($settings['astrip_info_box_column_selection'] == 'column_three') : ?>
                        <div class="col-xl-4 col-lg-4 col-md-6 col-sm-10">
                    <?php elseif ($settings['astrip_info_box_column_selection'] == 'column_four') : ?>
                        <div class="col-xl-3 col-lg-3 col-md-6 col-sm-10">
                    <?php elseif ($settings['astrip_info_box_column_selection'] == 'column_six') : ?>
                        <div class="col-xl-2 col-lg-2 col-md-6 col-sm-10">
                    <?php endif ?>
                        <div class="category-single1">
                            <div class="icon">
                                <?php if (!empty($tourImg['astrip_tour_type_image']['url'])) : ?>
                                    <img alt="<?php echo esc_attr('thumb-image', 'astrip-core') ?>" src="<?php echo esc_url($tourImg['astrip_tour_type_image']['url']); ?>">
                                <?php endif ?>
                            </div>
                            <?php if (!empty($tourType->name)) : ?>
                                <div class="content">
                                    <h4>
                                        <a href="<?php echo esc_url(get_term_link($tour_type_slug,'astrip-tour-type')) ?>">
                                            <?php echo esc_html($tourType->name) ?>
                                        </a>
                                    </h4>
                                </div>
                            <?php endif ?>
                        </div>
                    </div>
                <?php endforeach ?>
            </div>
        </div>


    <?php

    }
}

Plugin::instance()->widgets_manager->register(new Astrip_Info_Box_Widget());
