<?php

namespace Elementor;

if (!defined('ABSPATH')) exit; // Exit if accessed directly

use Elementor\core\Schemes;

class astrip_image_gallery extends Widget_Base
{

    public function get_name()
    {
        return 'astrip_image_gallery';
    }

    public function get_title()
    {
        return esc_html__('EG Gallery', 'astrip-core');
    }

    public function get_icon()
    {
        return 'eicon-gallery-masonry';
    }

    public function get_categories()
    {
        return ['astrip_widgets'];
    }

    protected function register_controls()
    {
        // Start  Image Gallery col one  Section
        $this->start_controls_section(
            'astrip_image_gallery_section_col_one',
            [
                'label' => esc_html__('Image Column One', 'astrip-core'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

        $repeater4 = new \Elementor\Repeater();

        $repeater4->add_control(
            'astrip_image_col_one_image',
            [
                'label' => esc_html__( 'Image', 'astrip-core' ),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $this->add_control(
            'astrip_image_section_col_one_list',
            [
                'label' => esc_html__( 'Image List', 'astrip-core' ),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater4->get_controls(),
                'default' => [
                    [
                        'astrip_image_col_one_image' => esc_html__( 'Image One', 'astrip-core' ),
                    ],

                ],
                'title_field' => '{{{ astrip_image_col_one_image }}}',
            ]
        );

        $this->end_controls_section();

        // Start  Image Gallery col two  Section
        $this->start_controls_section(
            'astrip_image_gallery_section_col_two',
            [
                'label' => esc_html__('Image Column Two', 'astrip-core'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

        $repeater5 = new \Elementor\Repeater();

        $repeater5->add_control(
            'astrip_image_col_two_image',
            [
                'label' => esc_html__( 'Image', 'astrip-core' ),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $this->add_control(
            'astrip_image_section_col_two_list',
            [
                'label' => esc_html__( 'Image List', 'astrip-core' ),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater5->get_controls(),
                'default' => [
                    [
                        'astrip_image_col_two_image' => esc_html__( 'Image Two', 'astrip-core' ),
                    ],

                ],
                'title_field' => '{{{ astrip_image_col_two_image }}}',
            ]
        );


        $this->end_controls_section();

        // Start  Image Gallery col three  Section
        $this->start_controls_section(
            'astrip_image_gallery_section_col_three',
            [
                'label' => esc_html__('Image Column Three', 'astrip-core'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

        $repeater6 = new \Elementor\Repeater();

        $repeater6->add_control(
            'astrip_image_col_three_image',
            [
                'label' => esc_html__( 'Image', 'astrip-core' ),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $this->add_control(
            'astrip_image_section_col_three_list',
            [
                'label' => esc_html__( 'Image List', 'astrip-core' ),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater6->get_controls(),
                'default' => [
                    [
                        'astrip_image_col_three_image' => esc_html__( 'Image Three', 'astrip-core' ),
                    ],

                ],
                'title_field' => '{{{ astrip_image_col_three_image }}}',
            ]
        );


        $this->end_controls_section();

         // Start video Image Gallery column one Control Section
         $this->start_controls_section(
            'astrip_video_gallery_col_one_section',
            [
                'label' => esc_html__('Video Column One', 'astrip-core'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'astrip_video_col_one_link',
            [
                'label' => esc_html__( 'Video Link', 'astrip-core' ),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => esc_html__( 'https://your-link.com', 'astrip-core' ),
                'options' => [ 'url', 'is_external', 'nofollow' ],
                'default' => [
                    'url' => 'https://www.youtube.com/watch?v=u31qwQUeGuM',
                    'is_external' => true,
                    'nofollow' => true,
                    // 'custom_attributes' => '',
                ],
                'label_block' => true,
            ]
        );

        
        $repeater->add_control(
            'astrip_video_col_one_image',
            [
                'label' => esc_html__( 'Image', 'astrip-core' ),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $this->add_control(
            'astrip_video_section_col_one_list',
            [
                'label' => esc_html__( 'Video List', 'astrip-core' ),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'astrip_video_col_one_link' => esc_html__( 'https://www.youtube.com/watch?v=u31qwQUeGuM', 'astrip-core' ),
                    ],

                ],
                'title_field' => '{{{ astrip_video_col_one_link }}}',
            ]
        );

        $this->end_controls_section();
         // Start video Image Gallery column two Control Section
         $this->start_controls_section(
            'astrip_video_gallery_col_two_section',
            [
                'label' => esc_html__('Video Column Two', 'astrip-core'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

        $repeater2 = new \Elementor\Repeater();

        $repeater2->add_control(
            'astrip_video_col_two_link',
            [
                'label' => esc_html__( 'Video Link', 'astrip-core' ),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => esc_html__( 'https://your-link.com', 'astrip-core' ),
                'options' => [ 'url', 'is_external', 'nofollow' ],
                'default' => [
                    'url' => 'https://www.youtube.com/watch?v=u31qwQUeGuM',
                    'is_external' => true,
                    'nofollow' => true,
                    // 'custom_attributes' => '',
                ],
                'label_block' => true,
            ]
        );

        
        $repeater2->add_control(
            'astrip_video_col_two_image',
            [
                'label' => esc_html__( 'Image', 'astrip-core' ),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $this->add_control(
            'astrip_video_section_col_two_list',
            [
                'label' => esc_html__( 'Video List', 'astrip-core' ),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater2->get_controls(),
                'default' => [
                    [
                        'astrip_video_col_two_link' => esc_html__( 'https://www.youtube.com/watch?v=u31qwQUeGuM', 'astrip-core' ),
                    ],

                ],
                'title_field' => '{{{ astrip_video_col_two_link }}}',
            ]
        );

        $this->end_controls_section();
         // Start video Image Gallery column three Control Section
         $this->start_controls_section(
            'astrip_video_gallery_col_three_section',
            [
                'label' => esc_html__('Video Column Three', 'astrip-core'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

        $repeater3 = new \Elementor\Repeater();

        $repeater3->add_control(
            'astrip_video_col_three_link',
            [
                'label' => esc_html__( 'Video Link', 'astrip-core' ),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => esc_html__( 'https://your-link.com', 'astrip-core' ),
                'options' => [ 'url', 'is_external', 'nofollow' ],
                'default' => [
                    'url' => 'https://www.youtube.com/watch?v=u31qwQUeGuM',
                    'is_external' => true,
                    'nofollow' => true,
                    // 'custom_attributes' => '',
                ],
                'label_block' => true,
            ]
        );

        
        $repeater3->add_control(
            'astrip_video_col_three_image',
            [
                'label' => esc_html__( 'Image', 'astrip-core' ),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $this->add_control(
            'astrip_video_section_col_three_list',
            [
                'label' => esc_html__( 'Video List', 'astrip-core' ),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater3->get_controls(),
                'default' => [
                    [
                        'astrip_video_col_three_link' => esc_html__( 'https://www.youtube.com/watch?v=u31qwQUeGuM', 'astrip-core' ),
                    ],

                ],
                'title_field' => '{{{ astrip_video_col_three_link }}}',
            ]
        );

        $this->end_controls_section();
       


    }
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $gallery=$settings['astrip_image_section_col_one_list'];
        $gallery2=$settings['astrip_image_section_col_two_list'];
        $gallery3=$settings['astrip_image_section_col_three_list'];
        $data=$settings['astrip_video_section_col_one_list'];
        $data2=$settings['astrip_video_section_col_two_list'];
        $data3=$settings['astrip_video_section_col_three_list'];
?>
        <div class="destination-section">
        <div class="container text-center">
            <div class="nav d-inline-flex flex-row justify-content-center nav-pills" id="v-pills-tab" role="tablist" aria-orientation="vertical">
                <button class="nav-link active nav-btn-style  mb-20" id="v-pills-information-tab" data-bs-toggle="pill" data-bs-target="#v-pills-information" type="button" role="tab" aria-controls="v-pills-information" aria-selected="true"><i class="bi bi-card-image"></i> Image Gallery</button>
                <button class="nav-link nav-btn-style mb-20" id="v-pills-plan-tab" data-bs-toggle="pill" data-bs-target="#v-pills-plan" type="button" role="tab" aria-controls="v-pills-plan" aria-selected="true"><i class="bi bi-play-btn"></i> Video Gallery</button>
            </div>
            
            <div class="tab-content mt-40" id="v-pills-tabContent">
                <div class="tab-pane fade show active" id="v-pills-information" role="tabpanel" aria-labelledby="v-pills-information-tab">
                    <div class="row justify-content-center">
                        <div class="col-lg-4 col-md-4 col-sm-4">
                            <?php foreach($gallery as $image) :?>
                                <div class="image-gallery-single position-relative">
                                    <div class="image-view">
                                    <?php if( !empty( $image['astrip_image_col_one_image']['url'] ) ) : ?>
                                        <a href="<?php echo esc_url($image['astrip_image_col_one_image']['url']) ?>" class="video-icon image-open"><i class="bi bi-binoculars"></i></a>
                                    <?php endif ?>
                                    </div>
                                    <?php if( !empty( $image['astrip_image_col_one_image']['url'] ) ) : ?>
                                        <img src="<?php echo esc_url($image['astrip_image_col_one_image']['url']) ?>" class="img-fluid" alt="<?php echo esc_attr('image') ?>">
                                    <?php endif ?>
                                </div>
                            <?php endforeach ?>
                        </div>
                        <div class="col-lg-4 col-md-4 col-sm-4">
                            <?php foreach($gallery2 as $image2) :?>
                                <div class="image-gallery-single position-relative">
                                    <div class="image-view">
                                    <?php if( !empty( $image2['astrip_image_col_two_image']['url'] ) ) : ?>
                                        <a href="<?php echo esc_url($image2['astrip_image_col_two_image']['url']) ?>" class="video-icon image-open"><i class="bi bi-binoculars"></i></a>
                                    <?php endif ?>
                                    </div>
                                    <?php if( !empty( $image2['astrip_image_col_two_image']['url'] ) ) : ?>
                                        <img src="<?php echo esc_url($image2['astrip_image_col_two_image']['url']) ?>" class="img-fluid" alt="<?php echo esc_attr('image') ?>">
                                    <?php endif ?>
                                </div>
                            <?php endforeach ?>
                        </div>
                        <div class="col-lg-4 col-md-4 col-sm-4">
                            <?php foreach($gallery3 as $image3) :?>
                                <div class="image-gallery-single position-relative">
                                    <div class="image-view">
                                    <?php if( !empty( $image3['astrip_image_col_three_image']['url'] ) ) : ?>
                                        <a href="<?php echo esc_url($image3['astrip_image_col_three_image']['url']) ?>" class="video-icon image-open"><i class="bi bi-binoculars"></i></a>
                                    <?php endif ?>
                                    </div>
                                    <?php if( !empty( $image3['astrip_image_col_three_image']['url'] ) ) : ?>
                                        <img src="<?php echo esc_url($image3['astrip_image_col_three_image']['url']) ?>" class="img-fluid" alt="<?php echo esc_attr('image') ?>">
                                    <?php endif ?>
                                </div>
                            <?php endforeach ?>
                        </div>
                    </div>
                </div>
                <div class="tab-pane fade" id="v-pills-plan" role="tabpanel" aria-labelledby="v-pills-plan-tab">
                    <div class="row justify-content-center g-4">
                        <div class="col-lg-4 col-md-4 col-sm-4">
                            <?php foreach($data as $item): ?>
                                <div class="video-gallery-single position-relative">
                                    <div class="video-play sibling-4">
                                        <?php if( !empty( $item['astrip_video_col_one_link']['url'] ) ) : ?>
                                            <a href="<?php echo esc_url($item['astrip_video_col_one_link']['url']) ?>" class="popup-youtube video-icon"><i class="bx bx-play"></i></a>
                                        <?php endif ?>
                                    </div>
                                    <?php if( !empty( $item['astrip_video_col_one_image']['url'] ) ) : ?>
                                        <img src="<?php echo esc_url($item['astrip_video_col_one_image']['url']) ?>" class="img-fluid" alt="<?php echo esc_attr('video-thumbnail') ?>">
                                    <?php endif ?>
                                </div>
                            <?php endforeach ?>
                            </div>
                            <div class="col-lg-4 col-md-4 col-sm-4">
                            <?php foreach($data2 as $item2): ?>
                                <div class="video-gallery-single position-relative">
                                    <div class="video-play sibling-4">
                                        <?php if( !empty( $item2['astrip_video_col_two_link']['url'] ) ) : ?>
                                            <a href="<?php echo esc_url($item2['astrip_video_col_two_link']['url']) ?>" class="popup-youtube video-icon"><i class="bx bx-play"></i></a>
                                        <?php endif ?>
                                    </div>
                                    <?php if( !empty( $item2['astrip_video_col_two_image']['url'] ) ) : ?>
                                        <img src="<?php echo esc_url($item2['astrip_video_col_two_image']['url']) ?>" class="img-fluid" alt="<?php echo esc_attr('video-thumbnail') ?>">
                                    <?php endif ?>
                                </div>
                            <?php endforeach ?>
                            </div>
                            <div class="col-lg-4 col-md-4 col-sm-4">
                            <?php foreach($data3 as $item3): ?>
                                <div class="video-gallery-single position-relative">
                                    <div class="video-play sibling-4">
                                        <?php if( !empty( $item3['astrip_video_col_three_link']['url'] ) ) : ?>
                                            <a href="<?php echo esc_url($item3['astrip_video_col_three_link']['url']) ?>" class="popup-youtube video-icon"><i class="bx bx-play"></i></a>
                                        <?php endif ?>
                                    </div>
                                    <?php if( !empty( $item3['astrip_video_col_three_image']['url'] ) ) : ?>
                                        <img src="<?php echo esc_url($item3['astrip_video_col_three_image']['url']) ?>" class="img-fluid" alt="<?php echo esc_attr('video-thumbnail') ?>">
                                    <?php endif ?>
                                </div>
                            <?php endforeach ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php

    }
}

Plugin::instance()->widgets_manager->register(new astrip_image_gallery());
