<?php

namespace Elementor;

if (!defined('ABSPATH')) exit; // Exit if accessed directly

use Elementor\core\Schemes;

class Astrip_Facilities_Widget extends Widget_Base
{

    public function get_name()
    {
        return 'astrip_facilities';
    }

    public function get_title()
    {
        return esc_html__('EG Facilities', 'astrip-core');
    }

    public function get_icon()
    {
        return 'eicon-elementor';
    }

    public function get_categories()
    {
        return ['astrip_widgets'];
    }

    protected function register_controls()
    {
        //Content Section Start
        $this->start_controls_section(
            'astrip_facilities_content_general_section',
            [
                'label' => esc_html__('General', 'astrip-core')
            ]
        );
        $this->add_control(
			'astrip_facilities_content_style_selection',
			[
				'label'   => esc_html__('Select Style', 'astrip-core'),
				'type'    => Controls_Manager::SELECT,
				'options' => [
					'style_one'  => esc_html__('Style One', 'astrip-core'),
					'style_two' => esc_html__('Style Two', 'astrip-core'),
				],
				'default' => 'style_one',
			]
		);

        $this->add_control(
			'astrip_facilities_content_style_column_section',
			[
				'label'   => esc_html__('Column', 'astrip-core'),
				'type'    => Controls_Manager::SELECT,
				'options' => [
					'column_two'  => esc_html__('2', 'astrip-core'),
					'column_three' => esc_html__('3', 'astrip-core'),
					'column_four' => esc_html__('4', 'astrip-core'),
				],
				'default' => 'column_three',
			]
		);
        $this->end_controls_section();
        $this->start_controls_section(
            'astrip_facilities_content_section',
            [
                'label' => esc_html__('Facilities List', 'astrip-core')
            ]
        );
        // start repeater
        $repeater = new \Elementor\Repeater();
        // Title Control
        $repeater->add_control(
            'astrip_facilities_content_title',
            [
                'label' => esc_html__( 'Title', 'astrip-core' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__( 'Best Rate Gurantee', 'astrip-core' ),
                'placeholder' => esc_html__( 'Type your title here', 'astrip-core' ),
                'label_block' => true,
            ]
        );

        // Description Control
        $repeater->add_control(
            'astrip_facilities_content_description',
            [
                'label' => esc_html__( 'Description', 'astrip-core' ),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => esc_html__( 'Lorem ipsum dolor sit amet, stsrf consec adi piscing elit', 'astrip-core' ),
                'placeholder' => esc_html__( 'Type your description here', 'astrip-core' ),
                'label_block' => true,
            ]
        );
        $repeater->add_control(
			'astrip_facilities_content_icon',
			[
				'label' => esc_html__( 'Icon', 'astrip-core' ),
				'type' => \Elementor\Controls_Manager::ICONS,
				'default' => [
					'value' => '',
					'library' => '',
				],
			]
		);
        $this->add_control(
			'facilities_repeater_list',
			[
				'label' => esc_html__( 'Facilities List', 'astrip-core' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'default' => [
					[
						'astrip_facilities_content_title' => esc_html__( 'Best Rate Gurantee', 'astrip-core' ),
					],

				],
				'title_field' => '{{{ astrip_facilities_content_title }}}',
			]
		);
        $this->end_controls_section();
        
        // End Content section

        //Style Section Start
        //Title Style Section Start
        $this->start_controls_section(
            'astrip_facilities_style_title_section',
            [
                'label' => esc_html__('Title', 'astrip-core'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'astrip_facilities_style_title_color',
            [
                'label'     => esc_html__('Color', 'astrip-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .facility-single .text h4' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .facility-single2 .facility-content h4' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'astrip_facilities_style_title_hover_color',
            [
                'label'     => esc_html__('Hover Color', 'astrip-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .facility-single2:hover .facility-content h4' => 'color: {{VALUE}};',
                ],
                'condition' => [
                    'astrip_facilities_content_style_selection' => 'style_two',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'astrip-core'),
                'name'     => 'astrip_facilities_style_title_typography',
                'selector' => '{{WRAPPER}} .facility-single .text h4, .facility-single2 .facility-content h4',

            ]
        );
        $this->add_responsive_control(
            'astrip_facilities_style_title_padding',
            [
                'label'      => __('Padding', 'astrip-core'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .facility-single .text h4' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .facility-single2 .facility-content h4' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    
                ],
            ]
        );
        $this->add_responsive_control(
            'astrip_facilities_style_title_margin',
            [
                'label' => esc_html__( 'Margin', 'astrip-core' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .facility-single .text h4' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .facility-single2 .facility-content h4' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();
        //Description Style Start
        $this->start_controls_section(
            'astrip_facilities_style_description_section',
            [
                'label' => esc_html__('Description', 'astrip-core'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ],
            
        );
        $this->add_control(
            'astrip_facilities_style_description_color',
            [
                'label'     => esc_html__('Color', 'astrip-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .facility-single .text p' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .facility-single2 .facility-content p' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'astrip_facilities_style_description_hover_color',
            [
                'label'     => esc_html__('Hover Color', 'astrip-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .facility-single2:hover .facility-content p' => 'color: {{VALUE}};',
                ],
                'condition' => [
                    'astrip_facilities_content_style_selection' => 'style_two',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'astrip-core'),
                'name'     => 'astrip_facilities_style_description_typography',
                'selector' => '{{WRAPPER}} .facility-single .text p, .facility-single2 .facility-content p',

            ]
        );
        $this->add_responsive_control(
            'astrip_facilities_style_description_padding',
            [
                'label'      => __('Padding', 'astrip-core'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .facility-single .text p' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .facility-single2 .facility-content p' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    
                ],
            ]
        );
        $this->add_responsive_control(
            'astrip_facilities_style_description_margin',
            [
                'label' => esc_html__( 'Margin', 'astrip-core' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .facility-single .text p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .facility-single2 .facility-content p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();

        //Icon Style
        $this->start_controls_section(
            'astrip_facilities_style_icon_section',
            [
                'label' => esc_html__('Icon', 'astrip-core'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'astrip_facilities_style_icon_color',
            [
                'label' => esc_html__( 'SVG Color', 'astrip-core' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .facility-single .icon svg path' => 'fill: {{VALUE}}',
                    '{{WRAPPER}} .facility-single2 .facility-icon svg path' => 'fill: {{VALUE}}',
                ],
            ]
        );
        
        $this->add_responsive_control(
            'astrip_facilities_style_svg_size',
            [
                'label' => esc_html__( 'SVG Size', 'astrip-core' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => [ 'px' ],
                'range' => [
                    'px' => [
                        'min' => 10,
                        'max' => 200,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    
                ],
                'selectors' => [
                    '{{WRAPPER}} .facility-single .icon svg' => 'width: {{SIZE}}{{UNIT}};height: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .facility-single2 .facility-icon svg' => 'width: {{SIZE}}{{UNIT}};height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'astrip_facilities_style_icon_colorr',
            [
                'label' => esc_html__( 'Icon Color', 'astrip-core' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .facility-single .icon i' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .facility-single2 .facility-icon i' => 'color: {{VALUE}}',
                ],
            ]
        );
        
        $this->add_responsive_control(
            'astrip_facilities_style_icon_size',
            [
                'label' => esc_html__( 'Icon Size', 'astrip-core' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => [ 'px' ],
                'range' => [
                    'px' => [
                        'min' => 10,
                        'max' => 100,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    
                ],
                'selectors' => [
                    '{{WRAPPER}} .facility-single .icon i' => 'font-size: {{SIZE}}{{UNIT}}',
                    '{{WRAPPER}} .facility-single2 .facility-icon i' => 'font-size: {{SIZE}}{{UNIT}}',
                ],
            ]
        );
        $this->end_controls_section();
        //card style
        $this->start_controls_section(
            'astrip_facilities_single_card_style_one_section',
            [
                'label' => esc_html__( 'Card', 'astrip-core' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                'condition' => [
                    'astrip_facilities_content_style_selection' => 'style_one',
                ],
                
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'astrip_facilities_single_card_style_one_border',
                'label' => esc_html__( 'Border', 'astrip-core' ),
                'selector' => '{{ WRAPPER }} .facility-single',
            ]
        );
        $this->add_control(
            'astrip_facilities_single_card_style_one_background',
            [
                'label'     => esc_html__('Background Color', 'astrip-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .facility-single' => 'background: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'astrip_facilities_single_card_style_one_hover_background',
            [
                'label'     => esc_html__('Hover (Background Color)', 'astrip-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .facility-single:hover' => 'background: {{VALUE}};',
                ],
            ]
        );
        $this->end_controls_section();
        //Style Two
        $this->start_controls_section(
            'astrip_facilities_single_card_style_two_section',
            [
                'label' => esc_html__( 'Card', 'astrip-core' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                'condition' => [
                    'astrip_facilities_content_style_selection' => 'style_two',
                ],
                
            ]
        );
        $this->add_control(
            'astrip_facilities_single_card_style_two_background',
            [
                'label'     => esc_html__('Background Color', 'astrip-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .facility-single2' => 'background: {{VALUE}};',
                ],
            ]
        );
        $this->add_group_control(
			\Elementor\Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'astrip_facilities_single_card_style_two_box_shadow',
				'label' => esc_html__( 'Box Shadow', 'astrip-core' ),
				'selector' => '{{WRAPPER}} .facility-single2',
			]
		);
        $this->add_control(
            'astrip_facilities_single_card_style_two_hover_background',
            [
                'label'     => esc_html__('Hover (Background Color)', 'astrip-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .facility-single2::before' => 'background: {{VALUE}};',
                ],
            ]
        );
        $this->end_controls_section();
        
        
        
    }
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $items = $settings['facilities_repeater_list'];
        ?>
            
            <?php if( !empty( $settings['astrip_facilities_content_style_selection'] ) && ($settings['astrip_facilities_content_style_selection'] == 'style_one') )  : ?> 
                <div class="facilities-section">
                    <div class="row g-4 justify-content-center">
                        <?php foreach ($items as $item): ?>
                            <?php if( $settings['astrip_facilities_content_style_column_section'] == 'column_two' ) : ?>
                                <div class="col-xl-6 col-lg-6 col-md-6 col-sm-10">
                            <?php elseif ($settings['astrip_facilities_content_style_column_section'] == 'column_three') : ?>
                                <div class="col-xl-4 col-lg-4 col-md-6 col-sm-10">
                            <?php elseif ($settings['astrip_facilities_content_style_column_section'] == 'column_four') : ?>
                                <div class="col-xl-3 col-lg-3 col-md-6 col-sm-10">
                            <?php endif ?>
                                <div class="facility-single">
                                    <?php if( !empty( $item['astrip_facilities_content_icon'] ) ) : ?>
                                        <div class="icon">
                                            <?php \Elementor\Icons_Manager::render_icon( $item['astrip_facilities_content_icon'], [ 'aria-hidden' => 'true' ] ); ?>
                                        </div>
                                    <?php endif ?>
                                    <div class="text">
                                        <?php if( !empty( $item['astrip_facilities_content_title'] ) ) : ?>
                                            <h4><?php echo esc_html($item['astrip_facilities_content_title']) ?></h4>
                                        <?php endif ?>
                                        <?php if( !empty( $item['astrip_facilities_content_description'] ) ) : ?>
                                            <p><?php echo esc_html($item['astrip_facilities_content_description']) ?></p>
                                        <?php endif ?>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach ?>
                    </div>
                </div>
            <?php endif ?>
            <?php if( !empty( $settings['astrip_facilities_content_style_selection'] ) && ($settings['astrip_facilities_content_style_selection'] == 'style_two') )  : ?> 
                <div class="facilities-section2">
                    <div class="row justify-content-center g-4">
                        <?php foreach ($items as $item): ?>
                            <?php if( $settings['astrip_facilities_content_style_column_section'] == 'column_two' ) : ?>
                                <div class="col-xl-6 col-lg-6 col-md-6 col-sm-10">
                            <?php elseif ($settings['astrip_facilities_content_style_column_section'] == 'column_three') : ?>
                                <div class="col-xl-4 col-lg-4 col-md-6 col-sm-10">
                            <?php elseif ($settings['astrip_facilities_content_style_column_section'] == 'column_four') : ?>
                                <div class="col-xl-3 col-lg-3 col-md-6 col-sm-10">
                            <?php endif ?>
                                <div class="facility-single2">
                                    <?php if( !empty( $item['astrip_facilities_content_icon'] ) ) : ?>
                                        <div class="facility-icon">
                                            <?php \Elementor\Icons_Manager::render_icon( $item['astrip_facilities_content_icon'], [ 'aria-hidden' => 'true' ] ); ?>
                                        </div>
                                    <?php endif ?>
                                    <div class="facility-content">
                                        <?php if( !empty( $item['astrip_facilities_content_title'] ) ) : ?>
                                            <h4><?php echo esc_html($item['astrip_facilities_content_title']) ?></h4>
                                        <?php endif ?>
                                        <?php if( !empty( $item['astrip_facilities_content_description'] ) ) : ?>
                                            <p><?php echo esc_html($item['astrip_facilities_content_description']) ?></p>
                                        <?php endif ?>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach ?>
                    </div>
                </div>
            <?php endif ?>

        <?php 
        
    }
}

Plugin::instance()->widgets_manager->register(new Astrip_Facilities_Widget());
