<?php

namespace Elementor;

if (!defined('ABSPATH')) {
	exit;
} // Exit if accessed directly

use Elementor\Core\Schemes;

class Astrip_Destination_Masonry_Widget extends Widget_Base
{

	public function get_name()
	{
		return 'astrip_destination_masonry';
	}

	public function get_title()
	{
		return esc_html__('EG Destination Masonry ', 'astrip-core');
	}

	public function get_icon()
	{
		return 'eicon-image-rollover';
	}

	public function get_categories()
	{
		return ['astrip_widgets'];
	}

	protected function register_controls()
	{

		// Start Destination Masonry Section Control
		$this->start_controls_section(
			'section_destination',
			[
				'label' 		=> esc_html__('Destination', 'astrip-core'),
				'tab'  			=> Controls_Manager::TAB_CONTENT
			]
		);
		$this->add_control(
			'astrip_destination_masonry_content_style_selection',
			[
				'label'     => esc_html__('Select Style', 'astrip-core'),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'default'   => 'style_one',
				'options'   => [
					'style_one'        => esc_html__('Style One', 'astrip-core'),
					'style_two'        => esc_html__('Style Two', 'astrip-core'),
					'style_three'      => esc_html__('Style Three', 'astrip-core'),
				],
			]
		);
		$this->add_control(
			'astrip_package_destination_masonry',
			[
				'label' 		=> __('Destination', 'astrip-core'),
				'type' 			=> \Elementor\Controls_Manager::SELECT2,
				'label_block'	=> true,
				'multiple'      => true,
				'options'       => egens_core()->get_post_list_by_post_type('astrip-destination'),
				'default'       => egens_core()->get_all_post_list_by_post_type('astrip-destination'),
			]
		);
		// Start Destination Masonry Order By
		$this->add_control(
			'astrip_destination_masonry_content_order_by',
			[
				'label'   		=> esc_html__('Order By', 'astrip-core'),
				'type'    		=> Controls_Manager::SELECT,
				'default' 		=> 'term_id',
				'options' 		=> [
					'term_id'   => esc_html__('Term ID', 'astrip-core'),
					'name'    	=> esc_html__('Name', 'astrip-core'),
					'include'  	=> esc_html__('Include', 'astrip-core'),
				],
			]
		);
		// Start Destination Masonry Order
		$this->add_control(
			'astrip_destination_masonry_content_order',
			[
				'label'   		=> esc_html__('Order', 'astrip-core'),
				'type'    		=> Controls_Manager::SELECT,
				'options'		=> [
					'asc'  		=> esc_html__('Ascending', 'astrip-core'),
					'desc' 		=> esc_html__('Descending', 'astrip-core')
				],
				'default' 		=> 'desc',
			]
		);
		// Start Destination Masonry Count
		$this->add_control(
			'astrip_destination_masonry_content_count',
			[
				'label'   		=> esc_html__('Destination Count', 'astrip-core'),
				'type'    		=> Controls_Manager::NUMBER,
				'default' 		=> 6,
			]
		);
		$this->end_controls_section();
		// End Destination Masonry Content Control Section

		// Start Destination Masonry Style
		// Start Destination Masonry Style General Section
		$this->start_controls_section(
			'astrip_destination_masonry_style_general_section',
			[
				'label'  		=> esc_html__('General', 'astrip-core'),
				'tab'    		=> Controls_Manager::TAB_STYLE,

			]
		);
		$this->add_control(
			'astrip_destination_masonry_style_one_badge_color',
			[
				'label'  		=> esc_html__('Badge Color', 'astrip-core'),
				'type'   		=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .tour-badge' => 'background : {{VALUE}}'
				],
				'condition' => [
					'astrip_destination_masonry_content_style_selection' => 'style_one'
				],
			]
		);
		$this->add_control(
			'astrip_destination_masonry_style_one_badge_hover_color',
			[
				'label'  		=> esc_html__('Badge Hover', 'astrip-core'),
				'type'   		=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .tour-card-alpha:hover .tour-badge' => 'background : {{VALUE}}'
				],
				'condition' => [
					'astrip_destination_masonry_content_style_selection' => 'style_one'
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'astrip_blog_style_general_style_four_content_box_shadow',
				'label' => esc_html__('Badge Box Shadow', 'astrip-core'),
				'selector' => '{{WRAPPER}} .tour-badge',
				'condition' => [
					'astrip_destination_masonry_content_style_selection' => 'style_one'
				],
			]
		);
		$this->add_responsive_control(
			'astrip_destination_masonry_style_border_radius',
			[
				'label'      		=> __('Image Card Border Radius', 'astrip-core'),
				'type'       		=> Controls_Manager::DIMENSIONS,
				'size_units' 		=> ['px', '%'],
				'selectors'  		=> [
					'{{WRAPPER}} .btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],

			]

		);
		$this->end_controls_section();

		// Start Destination Masonry Style One 
		// Start Destination Name Style
		$this->start_controls_section(
			'astrip_destination_masonry_style_one_destination_name',
			[
				'label'  		=> esc_html__('Destination Name', 'astrip-core'),
				'tab'    		=> Controls_Manager::TAB_STYLE,
				'condition' => [
					'astrip_destination_masonry_content_style_selection' => 'style_one'
				],
			]
		);
		$this->add_control(
			'astrip_destination_masonry_style_one_destination_color',
			[
				'label'  		=> esc_html__('Color', 'astrip-core'),
				'type'   		=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .tour-badge h5' => 'color : {{VALUE}}'
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label' 		=> esc_html__('Typography', 'astrip-core'),
				'name' 			=> 'astrip_destination_masonry_style_one_destination_typography',
				'selector' 		=> '{{WRAPPER}} .tour-badge h5'
			]
		);

		$this->end_controls_section();

		// Start Destination Place Count Style
		$this->start_controls_section(
			'astrip_destination_masonry_style_one_destination_place_count',
			[
				'label'  		=> esc_html__('Place Count', 'astrip-core'),
				'tab'    		=> Controls_Manager::TAB_STYLE,
				'condition' => [
					'astrip_destination_masonry_content_style_selection' => 'style_one'
				],
			]
		);
		$this->add_control(
			'astrip_destination_masonry_style_one_destination_place_count_color',
			[
				'label'  		=> esc_html__('Color', 'astrip-core'),
				'type'   		=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .tour-badge p' => 'color : {{VALUE}}',
					'{{WRAPPER}} .tour-badge span' => 'background : {{VALUE}}'
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label' 		=> esc_html__('Typography', 'astrip-core'),
				'name' 			=> 'astrip_destination_masonry_style_one_destination_place_count_typography',
				'selector' 		=> '{{WRAPPER}} .tour-badge p'
			]
		);

		$this->end_controls_section();
		// End Destination Masonry Style One
		// Start Destination Masonry Style Two 
		// Start Destination Name Style
		$this->start_controls_section(
			'astrip_destination_masonry_style_two_destination_name',
			[
				'label'  		=> esc_html__('Destination Name', 'astrip-core'),
				'tab'    		=> Controls_Manager::TAB_STYLE,
				'condition' => [
					'astrip_destination_masonry_content_style_selection' => 'style_two'
				],
			]
		);
		$this->add_control(
			'astrip_destination_masonry_style_two_destination_color',
			[
				'label'  		=> esc_html__('Color', 'astrip-core'),
				'type'   		=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .gallery-layout .gallery-wrapper .box .destination-single2 .destination-content h4 a' => 'color : {{VALUE}}'
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label' 		=> esc_html__('Typography', 'astrip-core'),
				'name' 			=> 'astrip_destination_masonry_style_two_destination_typography',
				'selector' 		=> '{{WRAPPER}} .gallery-layout .gallery-wrapper .box .destination-single2 .destination-content h4 a'
			]
		);

		$this->end_controls_section();

		// Start Destination Place Count Style
		$this->start_controls_section(
			'astrip_destination_masonry_style_two_destination_place_count',
			[
				'label'  		=> esc_html__('Place Count', 'astrip-core'),
				'tab'    		=> Controls_Manager::TAB_STYLE,
				'condition' => [
					'astrip_destination_masonry_content_style_selection' => 'style_two'
				],
			]
		);
		$this->add_control(
			'astrip_destination_masonry_style_two_destination_place_count_color',
			[
				'label'  		=> esc_html__('Color', 'astrip-core'),
				'type'   		=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .gallery-layout .gallery-wrapper .box .destination-single2 .destination-content p' => 'color : {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label' 		=> esc_html__('Typography', 'astrip-core'),
				'name' 			=> 'astrip_destination_masonry_style_two_destination_place_count_typography',
				'selector' 		=> '{{WRAPPER}} .gallery-layout .gallery-wrapper .box .destination-single2 .destination-content p'
			]
		);

		$this->end_controls_section();
		// End Destination Masonry Style Two
		// Start Destination Masonry Style Three 
		// Start Destination Name Style
		$this->start_controls_section(
			'astrip_destination_masonry_style_three_destination_name',
			[
				'label'  		=> esc_html__('Destination Name', 'astrip-core'),
				'tab'    		=> Controls_Manager::TAB_STYLE,
				'condition' => [
					'astrip_destination_masonry_content_style_selection' => 'style_three'
				],
			]
		);
		$this->add_control(
			'astrip_destination_masonry_style_three_destination_color',
			[
				'label'  		=> esc_html__('Color', 'astrip-core'),
				'type'   		=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .destination-single4 .desti-content h4 a' => 'color : {{VALUE}}'
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label' 		=> esc_html__('Typography', 'astrip-core'),
				'name' 			=> 'astrip_destination_masonry_style_three_destination_typography',
				'selector' 		=> '{{WRAPPER}} .destination-single4 .desti-content h4 a'
			]
		);

		$this->end_controls_section();

		// Start Destination Place Count Style
		$this->start_controls_section(
			'astrip_destination_masonry_style_three_destination_place_count',
			[
				'label'  		=> esc_html__('Place Count', 'astrip-core'),
				'tab'    		=> Controls_Manager::TAB_STYLE,
				'condition' => [
					'astrip_destination_masonry_content_style_selection' => 'style_three'
				],
			]
		);
		$this->add_control(
			'astrip_destination_masonry_style_three_destination_place_count_color',
			[
				'label'  		=> esc_html__('Color', 'astrip-core'),
				'type'   		=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .destination-single4 .desti-content .bx' => 'color : {{VALUE}}',
					'{{WRAPPER}} .destination-single4 .desti-content span' => 'background : {{VALUE}}'
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label' 		=> esc_html__('Typography', 'astrip-core'),
				'name' 			=> 'astrip_destination_masonry_style_three_destination_place_count_typography',
				'selector' 		=> '{{WRAPPER}} .destination-single4 .desti-content span'
			]
		);

		$this->end_controls_section();
		// End Destination Masonry Style Three 
		// End Destination Masonry Style
	}
	protected function render()
	{
		$settings = $this->get_settings_for_display();
		$type = 'astrip-destination';
		$args = array(
			'post_type' 		=> $type,
			'post_status'		=> 'publish',
			'post__in'			=> $settings['astrip_package_destination_masonry'],
			'orderby'    		=> $settings['astrip_destination_masonry_content_order_by'],
			'order'      		=> $settings['astrip_destination_masonry_content_order'],
			'posts_per_page'    => $settings['astrip_destination_masonry_content_count'],
		);
		$my_query = null;
		$my_query = new \WP_Query($args);
?>
		<?php if (!empty($settings['astrip_destination_masonry_content_style_selection']) && ($settings['astrip_destination_masonry_content_style_selection'] == 'style_one')) : ?>
			<div class="tour-place-section">
				<div class="container-fluid">
					<div class="tour-card-wrapper">
						<?php
						if ($my_query->have_posts()) {
							while ($my_query->have_posts()) {
								$my_query->the_post();

								$tourCount = egens_core()->get_tour_count_by_destination_id(get_the_ID());
						?>

								<div class="col-equal">
									<div class="tour-card-alpha">
										<?php if (has_post_thumbnail()) : ?>
											<div class="image">
												<?php the_post_thumbnail('', ['class' => 'img-fluid']); ?>
											</div>
										<?php endif ?>
										<div class="tour-badge ms-md-5 mx-auto">
											<h5><a href="<?php esc_url(the_permalink()) ?>"><?php echo wp_kses(get_the_title(), wp_kses_allowed_html('post')) ?></a></h5>
											<?php if (!empty($tourCount)) : ?>
												<p><?php echo esc_html($tourCount);  ?><?php echo esc_html__(' Tours Place', 'astrip') ?></p>
											<?php endif; ?>
											<span></span>
										</div>
									</div>
								</div>
						<?php
							}
						}
						wp_reset_query();
						?>
					</div>
				</div>
			</div>
		<?php endif ?>
		<?php if (!empty($settings['astrip_destination_masonry_content_style_selection']) && ($settings['astrip_destination_masonry_content_style_selection'] == 'style_two')) : ?>
			<div class="gallery-layout">
				<div class="row">
					<div class="gallery-wrapper">
						<?php
						$i = 0;
						if ($my_query->have_posts()) {
							while ($my_query->have_posts()) {
								$my_query->the_post();
								$i++;

								$tourCount = egens_core()->get_tour_count_by_destination_id(get_the_ID());
						?>
								<div class="col-equal">
									<div class="destination-single2">
										<?php if (has_post_thumbnail()) : ?>
											<?php the_post_thumbnail(); ?>
										<?php endif ?>
										<div class="destination-content">
											<h4><a href="<?php esc_url(the_permalink()) ?>"><?php echo wp_kses(get_the_title(), wp_kses_allowed_html('post')) ?></a></h4>
											<p><?php echo esc_html($tourCount);  ?><?php echo esc_html__(' Tours Place', 'astrip') ?></p>
										</div>
									</div>
								</div>
						<?php
							}
						}
						wp_reset_query();
						?>
					</div>
				</div>
			</div>
		<?php endif ?>
		<?php if (!empty($settings['astrip_destination_masonry_content_style_selection']) && ($settings['astrip_destination_masonry_content_style_selection'] == 'style_three')) : ?>
			<div class="destination-section4 overflow-hidden">
				<div class="row justify-content-center g-4">
					<?php
					$i = 0;
					if ($my_query->have_posts()) {
						while ($my_query->have_posts()) {
							$my_query->the_post();
							$i++;

							$tourCount = egens_core()->get_tour_count_by_destination_id(get_the_ID());
					?>
							<div class="col-lg-4 col-md-6 col-sm-10">
								<div class="destination-single4 ">
									<?php if (has_post_thumbnail()) : ?>
										<?php the_post_thumbnail('', ['class' => 'img-lg-fluid']); ?>
									<?php endif ?>
									<div class="desti-content">
										<h4><a href="<?php esc_url(the_permalink()) ?>"><?php echo wp_kses(get_the_title(), wp_kses_allowed_html('post')) ?></a></h4>
										<?php if (!empty($tourCount)) : ?>
											<span><?php echo esc_html($tourCount);  ?> <?php echo esc_html__(' Tours Place', 'astrip') ?> </span>
										<?php endif; ?>
									</div>
								</div>

							</div>
					<?php
						}
					}
					wp_reset_query();
					?>
				</div>
			</div>
		<?php endif ?>

<?php
	}
}

Plugin::instance()->widgets_manager->register(new Astrip_Destination_Masonry_Widget());
