<?php

namespace Elementor;

if (!defined('ABSPATH')) {
	exit;
} // Exit if accessed directly

use Elementor\Core\Schemes;

class Astrip_Destination_Grid_Widget extends Widget_Base
{

	public function get_name()
	{
		return 'astrip_destination_grid';
	}

	public function get_title()
	{
		return esc_html__('EG Destination Grid ', 'astrip-core');
	}

	public function get_icon()
	{
		return 'eicon-image-rollover';
	}

	public function get_categories()
	{
		return ['astrip_widgets'];
	}

	protected function register_controls()
	{

		// Start Destination Grid Section Control
		$this->start_controls_section(
			'section_destination',
			[
				'label' 		=> esc_html__('Destination', 'astrip-core'),
				'tab'  			=> Controls_Manager::TAB_CONTENT
			]
		);
		// Start Destination Grid Order By
		$this->add_control(
			'astrip_package_destination_grid',
			[
				'label' 		=> __('Destination', 'astrip-core'),
				'type' 			=> \Elementor\Controls_Manager::SELECT2,
				'label_block'	=> true,
				'multiple'      => true,
				'options'       => egens_core()->get_post_list_by_post_type('astrip-destination'),
				'default'       => egens_core()->get_all_post_list_by_post_type('astrip-destination'),
			]
		);
		$this->add_control(
			'astrip_destination_grid_order_by',
			[
				'label'   		=> esc_html__('Order By', 'astrip-core'),
				'type'    		=> Controls_Manager::SELECT,
				'default' 		=> 'term_id',
				'options' 		=> [
					'term_id'   => esc_html__('Term ID', 'astrip-core'),
					'name'    	=> esc_html__('Name', 'astrip-core'),
					'include'  	=> esc_html__('Include', 'astrip-core'),
				],
			]
		);
		// Start Destination Grid Order
		$this->add_control(
			'astrip_destination_grid_order',
			[
				'label'   		=> esc_html__('Order', 'astrip-core'),
				'type'    		=> Controls_Manager::SELECT,
				'options'		=> [
					'asc'  		=> esc_html__('Ascending', 'astrip-core'),
					'desc' 		=> esc_html__('Descending', 'astrip-core')
				],
				'default' 		=> 'desc',
			]
		);
		// Start Destination Grid Count
		$this->add_control(
			'astrip_destination_grid_count',
			[
				'label'   		=> esc_html__('Destination Count', 'astrip-core'),
				'type'    		=> Controls_Manager::NUMBER,
				'default' 		=> 6,
			]
		);
		$this->end_controls_section();
		// End Destination Grid Content Control Section

		// Start Destination Grid Style
		$this->start_controls_section(
			'astrip_destination_grid_style_destination_name',
			[
				'label'  		=> esc_html__('Destination Name', 'astrip-core'),
				'tab'    		=> Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'astrip_destination_grid_style_destination_color',
			[
				'label'  		=> esc_html__('Color', 'astrip-core'),
				'type'   		=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .destination-single1 .content .text-wrap h4' => 'color : {{VALUE}}',
					'{{WRAPPER}} .destination-single1 .content .text-wrap::after' => 'background-color : {{VALUE}}'
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label' 		=> esc_html__('Typography', 'astrip-core'),
				'name' 			=> 'astrip_destination_grid_style_destination_typography',
				'selector' 		=> '{{WRAPPER}} .destination-single1 .content .text-wrap h4'
			]
		);

		$this->end_controls_section();

		// Start Destination Place Style
		$this->start_controls_section(
			'astrip_destination_grid_style_destination_place_count',
			[
				'label'  		=> esc_html__('Place Count', 'astrip-core'),
				'tab'    		=> Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'astrip_destination_grid_style_destination_place_count_color',
			[
				'label'  		=> esc_html__('Color', 'astrip-core'),
				'type'   		=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .destination-single1 .content .text-wrap p' => 'color : {{VALUE}}',
					'{{WRAPPER}} .destination-single1:hover .content .text-wrap::after' => 'background : {{VALUE}}'
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label' 		=> esc_html__('Typography', 'astrip-core'),
				'name' 			=> 'astrip_destination_grid_style_destination_place_count_typography',
				'selector' 		=> '{{WRAPPER}} .destination-single1 .content .text-wrap p'
			]
		);

		$this->end_controls_section();
		// End Destination Grid Style
	}
	protected function render()
	{
		$settings = $this->get_settings_for_display();
		$type = 'astrip-destination';
		$args = array(
			'post_type' 		=> $type,
			'post_status' 		=> 'publish',
			'post__in'			=> $settings['astrip_package_destination_grid'],
			'orderby'    		=> $settings['astrip_destination_grid_order_by'],
			'order'      		=> $settings['astrip_destination_grid_order'],
			'posts_per_page'    => $settings['astrip_destination_grid_count'],
		);
		$my_query = null;
		$my_query = new \WP_Query($args);



?>
		<div class="destination-section">
			<div class="container-fluid">
				<div class="destination-wrap">
					<?php
					$i = 0;
					if ($my_query->have_posts()) {
						while ($my_query->have_posts()) {
							$my_query->the_post();
							$i++;
							
							$tourCount = egens_core()->get_tour_count_by_destination_id( get_the_ID() );


					?>
							<div class="destination-single1 <?php echo ($i == 2) ? 'order-lg-0 order-1' : '';  ?>">
								<?php if(has_post_thumbnail()): ?>
									<?php the_post_thumbnail('', ['class' => 'destination-img img-fluid']); ?>
								<?php endif ?>
								<div class="content">
									<div class="text-wrap">
										<h4><a href="<?php esc_url( the_permalink() ) ?>"><?php echo wp_kses(get_the_title(), wp_kses_allowed_html('post')) ?></a></h4>								
										<p><?php echo esc_html( $tourCount ) ;  ?><?php echo esc_html__(' Tours Place', 'astrip') ?></p>										
									</div>
								</div>
							</div>
					<?php
						}
					}
					wp_reset_query();
					?>
				</div>
			</div>
		</div>

<?php
	}
}

Plugin::instance()->widgets_manager->register(new Astrip_Destination_Grid_Widget());
