<?php

namespace Elementor;

if (!defined('ABSPATH')) exit; // Exit if accessed directly

use Elementor\core\Schemes;

class Astrip_Button_Widget extends Widget_Base
{

    public function get_name()
    {
        return 'astrip_button';
    }

    public function get_title()
    {
        return esc_html__('EG Button', 'astrip-core');
    }

    public function get_icon()
    {
        return 'eicon-button';
    }

    public function get_categories()
    {
        return ['astrip_widgets'];
    }

    protected function register_controls()
    {
        //Content Section Start
        $this->start_controls_section(
            'astrip_button_content_button_section',
            [
                'label' => esc_html__('Button', 'astrip-core')
            ]
        );
        
        $this->add_control(
            'astrip_button_content_button_text',
            [
                'label' => esc_html__('Button Text', 'astrip-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('Click Here', 'astrip-core'),
                'label_block' => true,
          
            ]
        );
        $this->add_control(
			'astrip_button_content_button_url',
			[
				'label' => esc_html__( 'Button URL', 'astrip-core' ),
				'type' => \Elementor\Controls_Manager::URL,
				'placeholder' => esc_html__( 'https://your-link.com', 'astrip-core' ),
				'options' => [ 'url', 'is_external', 'nofollow' ],
				'default' => [
					'url' => '',
					'is_external' => true,
					'nofollow' => true,
					// 'custom_attributes' => '',
				],
				'label_block' => true,
			]
		);
        $this->add_responsive_control(
			'astrip_button_content_button_align',
			[
				'label' 		=> esc_html__( 'Button Align', 'astrip-core' ),
				'type' 			=> \Elementor\Controls_Manager::CHOOSE,
				'options' 		=> [
					'left' 		=> [
						'title' => esc_html__( 'Left', 'astrip-core' ),
						'icon' 	=> 'eicon-text-align-left',
					],
					'center' 	=> [
						'title' => esc_html__( 'Center', 'astrip-core' ),
						'icon' 	=> 'eicon-text-align-center',
					],
					'right' 	=> [
						'title' => esc_html__( 'Right', 'astrip-core' ),
						'icon' 	=> 'eicon-text-align-right',
					],
					'justify' 	=> [
						'title' => esc_html__( 'Justified', 'astrip-core' ),
						'icon' 	=> 'eicon-text-align-justify',
					],
				],
				'default' 		=> 'center',
				'selectors' 	=> [
					'{{WRAPPER}} .btn-align ' => 'text-align: {{VALUE}};',     
				],
			]
		);
        $this->end_controls_section();
        // End Content section

       //Button Style
       $this->start_controls_section(
        'astrip_button_style_section',
        [
            'label' => esc_html__('Button', 'astrip-core'),
            'tab'   => Controls_Manager::TAB_STYLE,
        ]
        );
        $this->start_controls_tabs(
            'style_tabs'
        );

        $this->start_controls_tab(
            'style_normal_tab',
            [
                'label' => esc_html__( 'Normal', 'astrip-core' ),
            ]
        );
        $this->add_control(
            'astrip_button_style_text_color',
            [
                'label'     => esc_html__('Text Color', 'astrip-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .btn--primary-outline' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'astrip-core'),
                'name'     => 'astrip_button_style_typography',
                'selector' => '{{WRAPPER}} .btn--lg ',

            ]
        );
        $this->add_control(
            'astrip_button_style_background',
            [
                'label'     => esc_html__('Background Color', 'astrip-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .btn--primary-outline' => 'background: {{VALUE}};',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'astrip_button_style_border',
                'label' => esc_html__( 'Border', 'astrip-core' ),
                'selector' => '{{WRAPPER}} .btn--primary-outline',
            ]
        );
        $this->add_responsive_control(
            'astrip_button_style_border_radius',
            [
            'astrip_button_style_border_radius',
                'label'      		=> __('Border Radius', 'astrip-core'),
                'type'       		=> Controls_Manager::DIMENSIONS,
                'size_units' 		=> ['px', '%'],
                'selectors'  		=> [
                    '{{WRAPPER}} .btn--primary-outline' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .btn--primary-outline::after' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',

                ],
        
            ]

        );
        $this->add_responsive_control(
            'astrip_button_style_padding',
            [
                'label'      => __('Padding', 'astrip-core'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .btn--lg' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',   
                    
                ],
            ]
        );
        $this->add_responsive_control(
            'astrip_button_style_margin',
            [
                'label' => esc_html__( 'Margin', 'astrip-core' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .btn--lg' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_tab();
        //Hover start

        $this->start_controls_tab(
            'style_hover_tab',
            [
                'label' => esc_html__( 'Hover', 'astrip-core' ),
            ]
        );
        $this->add_control(
            'astrip_button_style_hover_color',
            [
                'label' => esc_html__( 'Text Color', 'astrip-core' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .btn--primary-outline:hover' => 'color: {{VALUE}}',
                ],
        
            ]
        );
        $this->add_control(
            'astrip_button_style_hover_background',
            [
                'label' => esc_html__( 'Background Color', 'astrip-core' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .btn--primary-outline::after' => 'background: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'astrip_button_style_border_hvr',
                'label' => esc_html__( 'Border', 'astrip-core' ),
                'selector' => '{{WRAPPER}} .btn--primary-outline:hover',
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tab();
        $this->end_controls_section();
        
    }
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        if ( ! empty( $settings['astrip_button_content_button_url']['url'] ) ) {
			$this->add_link_attributes( 'astrip_button_content_button_url', $settings['astrip_button_content_button_url'] );
		}
        ?>
            <div class="row justify-content-center">
                <div class="btn-align">
                    <?php if( !empty( $settings['astrip_button_content_button_text']) ) : ?>
                        <a <?php echo $this->get_render_attribute_string( 'astrip_button_content_button_url' ); ?> class="eg-btn btn--primary-outline btn--lg">
                            <?php echo esc_html($settings['astrip_button_content_button_text'],'astrip-core'); ?>
                        </a>
                    <?php endif ?>
                </div>
            </div>

        <?php 
        
    }
}

Plugin::instance()->widgets_manager->register(new Astrip_Button_Widget());




