<?php

namespace Elementor;

if (!defined('ABSPATH')) exit; // Exit if accessed directly

use Elementor\core\Schemes;

class astrip_address_Widget extends Widget_Base
{

    public function get_name()
    {
        return 'astrip_address';
    }

    public function get_title()
    {
        return esc_html__('EG Address', 'astrip-core');
    }

    public function get_icon()
    {
        return 'eicon-map-pin';
    }

    public function get_categories()
    {
        return ['astrip_widgets'];
    }

    protected function register_controls()
    {
        //Content Section
        $this->start_controls_section(
            'astrip_address_content_section',
            [
                'label' => esc_html__('General', 'astrip-core')
            ]
        );

        $this->add_control(
			'astrip_address_content_icon',
			[
				'label' => esc_html__( 'Icon', 'astrip-core' ),
				'type' => \Elementor\Controls_Manager::ICONS,
				'default' => [
					'value' => 'fas fa-circle',
					'library' => 'fa-solid',
				],
			]
		);
        $this->add_control(
            'astrip_address_content_title_text',
            [
                'label' => esc_html__('Address Title', 'astrip-core'),
                'type' => Controls_Manager::TEXT,
                'rows' => 3,
                'default' => esc_html__('Address Text', 'astrip-core'),
                'label_block' => true,

            ]
        );
        $this->add_control(
            'astrip_address_content_location_text',
            [
                'label' => esc_html__('Location Text', 'astrip-core'),
                'type' => Controls_Manager::TEXTAREA,
                'rows' => 3,
                'default' => esc_html__('Address Text', 'astrip-core'),
                'label_block' => true,

            ]
        );
        $this->add_control(
            'astrip_contact_content_number_one_text',
            [
                'label' => esc_html__('Phone One', 'astrip-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('', 'astrip-core'),
                'label_block' => true,

            ]
        );
        $this->add_control(
            'astrip_contact_content_number_two_text',
            [
                'label' => esc_html__('Phone Two', 'astrip-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('', 'astrip-core'),
                'label_block' => true,

            ]
        );
        $this->add_control(
            'astrip_contact_content_email_one_text',
            [
                'label' => esc_html__('Email One', 'astrip-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('', 'astrip-core'),
                'label_block' => true,

            ]
        );
        $this->add_control(
            'astrip_contact_content_email_two_text',
            [
                'label' => esc_html__('Email Two', 'astrip-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('', 'astrip-core'),
                'label_block' => true,

            ]
        );

        $this->end_controls_section();

        
        //Heading Title Style
        $this->start_controls_section(
            'astrip_address_style_heading_title_section',
            [
                'label' => esc_html__('Title', 'astrip-core'),
                'tab'   => Controls_Manager::TAB_STYLE,
                
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'astrip-core'),
                'name'     => 'astrip_address_style_heading_title_typography',
                'selector' => '{{WRAPPER}} .info-single .info-text h3',

            ]
        );
        $this->add_control(
            'astrip_address_style_heading_title_color',
            [
                'label'     => esc_html__('Color', 'astrip-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .info-single .info-text h3' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'astrip_address_style_heading_title_margin',
            [
                'label' => esc_html__( 'Margin', 'astrip-core' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .info-single .info-text h3' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();

        //Heading Description Style
        $this->start_controls_section(
            'astrip_address_style_description_section',
            [
                'label' => esc_html__('Description', 'astrip-core'),
                'tab'   => Controls_Manager::TAB_STYLE,
                
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'astrip-core'),
                'name'     => 'astrip_address_style_description_typography',
                'selector' => '{{WRAPPER}} .info-single .info-text p',

            ]
        );
        $this->add_control(
            'astrip_address_style_description_color',
            [
                'label'     => esc_html__('Color', 'astrip-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .info-single .info-text p' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'astrip_address_style_description_margin',
            [
                'label' => esc_html__( 'Margin', 'astrip-core' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .info-single .info-text p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();

         //Icon Style
        $this->start_controls_section(
            'astrip_address_style_address_list_section',
            [
                'label' => esc_html__('Icon', 'astrip-core'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
       
        $this->add_control(
            'astrip_address_style_address_list_icon_color',
            [
                'label'     => esc_html__('Color Normal', 'astrip-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .info-single .info-icon svg path' => 'fill: {{VALUE}};',
                    '{{WRAPPER}} .info-single .info-icon i' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'astrip_address_style_address_list_icon_hover_color',
            [
                'label'     => esc_html__('Color Hover', 'astrip-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .info-single .info-icon:hover svg  path' => 'fill: {{VALUE}};',
                    '{{WRAPPER}} .info-single .info-icon:hover i' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'astrip_address_style_address_list_icon_background',
            [
                'label'     => esc_html__('Background Normal', 'astrip-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .info-single .info-icon' => 'background: {{VALUE}};',
                ],
            ]
        );
       
        $this->add_control(
            'astrip_address_style_address_list_icon_hover_background',
            [
                'label'     => esc_html__('Background Hover', 'astrip-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .info-single .info-icon::before' => 'background: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'astrip_adress_icon_style_border',
            [
                'label' => esc_html__( 'Border Color', 'astrip-core' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .info-single .info-icon' => 'border:1px solid {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'astrip_address_style_address_list_icon_size',
            [
                'label' => esc_html__( 'Size', 'astrip-core' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => [ 'px','rem' ],
                'range' => [
                    'px' => [
                        'min' => 1,
                        'max' => 100,
                        'step' => 1,
                    ],
                    'rem' => [
                        'min' => 1,
                        'max' => 100,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                ],
                'selectors' => [
                    '{{WRAPPER}} .info-single .info-icon svg' => 'width: {{SIZE}}{{UNIT}};height: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .info-single .info-icon i' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        


        $this->end_controls_section();

        $this->start_controls_section(
            'astrip_address_style_card_section',
            [
                'label' => esc_html__('Card', 'astrip-core'),
                'tab'   => Controls_Manager::TAB_STYLE,
                
            ]
        );

        $this->add_control(
            'astrip_address_style_address_background_color',
            [
                'label'     => esc_html__('Background Color', 'astrip-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .info-single' => 'background: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'astrip_address_style_address_background_hover_color',
            [
                'label'     => esc_html__('Background Hover Color', 'astrip-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .info-single:hover' => 'background: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'astrip_address_style_address_card_border_color',
            [
                'label'     => esc_html__('Border Color', 'astrip-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .info-single' => 'border:1px solid {{VALUE}}',
                ],
            ]
        );

        $this->end_controls_section();

    }
    protected function render()
    {

        $settings = $this->get_settings_for_display();
        ?>
            <div class="justify-content-center">
                <div class="info-single">
                    <?php if( !empty( $settings['astrip_address_content_icon'] ) ) : ?>
                        <div class="info-icon">
                            <?php \Elementor\Icons_Manager::render_icon( $settings['astrip_address_content_icon'], [ 'aria-hidden' => 'true' ] ); ?>
                        </div>
                    <?php endif ?>
                    <div class="info-text">
                        <?php if( !empty( $settings['astrip_address_content_title_text'] ) ) : ?>
                            <h3><?php echo wp_kses($settings['astrip_address_content_title_text'], wp_kses_allowed_html('post')) ?></h3>
                        <?php endif ?>
                        <?php if( !empty( $settings['astrip_address_content_location_text'] ) ) : ?>
                            <p><?php echo wp_kses($settings['astrip_address_content_location_text'], wp_kses_allowed_html('post')) ?></p>
                        <?php endif ?>
                        <?php if (!empty($settings['astrip_contact_content_number_one_text'])): ?>
                            <a href="tel:<?php echo esc_attr__($settings['astrip_contact_content_number_one_text'], 'astrip') ?>"><?php echo wp_kses($settings['astrip_contact_content_number_one_text'], wp_kses_allowed_html('post')) ?></a>
                        <?php endif ?>
                        <?php if (!empty($settings['astrip_contact_content_number_two_text'])): ?>
                            <a href="tel:<?php echo esc_attr__($settings['astrip_contact_content_number_two_text'], 'astrip') ?>"><?php echo wp_kses($settings['astrip_contact_content_number_two_text'], wp_kses_allowed_html('post')) ?></a>
                        <?php endif ?>
                        <?php if (!empty($settings['astrip_contact_content_email_one_text'])): ?>
                            <a href="mailto:<?php echo esc_attr__($settings['astrip_contact_content_email_one_text'], 'astrip') ?>"><?php echo wp_kses($settings['astrip_contact_content_email_one_text'], wp_kses_allowed_html('post')) ?></a>
                        <?php endif ?>
                        <?php if (!empty($settings['astrip_contact_content_email_two_text'])): ?>
                            <a href="mailto:<?php echo esc_attr__($settings['astrip_contact_content_email_two_text'], 'astrip') ?>"><?php echo wp_kses($settings['astrip_contact_content_email_two_text'], wp_kses_allowed_html('post')) ?></a>
                        <?php endif ?>
                    </div>
                </div>
            </div>
        <?php 
        
    }
}

Plugin::instance()->widgets_manager->register(new astrip_address_Widget());