<?php

namespace Elementor;

if (!defined('ABSPATH')) {
    exit;
} //Exit if accessed directly

use Elementor\Core\Schemes;

class astrip_accordion_Widget extends Widget_Base
{

    public function get_name()
    {
        return 'astrip_accordion';
    }

    public function get_title()
    {
        return esc_html__('EG Accordion', 'astrip-core');
    }

    public function get_icon()
    {
        return 'eicon-help';
    }

    public function get_categories()
    {
        return ['astrip_widgets'];
    }

    protected function register_controls()
    {

        //-------------Content-------------------//
        //accordion Section

        $this->start_controls_section(
            'astrip_section_content_accordion',
            [
                'label' => esc_html__('General', 'astrip-core')
            ]
        );

        // Repeater
        $repeater = new \Elementor\Repeater();
        // accordion title
        $repeater->add_control(
            'astrip_section_content_accordion_title', [
                'label' => esc_html__( 'Title', 'astrip-core' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__( 'Vivamus gravida sapien ut gravida volutpat Sed? ' , 'astrip-core' ),
                'label_block' => true,
            ]
        );

        // accordion Control
        $repeater->add_control(
            'astrip_section_content_accordion_description',
            [
                'label' => esc_html__( 'Description', 'astrip-core' ),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'rows' => 15,
                'default' => esc_html__( 'Donec scelerisque ut tellus at congue. Aenean viverra tincidunt velit, nec commodo Donec quis tellus eros. Nunc faucibus leo et pellentesque porta. Integer placerat ur molestie volutpat. Maecenas rutrum urna faucibus auctor hendrerit. Suspendisse si venenatis, venenatis nisi vel, malesuada justo. Vestibulum ultrices diam nibh, sit amlacus ornare a adonil gornara fitana.', 'astrip-core' ),
                'placeholder' => esc_html__( 'Type your description here', 'astrip-core' ),
            ]
        );
        
        $this->add_control(
            'astrip_accordion_section_list',
            [
                'label' => esc_html__( 'Accordion List', 'astrip-core' ),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'astrip_section_content_accordion_title' => esc_html__( 'Vivamus gravida sapien ut gravida volutpat Sed? ', 'astrip-core' ),
                    ],

                ],
                'title_field' => '{{{ astrip_section_content_accordion_title }}}',
            ]
        );
        
        $this->end_controls_section();
     
        //---------------Style----------------------//

        //title style
        $this->start_controls_section(
			'astrip_accordion_title_style_section',
			[
				'label' => esc_html__( 'Title', 'astrip-core' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'astrip_accordion_title_typography',
				'selector' => '{{WRAPPER}} .faq-wrap .accordion-button',
			]
		);

        $this->add_control(
            'astrip_title_text_color',
            [
                'label' => esc_html__('Color', 'astrip-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .faq-wrap .accordion-button' => 'color: {{VALUE}};',
                ],
            ]
        );

        
        $this->add_control(
            'astrip_title_background_color',
            [
                'label' => esc_html__('Background Color', 'astrip-core'),
                'type' => Controls_Manager::COLOR,
                
                'selectors' => [
                    '{{WRAPPER}} .faq-wrap .accordion-button' => 'background: {{VALUE}} !important;',
                ],
            ]
        );

        $this->add_control(
            'astrip_title_text_hover_color',
            [
                'label' => esc_html__('Hover Color', 'astrip-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .faq-wrap .accordion-button:hover' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'astrip_title_background_hover_color',
            [
                'label' => esc_html__('Background Hover Color', 'astrip-core'),
                'type' => Controls_Manager::COLOR,
                
                'selectors' => [
                    '{{WRAPPER}} .faq-wrap .accordion-button:hover' => 'background: {{VALUE}} !important;',
                ],
            ]
        );

        
        $this->end_controls_section();

        //description style

        $this->start_controls_section(
			'astrip_accordion_description_style_section',
			[
				'label' => esc_html__( 'Description', 'astrip-core' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'astrip_accordion_description_typography',
				'selector' => '{{WRAPPER}} p',
			]
		);
        
        $this->add_control(
            'astrip_description_text_color',
            [
                'label' => esc_html__('Color', 'astrip-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} p' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'astrip_description_text_hover_color',
            [
                'label' => esc_html__('Hover Color', 'astrip-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} p:hover' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'astrip_description_background_color',
            [
                'label' => esc_html__('Background Color', 'astrip-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .faq-wrap .accordion-body' => 'background: {{VALUE}};',
                ],
            ]
        );

       
        $this->add_control(
            'astrip_description_background_hover_color',
            [
                'label' => esc_html__('Background Hover Color', 'astrip-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .faq-wrap .accordion-body:hover' => 'background: {{VALUE}};',
                ],
            ]
        );

        


        $this->end_controls_section();

        //icon style

        $this->start_controls_section(
			'astrip_accordion_button_style_section',
			[
				'label' => esc_html__( 'Icon', 'astrip-core' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

        $this->add_control(
            'astrip_accordion_button_color',
            [
                'label' => esc_html__('Color Normal', 'astrip-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .faq-wrap .accordion-button::after' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'astrip_accordion_button_hover_color',
            [
                'label' => esc_html__('Color Hover', 'astrip-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .faq-wrap .accordion-button:hover::after' => 'color: {{VALUE}};',
                ],
            ]
        );

       

        $this->end_controls_section();

                
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $accordionlists = $settings['astrip_accordion_section_list'];
    ?>  

        <div class="faq-wrap">
            <div class="accordion" id="accordionExample">
            	<?php if( !empty( $accordionlists) ) :   ?>
                	<?php foreach ($accordionlists as $key => $item): ?>
		                <div class="accordion-item">
		                    <h2 class="accordion-header" id="heading<?php echo $key ; ?>">
		                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapse<?php echo $key ; ?>" aria-expanded="true" aria-controls="collapse<?php echo $key ; ?>">
		                        <?php echo '0'.$key+1 .'. ' ; ?><?php echo esc_html($item['astrip_section_content_accordion_title']) ?>
		                        </button>
		                    </h2>
		                    <div id="collapse<?php echo $key ; ?>" class="accordion-collapse collapse" aria-labelledby="heading<?php echo $key ; ?>" data-bs-parent="#accordionExample">
		                        <div class="accordion-body">
		                        	<?php if( !empty( $item['astrip_section_content_accordion_description'] ) ) : ?>
		                            	<p><?php echo esc_html($item['astrip_section_content_accordion_description']) ?></p>
		                            <?php endif ?> 
		                        </div>
		                    </div>
		                </div>
	                <?php endforeach; ?>          
	            <?php endif ?>
            </div>
        </div>

    <?php
    }
}

Plugin::instance()->widgets_manager->register(new astrip_accordion_Widget());


        