<?php
/**
 * Content tab "Tour Data"
 */

global $post;
foreach ( TravelPhysTab::$field_arr as $key => $val_default ) {
	${$key} = get_post_meta( $post->ID, '_' . $key, true ) ? get_post_meta( $post->ID, '_' . $key, true ) : $val_default;
}
$location_opt = htmlentities( get_option( 'location_option' ) );

?>

<div id="tour_data_phys" class="panel woocommerce_options_panel">
	<ul class="tabs">
		<li class="tab-link current" data-tab="tab-itinerary"><?php echo esc_html__( 'Itinerary', 'travel-booking' ); ?></li>
		<li class="tab-link" data-tab="tab-location"><?php echo esc_html__( 'Location', 'travel-booking' ); ?></li>
		<?php do_action( 'travel_tour_custom_data_title_tab' ); ?>
	</ul>

	<div id="tab-itinerary" class="tab-content current">
		<?php
		wp_editor( $tour_content_itinerary, 'tour_content_itinerary', array( 'editor_height' => '220px' ) );
		?>
	</div>
	<div id="tab-location" class="tab-content">
		<?php if ( $location_opt == 'google_api' ) { ?>
			<p class="form-field">
				<label><?php echo esc_html__( 'Address', 'travel-booking' ); ?></label>
				<input type="text" value="<?php echo $tour_location_address ?>" name="tour_location_address">
			</p>
			<p class="form-field">
				<label><?php echo esc_html__( 'Latitude', 'travel-booking' ); ?></label>
				<input type="text" value="<?php echo $tour_location_lat ?>" name="tour_location_lat">
			</p>
			<p class="form-field">
				<label><?php echo esc_html__( 'Longitude', 'travel-booking' ); ?></label>
				<input type="text" value="<?php echo $tour_location_long ?>" name="tour_location_long">
			</p>

		<?php } else { ?>
			<p class="form-field">
				<label><?php echo esc_html__( 'Google Map (iframe)', 'travel-booking' ); ?></label>
				<textarea name="google_map_iframe" rows="6" style="height: auto"><?php echo $google_map_iframe ? $google_map_iframe : '' ?></textarea>
			</p>
		<?php } ?>
	</div>
	<?php do_action( 'travel_tour_custom_data_content_tab' ); ?>
</div>