<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Show total item Tours and Product in the Backend
 *
 * @author  physcode
 * @version 1.0.0
 */
class TravelPhysShowTotalItemBackend {
	public function __construct() {
		if ( is_admin() & ! wp_doing_ajax() ) {
			add_filter( 'views_edit-product', array( $this, 'view_edit_product_tour_phys' ), 11, 1 );
		}
	}

	public function view_edit_product_tour_phys( $view ) {
		global $wpdb;

		if ( isset( $_GET['post_type'] ) && $_GET['post_type'] == 'product'
			&& isset( $_GET['product_type'] ) && $_GET['product_type'] == 'tour_phys' ) {

			$queryCountAllToursNotTrash = $wpdb->get_results(
				"SELECT COUNT(DISTINCT ID) as Total FROM $wpdb->posts as post
					LEFT JOIN $wpdb->term_relationships as term_relationships
						ON post.ID = term_relationships.object_id
					LEFT JOIN $wpdb->term_taxonomy as term_taxonomy
						On term_relationships.term_taxonomy_id = term_taxonomy.term_taxonomy_id
					LEFT JOIN $wpdb->terms as terms
						On term_taxonomy.term_id = terms.term_id
					WHERE `post_type` = 'product'
					AND `post_status` != 'trash'
					AND terms.name = 'tour_phys'"
			);

			$queryCountAllToursPublish = $wpdb->get_results(
				"SELECT COUNT(DISTINCT ID) as Total FROM $wpdb->posts as post
					LEFT JOIN $wpdb->term_relationships as term_relationships
						ON post.ID = term_relationships.object_id
					LEFT JOIN $wpdb->term_taxonomy as term_taxonomy
						On term_relationships.term_taxonomy_id = term_taxonomy.term_taxonomy_id
					LEFT JOIN $wpdb->terms as terms
						On term_taxonomy.term_id = terms.term_id
					WHERE `post_type` = 'product'
					AND `post_status` = 'publish'
					AND terms.name = 'tour_phys'"
			);

			$queryCountAllToursTrash = $wpdb->get_results(
				"SELECT COUNT(DISTINCT ID) as Total FROM $wpdb->posts as post
					LEFT JOIN $wpdb->term_relationships as term_relationships
						ON post.ID = term_relationships.object_id
					LEFT JOIN $wpdb->term_taxonomy as term_taxonomy
						On term_relationships.term_taxonomy_id = term_taxonomy.term_taxonomy_id
					LEFT JOIN $wpdb->terms as terms
						On term_taxonomy.term_id = terms.term_id
					WHERE `post_type` = 'product'
					AND `post_status` = 'trash'
					AND terms.name = 'tour_phys'"
			);

			$view['all']     = sprintf( '<a href="edit.php?post_type=product&#038;product_type=tour_phys&#038;all_posts=1">All <span class="count">(%d)</span></a>', $queryCountAllToursNotTrash[0]->Total );
			$view['publish'] = sprintf( '<a href="edit.php?post_status=publish&#038;post_type=product&#038;product_type=tour_phys">Publish <span class="count">(%d)</span></a>', $queryCountAllToursPublish[0]->Total );

			if ( $queryCountAllToursTrash[0]->Total > 0 ) {
				$view['trash'] = sprintf( '<a href="edit.php?post_status=trash&#038;post_type=product&#038;product_type=tour_phys">Trash <span class="count">(%d)</span></a>', $queryCountAllToursTrash[0]->Total );
			} else {
				unset( $view['trash'] );
			}

		} elseif ( isset( $_GET['post_type'] ) && $_GET['post_type'] == 'product' ) {
			$product_type_woo_default = array(
				'simple', 'grouped', 'variable', 'external'
			);

			$product_type_woo_default_str = "'" . implode( "','", $product_type_woo_default ) . "'";

			$queryCountAllToursNotTrash = $wpdb->get_results(
				"SELECT COUNT(DISTINCT post.ID) as Total FROM $wpdb->posts as post
					LEFT JOIN $wpdb->term_relationships as term_relationships
						ON post.ID = term_relationships.object_id
					LEFT JOIN $wpdb->term_taxonomy as term_taxonomy
						On term_relationships.term_taxonomy_id = term_taxonomy.term_taxonomy_id
					LEFT JOIN $wpdb->terms as terms
						On term_taxonomy.term_id = terms.term_id
					WHERE `post_type` = 'product'
					AND `post_status` != 'trash'
					AND terms.name In ($product_type_woo_default_str)"
			);

			$queryCountAllToursPublish = $wpdb->get_results(
				"SELECT COUNT(DISTINCT ID) as Total FROM $wpdb->posts as post
					LEFT JOIN $wpdb->term_relationships as term_relationships
						ON post.ID = term_relationships.object_id
					LEFT JOIN $wpdb->term_taxonomy as term_taxonomy
						On term_relationships.term_taxonomy_id = term_taxonomy.term_taxonomy_id
					LEFT JOIN $wpdb->terms as terms
						On term_taxonomy.term_id = terms.term_id
					WHERE `post_type` = 'product'
					AND `post_status` = 'publish'
					AND terms.name In ($product_type_woo_default_str)"
			);

			$queryCountAllToursTrash = $wpdb->get_results(
				"SELECT COUNT(DISTINCT ID) as Total FROM $wpdb->posts as post
					LEFT JOIN $wpdb->term_relationships as term_relationships
						ON post.ID = term_relationships.object_id
					LEFT JOIN $wpdb->term_taxonomy as term_taxonomy
						On term_relationships.term_taxonomy_id = term_taxonomy.term_taxonomy_id
					LEFT JOIN $wpdb->terms as terms
						On term_taxonomy.term_id = terms.term_id
					WHERE `post_type` = 'product'
					AND `post_status` = 'trash'
					AND terms.name In ($product_type_woo_default_str)"
			);

			$view['all']     = sprintf( '<a href="edit.php?post_type=product&#038;all_posts=1">All <span class="count">(%d)</span></a>', $queryCountAllToursNotTrash[0]->Total );
			$view['publish'] = sprintf( '<a href="edit.php?post_status=publish&#038;post_type=product">Publish <span class="count">(%d)</span></a>', $queryCountAllToursPublish[0]->Total );

			if ( $queryCountAllToursTrash[0]->Total > 0 ) {
				$view['trash'] = sprintf( '<a href="edit.php?post_status=trash&#038;post_type=product">Trash <span class="count">(%d)</span></a>', $queryCountAllToursTrash[0]->Total );
			} else {
				unset( $view['trash'] );
			}
		}

		return $view;
	}
}

new TravelPhysShowTotalItemBackend();