<?php
/**
 * Cart Page
 *
 * @author : Physcode
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

wc_print_notices();

do_action( 'woocommerce_before_cart' ); ?>

<form action="<?php echo esc_url( wc_get_cart_url() ); ?>" method="post">

	<?php do_action( 'woocommerce_before_cart_table' ); ?>

	<table class="shop_table shop_table_responsive cart" cellspacing="0">
		<thead>
		<tr>
			<th class="product-remove">&nbsp;</th>
			<th class="product-thumbnail">&nbsp;</th>
			<th class="product-name"><?php _e( 'Tour', 'travel-booking' ); ?></th>
			<th class="product-price"><?php _e( 'Price', 'travel-booking' ); ?></th>
			<th class="product-quantity"><?php _e( 'Number ticket', 'travel-booking' ); ?></th>
			<th class="product-subtotal"><?php _e( 'Total', 'travel-booking' ); ?></th>
		</tr>
		</thead>
		<tbody>
		<?php do_action( 'woocommerce_before_cart_contents' ); ?>

		<?php
		foreach ( WC()->cart->get_cart() as $cart_item_key => $cart_item ) {
			$_product   = apply_filters( 'woocommerce_cart_item_product', $cart_item['data'], $cart_item, $cart_item_key );
			$product_id = apply_filters( 'woocommerce_cart_item_product_id', $cart_item['product_id'], $cart_item, $cart_item_key );

			if ( $_product && $_product->exists() && $cart_item['quantity'] > 0 && apply_filters( 'woocommerce_cart_item_visible', true, $cart_item, $cart_item_key ) ) {
				$product_permalink = apply_filters( 'woocommerce_cart_item_permalink', $_product->is_visible() ? $_product->get_permalink( $cart_item ) : '', $cart_item, $cart_item_key );
				?>
				<tr class="<?php echo esc_attr( apply_filters( 'woocommerce_cart_item_class', 'cart_item', $cart_item, $cart_item_key ) ); ?>">

					<td class="product-remove">
						<?php
						if ( TravelBookingPhyscode::$_version_woo < 3.3 ) {
							$car_url = WC()->cart->get_remove_url( $cart_item_key );
						} else {
							$car_url = wc_get_cart_remove_url( $cart_item_key );
						}
						echo apply_filters(
							'woocommerce_cart_item_remove_link', sprintf(
							'<a href="%s" class="remove" title="%s" data-product_id="%s" data-product_sku="%s">&times;</a>',
							esc_url( $car_url ),
							__( 'Remove this item', 'travel-booking' ),
							esc_attr( $product_id ),
							esc_attr( $_product->get_sku() )
						), $cart_item_key
						);
						?>
					</td>

					<td class="product-thumbnail">
						<?php
						$thumbnail = apply_filters( 'woocommerce_cart_item_thumbnail', $_product->get_image(), $cart_item, $cart_item_key );

						if ( ! $product_permalink ) {
							echo $thumbnail;
						} else {
							printf( '<a href="%s">%s</a>', esc_url( $product_permalink ), $thumbnail );
						}
						?>
					</td>

					<td class="product-name" data-title="<?php _e( 'Tour', 'travel-booking' ); ?>">
						<?php
						if ( ! $product_permalink ) {
							echo apply_filters( 'woocommerce_cart_item_name', $_product->get_title(), $cart_item, $cart_item_key ) . '&nbsp;';
						} else {
							echo '<div>';
							echo apply_filters( 'woocommerce_cart_item_name', sprintf( '<a href="%s">%s</a>', esc_url( $product_permalink ), $_product->get_title() ), $cart_item, $cart_item_key );
							echo '</div>';
						}

						// Meta data
						if ( TravelBookingPhyscode::$_version_woo < 3.3 ) {
							echo WC()->cart->get_item_data( $cart_item );
						} else {
							echo wc_get_formatted_cart_item_data( $cart_item );
						}

						// Backorder notification
						if ( $_product->backorders_require_notification() && $_product->is_on_backorder( $cart_item['quantity'] ) ) {
							echo '<p class="backorder_notification">' . esc_html__( 'Available on backorder', 'travel-booking' ) . '</p>';
						}
						?>
					</td>

					<td class="product-price" data-title="<?php esc_attr_e( 'Price', 'woocommerce' ); ?>">
						<?php
						echo apply_filters( 'woocommerce_cart_item_price', WC()->cart->get_product_price( $_product ), $cart_item, $cart_item_key );
						?>
					</td>

					<td class="product-quantity" data-title="<?php _e( 'Number ticket', 'travel-booking' ); ?>">
						<?php
						if ( $_product->is_sold_individually() ) {
							$product_quantity = sprintf( '1 <input type="hidden" name="cart[%s][qty]" value="1" />', $cart_item_key );
						} else {
							if ( isset( $cart_item['price_adults'] ) ) {
								echo '<div class="st_adults"><span class="label">' . __( 'Adults', 'travel-booking' ) . '</span><input name="cart[' . $cart_item_key . '][qty]" type="number" value="' . $cart_item['quantity'] . '" min="1" ></div>';
								if ( isset( $cart_item['number_children'] ) ) {
									echo '<div class="st_children"><span class="label">' . __( 'Children', 'travel-booking' ) . '</span><input name="cart[' . $cart_item_key . '][number_children]" type="number" value="' . $cart_item['number_children'] . '" min="0" ></div>';
								}
							} else {
								$product_quantity = woocommerce_quantity_input(
									array(
										'input_name'  => "cart[{$cart_item_key}][qty]",
										'input_value' => $cart_item['quantity'],
										'max_value'   => $_product->backorders_allowed() ? '' : $_product->get_stock_quantity(),
										'min_value'   => '0'
									), $_product, false
								);
								echo apply_filters( 'woocommerce_cart_item_quantity', $product_quantity, $cart_item_key, $cart_item );
							}
						}

						?>
					</td>

					<td class="product-subtotal" data-title="<?php _e( 'Total', 'travel-booking' ); ?>">
						<?php
						echo apply_filters( 'woocommerce_cart_item_subtotal', WC()->cart->get_product_subtotal( $_product, $cart_item['quantity'] ), $cart_item, $cart_item_key );
						?>
					</td>
				</tr>
				<?php
			}
		}

		do_action( 'woocommerce_cart_contents' );
		?>
		<tr>
			<td colspan="6" class="actions">

				<?php if ( wc_coupons_enabled() ) { ?>
					<div class="coupon">

						<label for="coupon_code"><?php _e( 'Coupon:', 'travel-booking' ); ?></label>
						<input type="text"
						       name="coupon_code"
						       class="input-text"
						       id="coupon_code"
						       value=""
						       placeholder="<?php esc_attr_e( 'Coupon code', 'travel-booking' ); ?>" />
						<input type="submit" class="button" name="apply_coupon"
						       value="<?php esc_attr_e( 'Apply Coupon', 'travel-booking' ); ?>" />

						<?php do_action( 'woocommerce_cart_coupon' ); ?>
					</div>
				<?php } ?>

				<input type="submit" class="button" name="update_cart"
				       value="<?php esc_attr_e( 'Update Cart', 'travel-booking' ); ?>" />

				<?php do_action( 'woocommerce_cart_actions' ); ?>

				<?php wp_nonce_field( 'woocommerce-cart' ); ?>
			</td>
		</tr>

		<?php do_action( 'woocommerce_after_cart_contents' ); ?>
		</tbody>
	</table>

	<?php do_action( 'woocommerce_after_cart_table' ); ?>

</form>

<div class="cart-collaterals">

	<?php do_action( 'woocommerce_cart_collaterals' ); ?>

</div>

<?php do_action( 'woocommerce_after_cart' ); ?>
