<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Utility
 *
 * @author  physcode
 * @version 1.0.0
 */
class TravelPhysUtility {

	public static $_date_format_default = 'Y/m/d';
	public static $month_arr = array( 'January', 'February', 'March', 'April', 'May', 'June', 'July', 'August', 'September', 'October', 'November', 'December' );

	public static function init() {
	}


	public static function get_value_group_discount( $tour_id, $total_qty ) {
		$discount = 0;

		try {
			$tour_group_discount_data_obj     = json_decode( get_post_meta( $tour_id, '_tour_group_discount_data', true ) );
			$tour_group_discount_data_arr_tmp = array();

			foreach ( $tour_group_discount_data_obj as $item ) {
				if ( $total_qty >= ( $item->number_customer->value ) ) {
					$tour_group_discount_data_arr_tmp[$item->number_customer->value]                    = array();
					$tour_group_discount_data_arr_tmp[$item->number_customer->value]['number_customer'] = $item->number_customer->value;
					$tour_group_discount_data_arr_tmp[$item->number_customer->value]['discount']        = $item->discount->value;
				}
			};

			if ( count( $tour_group_discount_data_arr_tmp ) > 0 ) {
				arsort( $tour_group_discount_data_arr_tmp );
				//				echo '<pre>' . print_r( $tour_group_discount_data_arr_tmp, true ) . '</pre>';

				//				$discount = reset( $tour_group_discount_data_arr_tmp )['discount'];
			}
		}
		catch ( Exception $exception ) {
			echo $exception;
		}

		//		var_dump($discount);

		return $discount;
	}

	public static function get_type_field( $tour_id, $name_field = '', $field ) {
		$value = get_post_meta( $tour_id, '_' . $name_field, true );

		if ( is_string( $value ) ) {
			$value = htmlentities( $value );
		}
		$label       = isset( $field['label'] ) ? $field['label'] : '';
		$type_field  = isset( $field['type'] ) ? $field['type'] : '';
		$default     = isset( $field['default'] ) ? $field['default'] : '';
		$options     = isset( $field['options'] ) ? $field['options'] : '';
		$id          = isset( $field['id'] ) ? $field['id'] : '';
		$class       = isset( $field['class'] ) ? $field['class'] : '';
		$description = isset( $field['description'] ) ? $field['description'] : '';

		if ( $value == '' ) {
			$value = $default;
		}

		$html_type_field = '';

		switch ( $type_field ) {
			case 'text':
				$html_type_field .= '<p class="form-field">';
				$html_type_field .= '<label>' . __( $label, 'travel-booking' ) . '</label>';
				$html_type_field .= '<input type="text" id="' . $id . '" class="' . $class . '" name="' . $name_field . '" value="' . $value . '">';
				$html_type_field .= '<span class="field-desc"><i>' . $description . '</i></span>';
				$html_type_field .= '</p>';
				break;
			case 'select':
				$html_type_field .= '<p class="form-field">';
				$html_type_field .= '<label>' . __( $label, 'travel-booking' ) . '</label>';
				$html_type_field .= '<select name="' . $name_field . '" id="' . $id . '">';
				foreach ( $options as $option ) {
					$selected = '';
					if ( $option === $value ) {
						$selected = 'selected';
					} else {
						$selected = '';
					}
					$html_type_field .= '<option value="' . $option . '" ' . $selected . '>' . $option . '</option>';
				}
				$html_type_field .= '</select>';
				$html_type_field .= '<span class="field-desc"><i>' . $description . '</i></span>';
				$html_type_field .= '</p>';
				break;
			case 'select_multiple':
				$html_type_field .= '<p class="form-field">';
				$html_type_field .= '<label>' . __( $label, 'travel-booking' ) . '</label>';
				$html_type_field .= '<select id="' . $id . '" class="' . $class . '" name="' . $name_field . '[]" multiple>';
				foreach ( $options as $option ) {
					$selected = '';
					if ( in_array( $option, $value ) ) {
						$selected = 'selected';
					} else {
						$selected = '';
					}
					$html_type_field .= '<option value="' . $option . '" ' . $selected . '>' . $option . '</option>';
				}
				$html_type_field .= '</select>';
				$html_type_field .= '</p>';
				break;
			case 'checkbox':
				foreach ( $options as $option ) {
					$html_type_field .= '<p><input type="checkbox" name="' . $name_field . '[]" value="' . $option . '"><span>' . $option . '</span></p>';
				}
				break;
			case 'radio':
				foreach ( $options as $option ) {
					$html_type_field .= '<p><input type="radio" name="' . $name_field . '" value="' . $option . '"><span>' . $option . '</span></p>';
				}
				break;
			case 'hidden':
				$html_type_field .= '<input type="hidden" id="' . $id . '" class="' . $class . '" name="' . $name_field . '" value="' . $value . '">';
				break;
			default:
				do_action( 'type_field_travel_' . $type_field, $tour_id, $name_field, $field );
				break;
		}

		return $html_type_field;
	}

	public static function get_years_near_now() {
		$years = array();

		$year_now = date( 'Y' );

		array_push( $years, $year_now );

		for ( $i = 1; $i < 5; $i ++ ) {
			$year_next = date( 'Y', strtotime( '+' . $i . ' year' ) );
			array_push( $years, $year_next );
		}

		return $years;
	}

	/**
	 * @param string $date_string
	 *
	 * @return string
	 */
	public static function convert_date_to_format_default( $date_string = '' ) {
		$date_convert   = '';
		$date           = '';
		$month          = '';
		$year           = '';
		$separator_date = '/';

		$date_format_current = get_option( 'date_format_tour', self::$_date_format_default );

		if ( $date_format_current === 'Y/m/d' ) {
			$date_arr = explode( '/', $date_string );

			$date  = $date_arr[2];
			$month = $date_arr[1];
			$year  = $date_arr[0];
		} elseif ( $date_format_current === 'Y-m-d' ) {
			$date_arr = explode( '-', $date_string );

			$date  = $date_arr[2];
			$month = $date_arr[1];
			$year  = $date_arr[0];
		} elseif ( $date_format_current === 'd/m/Y' ) {
			$date_arr = explode( '/', $date_string );

			$date  = $date_arr[0];
			$month = $date_arr[1];
			$year  = $date_arr[2];
		} elseif ( $date_format_current === 'd-m-Y' ) {
			$date_arr = explode( '-', $date_string );

			$date  = $date_arr[0];
			$month = $date_arr[1];
			$year  = $date_arr[2];
		} elseif ( $date_format_current === 'm/d/Y' ) {
			$date_arr = explode( '/', $date_string );

			$date  = $date_arr[1];
			$month = $date_arr[0];
			$year  = $date_arr[2];
		} elseif ( $date_format_current === 'm-d-Y' ) {
			$date_arr = explode( '-', $date_string );

			$date  = $date_arr[1];
			$month = $date_arr[0];
			$year  = $date_arr[2];
		} elseif ( $date_format_current === 'l, d F, Y' ) {
			$date_arr       = explode( ',', $date_string );
			$date_month_arr = explode( ' ', trim( $date_arr[1] ) );

			$date  = $date_month_arr[0];
			$month = array_search( $date_month_arr[1], self::$month_arr );
			$year  = $date_arr[2];
		}

		$date_convert .= $year . $separator_date . $month . $separator_date . $date;

		return $date_convert;
	}

	public static function tour_format_price( $price, $class_for_span_price = '' ) {
		$args = apply_filters(
			'wc_price_args', array(
				'ex_tax_label'       => false,
				'currency'           => '',
				'decimal_separator'  => wc_get_price_decimal_separator(),
				'thousand_separator' => wc_get_price_thousand_separator(),
				'decimals'           => wc_get_price_decimals(),
				'price_format'       => get_woocommerce_price_format(),
			)
		);

		$unformatted_price = $price;
		$negative          = $price < 0;
		$price             = apply_filters( 'raw_woocommerce_price', floatval( $negative ? $price * - 1 : $price ) );
		$price             = apply_filters( 'formatted_woocommerce_price', number_format( $price, $args['decimals'], $args['decimal_separator'], $args['thousand_separator'] ), $price, $args['decimals'], $args['decimal_separator'], $args['thousand_separator'] );

		if ( apply_filters( 'woocommerce_price_trim_zeros', false ) && $args['decimals'] > 0 ) {
			$price = wc_trim_zeros( $price );
		}

		$formatted_price = ( $negative ? '-' : '' ) . sprintf( $args['price_format'],
				'<span class="woocommerce-Price-currencySymbol">' . get_woocommerce_currency_symbol( $args['currency'] ) . '</span>',
				'<span class="' . $class_for_span_price . '">' . $price . '</span>' );
		$return          = '<span class="woocommerce-Price-amount amount">' . $formatted_price . '</span>';

		if ( $args['ex_tax_label'] && wc_tax_enabled() ) {
			$return .= ' <small class="woocommerce-Price-taxLabel tax_label">' . WC()->countries->ex_tax_or_vat() . '</small>';
		}

		/**
		 * Filters the string of price markup.
		 *
		 * @param string $return            Price HTML markup.
		 * @param string $price             Formatted price.
		 * @param array  $args              Pass on the args.
		 * @param float  $unformatted_price Price as float to allow plugins custom formatting.
		 */
		return apply_filters( 'tour_format_price', $return, $price, $args, $unformatted_price );
	}
}

TravelPhysUtility::init();