<?php
/**
 * Travel Template Loader
 *
 * @author  physocde
 * @version 2.0.0
 */

class TravelPhysTemplateLoader {

	public static function init() {
		add_filter( 'woocommerce_locate_template', array( __CLASS__, 'woo_addon_plugin_template' ), 11, 3 );
		add_filter( 'template_include', array( __CLASS__, 'tb_template_loader_phys' ), 11, 1 );
		add_filter( 'woocommerce_cart_item_name', array( __CLASS__, 'html_cart_tour' ), 12, 3 );
		add_filter( 'woocommerce_cart_item_price', array( __CLASS__, 'html_cart_tour_price' ), 12, 3 );
		add_filter( 'woocommerce_cart_item_quantity', array( __CLASS__, 'html_cart_tour_quantity' ), 12, 3 );
		add_filter( 'woocommerce_order_item_name', array( __CLASS__, 'html_order_tour' ), 12, 3 );
	}

	public static function woo_addon_plugin_template( $template, $template_name ) {
		global $woocommerce;
		if ( $template_name == 'cart/cart.php' ) {
			$template = tb_get_file_template( 'cart.php', true, true );
		} elseif ( $template_name == 'checkout/review-order.php' ) {
			$template = tb_get_file_template( 'checkout/review-order.php', true, true );
		} elseif ( $template_name == 'order/order-details.php' ) {
			$template = tb_get_file_template( 'checkout/order-details.php', true, true );
		} elseif ( $template_name == 'order/order-details-item.php' ) {
			$template = tb_get_file_template( 'checkout/order-details-item.php', true, true );
		} elseif ( $template_name == 'emails/email-order-details.php' ) {
			$template = tb_get_file_template( 'emails/email-order-details.php', true, true );
		} elseif ( $template_name == 'emails/email-order-items.php' ) {
			$template = tb_get_file_template( 'emails/email-order-items.php', true, true );
		}

		return $template;
	}

	public static function tb_template_loader_phys( $template ) {
		$arr_find_match = array(
			'single-tour.php',
			'archive-tour.php',
			'archive-attribute.php',
			'archive-attribute-tour.php'
		);
		$find           = array( 'woocommerce.php' );
		$file           = '';

		if ( is_embed() ) {
			return $template;
		}

		if ( is_single() && get_post_type() == 'product' ) {
			if ( wc_get_product()->get_type() == 'tour_phys' ) {
				$file = 'single-tour.php';
			} else {
				$file = 'single-product.php';
			}

			$find[] = $file;
			$find[] = WC()->template_path() . $file;

		} elseif ( is_product_taxonomy() ) {

			$term = get_queried_object();

			if ( is_tax( 'product_cat' ) || is_tax( 'product_tag' ) ) {
				$file = 'taxonomy-' . $term->taxonomy . '.php';
			} else {
				if ( $term->taxonomy == 'tour_phys' ) {
					$file = 'archive-tour.php';
				} else {
					$pattern         = '/^pa_/i';
					$check_attribute = preg_match( $pattern, $term->taxonomy );
					if ( $check_attribute ) {
						$file = 'archive-attribute.php';
					} else {
						$file = 'archive-product.php';
					}
				}
			}

			$find[] = 'taxonomy-' . $term->taxonomy . '-' . $term->slug . '.php';
			$find[] = WC()->template_path() . 'taxonomy-' . $term->taxonomy . '-' . $term->slug . '.php';
			$find[] = 'taxonomy-' . $term->taxonomy . '.php';
			$find[] = WC()->template_path() . 'taxonomy-' . $term->taxonomy . '.php';
			$find[] = $file;
			$find[] = WC()->template_path() . $file;

		} elseif ( is_post_type_archive( 'product' ) || is_page( wc_get_page_id( 'shop' ) ) ) {
			$file   = 'archive-product.php';
			$find[] = $file;
			$find[] = WC()->template_path() . $file;
		}

		if ( $GLOBALS['wp_query']->get( 'is_tour' ) ) {
			$file = 'archive-tour.php';
		}

		if ( $file ) {
			$template = locate_template( array_unique( $find ) );
			if ( in_array( $file, $arr_find_match ) ) {
				if ( $file == 'single-tour.php' ) {
					$GLOBALS['wp_query']->set( 'is-single-tour', true );
				}
				$template = tb_get_file_template( $file );
			} else if ( ! $template || WC_TEMPLATE_DEBUG_MODE ) {
				$template = WC()->plugin_path() . '/templates/' . $file;
			}
		}

		if ( isset( $_GET['page_id'] ) && $_GET['page_id'] == get_option( Tour_Settings_Tab_Phys::$_tours_show_page_id ) ) {
			wp_safe_redirect( home_url( '?is_tour=1' ) );
		}

		return $template;
	}

	public static function html_cart_tour( $html_item_name, $cart_item, $cart_item_key ) {
		if ( array_key_exists( 'date_booking', $cart_item ) && array_key_exists( 'tour_date_end', $cart_item ) ) {
			$date_obj_check_in  = $cart_item['date_booking'];
			$date_obj_check_out = $cart_item['tour_date_end'];

			$html_item_name .= apply_filters( 'html_check_in_cart', '<div class="cart-item-date-check-in"><strong>' . __( 'Check in', 'travel-booking' ) . '</strong>: ' . $date_obj_check_in . '</div>', $date_obj_check_in );
			$html_item_name .= apply_filters( 'html_check_out_cart', '<div class="cart-item-date-check-out"><strong>' . __( 'Check out', 'travel-booking' ) . '</strong>: ' . $date_obj_check_out . '</div>', $date_obj_check_out );
		}

		if ( array_key_exists( 'date_check_in', $cart_item ) && array_key_exists( 'date_check_out', $cart_item ) ) {
			$date_obj_check_in  = $cart_item['date_check_in'];
			$date_obj_check_out = $cart_item['date_check_out'];

			$html_item_name .= apply_filters( 'html_check_in_cart', '<div class="cart-item-date-check-in"><strong>' . __( 'Check in', 'travel-booking' ) . '</strong>: ' . $date_obj_check_in . '</div>', $date_obj_check_in );
			$html_item_name .= apply_filters( 'html_check_out_cart', '<div class="cart-item-date-check-out"><strong>' . __( 'Check out', 'travel-booking' ) . '</strong>: ' . $date_obj_check_out . '</div>', $date_obj_check_out );
		}

		//		if ( ! array_key_exists( 'is_tour', $cart_item ) ) {
		//			echo apply_filters( 'woocommerce_checkout_cart_item_quantity', ' <strong class="product-quantity">' . sprintf( '&times; %s', $cart_item['quantity'] ) . '</strong>', $cart_item, $cart_item_key );
		//		} else {
		//			if ( array_key_exists( 'number_children', $cart_item ) ) {
		//				$html_item_name .= '<div class="cart-item-number-adult"><strong>' . __( 'Adults', 'travel-booking' ) . '</strong>&nbsp;<span>(' . $cart_item['data']->get_price_html() . ')</span> &times; <span>' . $cart_item['number_children'] . '</span></div>';
		//				$html_item_name .= '<div class="cart-item-number-child"><strong>' . __( 'Children', 'travel-booking' ) . '</strong>&nbsp;<span>(' . TravelPhysUtility::tour_format_price( $cart_item['price_children'] ) . ')</span> &times; <span>' . $cart_item['number_children'] . '</span></div>';
		//			} else {
		//				$html_item_name .= '<div class="cart-item-number-ticket"><strong>' . __( 'Tickets', 'travel-booking' ) . '</strong>&nbsp;<span>(' . $cart_item['data']->get_price_html() . ')</span> &times; <span>' . $cart_item['number_children'] . '</span></div>';
		//			}
		//		}

		/*** Variation ***/
		if ( isset( $cart_item['tour_variations'] ) && isset( $cart_item['tour_variations_options'] ) ) {
			$tour_variations         = array_key_exists( 'tour_variations', $cart_item ) ? $cart_item['tour_variations'] : null;
			$tour_variations_options = array_key_exists( 'tour_variations_options', $cart_item ) ? $cart_item['tour_variations_options'] : null;

			$html_item_name .= TravelPhysVariation::view_variation_detail( $tour_variations, $tour_variations_options );
		}

		/*** Group discount ***/
		if ( array_key_exists( 'tour_group_discount', $cart_item ) ) {
			$html_item_name .= apply_filters( 'html_tour_group_discount', $cart_item['tour_group_discount'] );
		}

		return $html_item_name;
	}

	public static function html_cart_tour_price( $html_item_price, $cart_item, $cart_item_key ) {
		if ( array_key_exists( 'number_children', $cart_item ) && array_key_exists( 'price_children', $cart_item ) ) {
			$price_ticket = wc_price( $cart_item['data']->get_price() );
			$price_child  = wc_price( $cart_item['price_children'] );

			$tour_item_price_content = '<p class="tour-price-item-cart"><span>' . __( 'Adult', 'travel-booking' ) . '</span>:&nbsp;' . $price_ticket . '</p>';
			$tour_item_price_content .= '<p class="tour-price-item-cart"><span>' . __( 'Child', 'travel-booking' ) . '</span>:&nbsp;' . $price_child . '</p>';

			$html_item_price = apply_filters( 'html_tour_item_price', $tour_item_price_content );
		}

		return $html_item_price;
	}

	public static function html_cart_tour_quantity( $tour_quantity, $cart_item_key, $cart_item ) {
		$class = 'input-quantity-tour-item';

		if ( array_key_exists( 'number_children', $cart_item ) ) {
			$number_children = $cart_item['number_children'];
			$name_input      = 'cart[' . $cart_item_key . '][number_children]';

			$tour_quantity_content = '<p class="tour-price-item-cart"><input type="number" class="' . $class . '" name="' . $name_input . '" value="' . $number_children . '"></p>';

			$tour_quantity .= apply_filters( 'html_tour_quantity_children', $tour_quantity_content );
		}

		return $tour_quantity;
	}

	public static function html_order_tour( $html_order_item_name, $item, $is_visible ) {
		if ( array_key_exists( 'date_booking', $item ) && array_key_exists( 'tour_date_end', $item ) ) {
			$date_obj_check_in  = $item['date_booking'];
			$date_obj_check_out = $item['tour_date_end'];

			$html_order_item_name .= apply_filters( 'html_check_in_cart', '<div class="cart-item-date-check-in"><strong>' . __( 'Check in', 'travel-booking' ) . '</strong>: ' . $date_obj_check_in . '</div>', $date_obj_check_in );
			$html_order_item_name .= apply_filters( 'html_check_out_cart', '<div class="cart-item-date-check-out"><strong>' . __( 'Check out', 'travel-booking' ) . '</strong>: ' . $date_obj_check_out . '</div>', $date_obj_check_out );
		}

		if ( array_key_exists( 'date_check_in', $item ) && array_key_exists( 'date_check_out', $item ) ) {
			$date_obj_check_in  = $item['date_check_in'];
			$date_obj_check_out = $item['date_check_out'];

			$html_order_item_name .= '<p class="cart-item-date-check-in">' . __( 'Check in', 'hotel-booking' ) . ': ' . $date_obj_check_in . '</p>';
			$html_order_item_name .= '<p class="cart-item-date-check-out">' . __( 'Check out', 'hotel-booking' ) . ': ' . $date_obj_check_out . '</p>';
		}

		return $html_order_item_name;
	}
}

TravelPhysTemplateLoader::init();
