<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Travel Order
 *
 * @author  physcode
 * @version 1.2.7
 */
class TravelPhysOrder {
	public static function init() {
		add_filter( 'woocommerce_hidden_order_itemmeta', array( __CLASS__, 'remove_order_item_meta_fields_backend' ) );
		add_action( 'woocommerce_before_order_itemmeta', array( __CLASS__, 'show_booking_date_order_phys_backend' ), 11, 3 );

		//		add_action( 'woocommerce_after_order_itemmeta', array( __CLASS__, 'travel_show_item_meta' ), 11, 3 );

		/*** Personal Information ***/
		add_action( 'woocommerce_admin_order_data_after_order_details', array( __CLASS__, 'personal_information_order_backend' ), 11, 1 );
		//		add_action( 'woocommerce_admin_order_items_after_line_items', array( __CLASS__, 'personal_information_order_backend' ), 999, 1 );
	}

	public static function remove_order_item_meta_fields_backend( $fields ) {
		$fields[] = '_date_booking';
		$fields[] = '_number_children';
		$fields[] = '_price_children';
		$fields[] = '_price_adults';
		$fields[] = '_currency';
		$fields[] = '_tour_variations';
		$fields[] = '_tour_variations_options';
		$fields[] = '_date_check_in';
		$fields[] = '_date_check_out';
		$fields[] = '_is_tour';
		$fields[] = '_tour_date_end';
		$fields[] = '_tour_group_discount';

		return $fields;
	}

	public static function show_booking_date_order_phys_backend( $item_id, $item, $_product ) {
		$order                   = WC_Order_Factory::get_order_item( $item_id );
		$qty                     = wc_get_order_item_meta( $item_id, '_qty', true );
		$price_adults            = wc_get_order_item_meta( $item_id, '_price_adults', true );
		$number_children         = wc_get_order_item_meta( $item_id, '_number_children', true );
		$price_children          = wc_get_order_item_meta( $item_id, '_price_children', true );
		$date_booking            = wc_get_order_item_meta( $item_id, '_date_booking', true );
		$date_end                = wc_get_order_item_meta( $item_id, '_tour_date_end', true );
		$date_check_in           = wc_get_order_item_meta( $item_id, '_date_check_in', true );
		$date_check_out          = wc_get_order_item_meta( $item_id, '_date_check_out', true );
		$tour_variations         = wc_get_order_item_meta( $item_id, '_tour_variations', true );
		$tour_variations_options = wc_get_order_item_meta( $item_id, '_tour_variations_options', true );
		$is_tour                 = wc_get_order_item_meta( $item_id, '_is_tour', true ) !== '' ? wc_get_order_item_meta( $item_id, '_is_tour', true ) : false;
		$tour_group_discount     = wc_get_order_item_meta( $item_id, '_tour_group_discount', true );

		if ( $is_tour ) {
			if ( $date_booking !== '' && $date_end !== '' ) {
				echo '<div> ' . __( 'Date check in', 'travel-booking' ) . ':&nbsp;' . $date_booking . '</div>';
				echo '<div> ' . __( 'Date check out', 'travel-booking' ) . ':&nbsp;' . $date_end . '</div>';
			}

			if ( $date_check_in !== '' && $date_check_out !== '' ) {
				echo '<div> ' . __( 'Date check in', 'travel-booking' ) . ':&nbsp;' . $date_check_in . '</div>';
				echo '<div> ' . __( 'Date check out', 'travel-booking' ) . ':&nbsp;' . $date_check_out . '</div>';
			}

			if ( isset( $number_children ) && $number_children !== '' ) {
				echo '<div> ' . __( 'Adults', 'travel-booking' ) . ':&nbsp;' . TravelPhysUtility::tour_format_price( $price_adults ) . ' &times; ' . $qty . '</div>';
				echo '<div> ' . __( 'Children', 'travel-booking' ) . ':&nbsp;' . TravelPhysUtility::tour_format_price( $price_children ) . ' &times; ' . $number_children . '</div>';
			} elseif ( isset( $price_adults ) && $price_adults !== '' ) {
				echo '<div> ' . __( 'Tickets', 'travel-booking' ) . ':&nbsp;' . TravelPhysUtility::tour_format_price( $price_adults ) . ' &times; ' . $qty . '</div>';

			}

			/*** Variation ***/
			if ( isset( $tour_variations ) && is_object( $tour_variations ) && isset( $tour_variations_options ) && is_object( $tour_variations_options ) ) {
				if ( ! is_null( $tour_variations_options ) ) {
					echo TravelPhysVariation::view_variation_detail( $tour_variations, $tour_variations_options );
				}
			}

			/*** Group discount ***/
			if ( isset( $tour_group_discount ) && $tour_group_discount !== '' ) {
				echo '<div>' . $tour_group_discount . '</div>';
			}
		}
	}

	public static function personal_information_order_backend( $order ) {

		$travel_personal_information_option = get_post_meta( $order->get_id(), 'travel_personal_information_option', true );

		if ( $travel_personal_information_option != '' ) {
			$order_items = $order->get_items();
			?>
			<div class="clear"></div>

			<div class="wrapper-personal-information-order">
				<h3><?php echo __( 'Personal Information', 'travel-booking' ) ?></h3>
				<?php
				$count = 1;
				foreach ( $order_items as $item ) {
					$tour      = $item->get_data();
					$tour_id   = $tour['product_id'];
					$qty_adult = $tour['quantity'];
					$key       = $tour_id . '-';
					$is_tour   = wc_get_order_item_meta( $item->get_id(), '_is_tour', true );

					if ( $is_tour && $is_tour != '' ) {
						echo '<h5>' . $tour['name'] . '</h5>';

						$travel_personal_information_option = get_post_meta( $order->get_id(), 'travel_personal_information_option', true );

						if ( $travel_personal_information_option != '' ) {
							$travel_personal_information_option_obj = json_decode( $travel_personal_information_option );

							for ( $i = 1; $i <= $qty_adult; $i ++ ) {
								echo '<div class="personal-infomation-item">
							<p><span><strong>' . __( 'Adult', 'travel-booking' ) . ' ' . $i . '</strong></span>:</p>';
								foreach ( $travel_personal_information_option_obj as $k => $info ) {
									$key_field = $key . $k . '-adult-' . $i;
									if ( $info->enable ) {
										$value = get_post_meta( $order->get_id(), $key_field, true );
										echo '<p>';
										echo '<span class="label col-sm-3">' . __( $info->label, 'travel-booking' ) . ':&nbsp;' . '</span>';
										if ( $info->type == 'text' ) {
											echo '<span>' . $value . '</span>';
										} elseif ( $info->type == 'select' ) {
											echo '<span>' . $value . '</span>';
										} elseif ( $info->type == 'radio' ) {
											echo '<span>' . $value . '</span>';
										} elseif ( $info->type == 'checkbox' ) {
											echo '<span>' . $value . '</span>';
										}
										echo '</p>';
									}
								}
								echo '</div > ';
							}
						}

					}
					?>
					<?php
					$count ++;
				}
				?>
			</div>
			<?php
		}
	}
}

TravelPhysOrder::init();